/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import javax.media.opengl.GL2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AudioDrawing {
    protected final IVideoEffectContext context;
    protected final IVideoRenderSupport support;
    protected final IBlendSupport blendSupport;
    private static volatile double maxSmoothThickness;

    protected AudioDrawing(IVideoEffectContext context, IVideoRenderSupport support, IBlendSupport blendSupport) {
        this.context = context;
        this.support = support;
        this.blendSupport = blendSupport;
        blendSupport.setProgramsClass(blendSupport.getUnmultSrcClass());
    }

    protected IVideoBuffer draw(DataProvider dataProvider, IAnimatableVec2d aStartPoint, IAnimatableVec2d aEndPoint, IAnimatableDouble aHeight, IAnimatableDouble aThickness, IAnimatableColor aColor, IAnimatableEnum<Style> aStyle, IAnimatableBoolean aSmoothing, IAnimatableEnum<BlendMode> aBlendMode, IAnimatableDouble aOpacity) {
        IVideoBuffer original;
        VideoBounds bounds;
        BlendMode blendMode = (BlendMode)this.context.value(aBlendMode);
        if (blendMode == BlendMode.NONE) {
            bounds = this.context.getPreviousBounds();
            original = this.context.createVideoBuffer(bounds);
        } else {
            original = this.context.doPreviousEffect();
            bounds = original.getBounds();
        }
        if (bounds.isEmpty()) {
            return original;
        }
        IVideoBuffer drawing = null;
        try {
            dataProvider.init();
            Resolution resolution = this.context.getVideoResolution();
            drawing = this.draw(bounds, dataProvider, resolution.scale((Vec2d)this.context.value((IAnimatableValue)aStartPoint)), resolution.scale((Vec2d)this.context.value((IAnimatableValue)aEndPoint)), resolution.scale(((Double)this.context.value((IAnimatableValue)aHeight)).doubleValue()), resolution.scale(((Double)this.context.value((IAnimatableValue)aThickness)).doubleValue()), (Color)this.context.value((IAnimatableValue)aColor), (Style)((Object)this.context.value(aStyle)), (Boolean)this.context.value((IAnimatableValue)aSmoothing));
            double opacity = (Double)this.context.value((IAnimatableValue)aOpacity) / 100.0;
            IVideoBuffer iVideoBuffer = this.blendSupport.blend(drawing, original, null, blendMode, opacity, this.context);
            return iVideoBuffer;
        }
        finally {
            if (original != null) {
                original.dispose();
            }
            if (drawing != null) {
                drawing.dispose();
            }
            dataProvider.dispose();
        }
    }

    private IVideoBuffer draw(final VideoBounds bounds, final DataProvider dataProvider, final Vec2d startPoint, final Vec2d endPoint, final double height, final double thickness, final Color color, final Style style, final boolean smoothing) {
        IVideoBuffer buffer = null;
        try {
            Runnable operation = new Runnable(){

                public void run() {
                    AudioDrawing.this.support.ortho2D(bounds);
                    AudioDrawing.this.draw(dataProvider, startPoint, endPoint, height, thickness, color, style, smoothing);
                }
            };
            int pushAttribs = 57607;
            buffer = this.context.createVideoBuffer(bounds);
            buffer.clear();
            this.support.useFramebuffer(operation, pushAttribs, buffer, new IVideoBuffer[0]);
            IVideoBuffer result = buffer;
            buffer = null;
            IVideoBuffer iVideoBuffer = result;
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    private void draw(DataProvider dataProvider, Vec2d startPoint, Vec2d endPoint, double height, double thickness, Color color, Style style, boolean smoothing) {
        GL2 gl = this.context.getGL().getGL2();
        double dx = endPoint.x - startPoint.x;
        double dy = endPoint.y - startPoint.y;
        gl.glMatrixMode(5888);
        gl.glTranslatef((float)startPoint.x, (float)startPoint.y, 0.0f);
        gl.glRotatef((float)Math.toDegrees(Math.atan2(dy, dx)), 0.0f, 0.0f, 1.0f);
        gl.glScalef((float)Math.sqrt(dx * dx + dy * dy), (float)height, 1.0f);
        if (smoothing) {
            thickness = Math.min(thickness, this.getMaxSmoothThickness());
            gl.glDisable(2929);
            gl.glEnable(2848);
            gl.glEnable(2832);
            gl.glHint(3154, 4354);
            gl.glHint(3153, 4354);
            gl.glEnable(3042);
            gl.glBlendFunc(1, 1);
            gl.glBlendEquation(32776);
        }
        thickness = Math.max(1.0E-10, thickness);
        gl.glLineWidth((float)thickness);
        gl.glPointSize((float)thickness);
        color = color.clamp();
        float a = (float)color.a;
        float r = (float)color.r * a;
        float g = (float)color.g * a;
        float b = (float)color.b * a;
        gl.glColor4f(r, g, b, a);
        int dataCount = dataProvider.getDataCount();
        switch (style) {
            case BARS: {
                float adjustment = (float)(smoothing ? 0.0 : 1.0 / height);
                gl.glBegin(1);
                int i = 0;
                while (i < dataCount) {
                    gl.glVertex2f((float)i / (float)(dataCount - 1), dataProvider.getDataLower(i));
                    gl.glVertex2f((float)i / (float)(dataCount - 1), dataProvider.getDataUpper(i) - adjustment);
                    ++i;
                }
                gl.glEnd();
                if (!smoothing) break;
                gl.glBegin(0);
                i = 0;
                while (i < dataCount) {
                    gl.glVertex2f((float)i / (float)(dataCount - 1), dataProvider.getDataLower(i));
                    gl.glVertex2f((float)i / (float)(dataCount - 1), dataProvider.getDataUpper(i) - adjustment);
                    ++i;
                }
                gl.glEnd();
                break;
            }
            case LINES: {
                gl.glBegin(3);
                if (dataCount > 1) {
                    int i = 0;
                    while (i < dataCount) {
                        gl.glVertex2f((float)i / (float)(dataCount - 1), dataProvider.getData(i));
                        ++i;
                    }
                } else {
                    float data = dataProvider.getData(0);
                    gl.glVertex2f(0.0f, data);
                    gl.glVertex2f(1.0f, data);
                }
                gl.glEnd();
                if (!smoothing) break;
            }
            case DOTS: {
                gl.glBegin(0);
                if (dataCount > 1) {
                    int i = 0;
                    while (i < dataCount) {
                        gl.glVertex2f((float)i / (float)(dataCount - 1), dataProvider.getData(i));
                        ++i;
                    }
                } else if (style == Style.LINES) {
                    float data = dataProvider.getData(0);
                    gl.glVertex2f(0.0f, data);
                    gl.glVertex2f(1.0f, data);
                } else {
                    gl.glVertex2f(0.5f, dataProvider.getData(0));
                }
                gl.glEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double getMaxSmoothThickness() {
        if (maxSmoothThickness != 0.0) return maxSmoothThickness;
        Class<AudioDrawing> clazz = AudioDrawing.class;
        synchronized (AudioDrawing.class) {
            if (maxSmoothThickness != 0.0) return maxSmoothThickness;
            GL2 gl = this.context.getGL().getGL2();
            float[] range = new float[2];
            gl.glGetFloatv(2850, range, 0);
            double max = range[1];
            gl.glGetFloatv(2834, range, 0);
            maxSmoothThickness = Math.min(max, (double)range[1]);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return maxSmoothThickness;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Channel {
        MONO,
        LEFT,
        RIGHT;

    }

    protected static interface DataProvider {
        public void init();

        public void dispose();

        public int getDataCount();

        public float getDataLower(int var1);

        public float getDataUpper(int var1);

        public float getData(int var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Style {
        BARS,
        LINES,
        DOTS;

    }
}

