/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.keying;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.effects.keying.KeyingShaders;
import ch.kuramo.javie.effects.keying.Smoothing;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import java.util.Set;
import javax.media.opengl.GLUniformData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Effect(id="ch.kuramo.javie.HSLKey", category="ch.kuramo.javie.api.effectCategory.keying")
public class HSLKey {
    @Property(value="1,1,1")
    private IAnimatableColor keyColor;
    @Property(value="10", min="0", max="360")
    private IAnimatableVec2d similarityHue;
    @Property(value="10", min="0", max="200")
    private IAnimatableVec2d similaritySat;
    @Property(value="10", min="0", max="100")
    private IAnimatableVec2d similarityLuma;
    @Property(value="10", min="0", max="360")
    private IAnimatableVec2d blendHue;
    @Property(value="10", min="0", max="200")
    private IAnimatableVec2d blendSat;
    @Property(value="10", min="0", max="100")
    private IAnimatableVec2d blendLuma;
    @Property(value="1", min="0", max="3")
    private IAnimatableVec2d correctionHue;
    @Property(value="1", min="0", max="2")
    private IAnimatableDouble correctionSat;
    @Property(value="0", min="0", max="1")
    private IAnimatableDouble correctionAlpha;
    @Property
    private IAnimatableEnum<Smoothing> smoothing;
    @Property
    private IAnimatableBoolean maskOnly;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram keyingProgram;
    private final IShaderProgram maskOnlyProgram;
    private final IShaderProgram smoothingLowProgram;
    private final IShaderProgram smoothingHighProgram;

    @Inject
    public HSLKey(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.keyingProgram = shaders.getProgram(KeyingShaders.class, "HSL_KEY");
        this.maskOnlyProgram = shaders.getProgram(KeyingShaders.class, "HSL_KEY_MASK_ONLY");
        this.smoothingLowProgram = shaders.getProgram(KeyingShaders.class, "SMOOTHING_LOW");
        this.smoothingHighProgram = shaders.getProgram(KeyingShaders.class, "SMOOTHING_HIGH");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer buffer;
        IShaderProgram program1;
        IVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds bounds = input.getBounds();
        if (bounds.isEmpty()) {
            return input;
        }
        Smoothing smoothing = (Smoothing)((Object)this.context.value(this.smoothing));
        boolean maskOnly = (Boolean)this.context.value((IAnimatableValue)this.maskOnly);
        IShaderProgram iShaderProgram = program1 = maskOnly ? this.maskOnlyProgram : this.keyingProgram;
        IShaderProgram program2 = smoothing == Smoothing.LOW ? this.smoothingLowProgram : (smoothing == Smoothing.HIGH ? this.smoothingHighProgram : null);
        try {
            buffer = this.support.useShaderProgram(program1, this.prepareUniforms(), null, new IVideoBuffer[]{input});
        }
        finally {
            input.dispose();
        }
        if (program2 == null) {
            return buffer;
        }
        try {
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(program2, uniforms, null, new IVideoBuffer[]{buffer});
            return iVideoBuffer;
        }
        finally {
            buffer.dispose();
        }
    }

    private Set<GLUniformData> prepareUniforms() {
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        uniforms.add(new GLUniformData("texture", 0));
        Color keyColor = ((Color)this.context.value((IAnimatableValue)this.keyColor)).clamp();
        Vec2d similarityHue = (Vec2d)this.context.value((IAnimatableValue)this.similarityHue);
        Vec2d similaritySat = (Vec2d)this.context.value((IAnimatableValue)this.similaritySat);
        Vec2d similarityLuma = (Vec2d)this.context.value((IAnimatableValue)this.similarityLuma);
        Vec2d blendHue = (Vec2d)this.context.value((IAnimatableValue)this.blendHue);
        Vec2d blendSat = (Vec2d)this.context.value((IAnimatableValue)this.blendSat);
        Vec2d blendLuma = (Vec2d)this.context.value((IAnimatableValue)this.blendLuma);
        Vec2d correctionHue = (Vec2d)this.context.value((IAnimatableValue)this.correctionHue);
        double correctionSat = (Double)this.context.value((IAnimatableValue)this.correctionSat);
        double correctionAlpha = (Double)this.context.value((IAnimatableValue)this.correctionAlpha);
        double[] keyHSL = new double[3];
        this.rgb2hsl(keyColor, keyHSL);
        double hueMin = keyHSL[0] - similarityHue.x / 360.0;
        double hueMax = keyHSL[0] + similarityHue.y / 360.0;
        double satMin = keyHSL[1] - similaritySat.x / 100.0;
        double satMax = keyHSL[1] + similaritySat.y / 100.0;
        double lumaMin = keyHSL[2] - similarityLuma.x / 100.0;
        double lumaMax = keyHSL[2] + similarityLuma.y / 100.0;
        double blendHueMin = Math.max(blendHue.x / 360.0, (double)1.0E-10f);
        double blendHueMax = Math.max(blendHue.y / 360.0, (double)1.0E-10f);
        double blendSatMin = Math.max(blendSat.x / 100.0, (double)1.0E-10f);
        double blendSatMax = Math.max(blendSat.y / 100.0, (double)1.0E-10f);
        double blendLumaMin = Math.max(blendLuma.x / 100.0, (double)1.0E-10f);
        double blendLumaMax = Math.max(blendLuma.y / 100.0, (double)1.0E-10f);
        uniforms.add(new GLUniformData("similarityMin", 3, this.toFloatBuffer(hueMin, satMin, lumaMin)));
        uniforms.add(new GLUniformData("similarityMax", 3, this.toFloatBuffer(hueMax, satMax, lumaMax)));
        uniforms.add(new GLUniformData("blendMin", 3, this.toFloatBuffer(blendHueMin, blendSatMin, blendLumaMin)));
        uniforms.add(new GLUniformData("blendMax", 3, this.toFloatBuffer(blendHueMax, blendSatMax, blendLumaMax)));
        double[] bleachHSL = new double[]{keyHSL[0], 1.0, 0.5};
        double[] bleachRGB = new double[3];
        this.hsl2rgb(bleachHSL, bleachRGB);
        uniforms.add(new GLUniformData("bleachHSL", 3, this.toFloatBuffer(bleachHSL[0], bleachHSL[1], bleachHSL[2])));
        uniforms.add(new GLUniformData("bleachRGB", 3, this.toFloatBuffer(bleachRGB[0], bleachRGB[1], bleachRGB[2])));
        uniforms.add(new GLUniformData("correctionHue", 2, this.toFloatBuffer(correctionHue.x, correctionHue.y)));
        uniforms.add(new GLUniformData("correctionSat", (float)(2.0 - correctionSat)));
        uniforms.add(new GLUniformData("correctionAlpha", (float)correctionAlpha));
        return uniforms;
    }

    private FloatBuffer toFloatBuffer(double ... d) {
        float[] f = new float[d.length];
        int i = 0;
        while (i < d.length) {
            f[i] = (float)d[i];
            ++i;
        }
        return FloatBuffer.wrap(f);
    }

    private void rgb2hsl(Color rgb, double[] hsl) {
        double hue;
        double sat;
        double min = Math.min(Math.min(rgb.r, rgb.g), rgb.b);
        double max = Math.max(Math.max(rgb.r, rgb.g), rgb.b);
        double dmax = max - min;
        double luma = (max + min) * 0.5;
        if (dmax == 0.0) {
            sat = 0.0;
            hue = 0.0;
        } else {
            sat = luma < 0.5 ? dmax / (max + min) : dmax / (2.0 - max - min);
            double dr = ((max - rgb.r) / 6.0 + dmax / 2.0) / dmax;
            double dg = ((max - rgb.g) / 6.0 + dmax / 2.0) / dmax;
            double db = ((max - rgb.b) / 6.0 + dmax / 2.0) / dmax;
            double d = rgb.r == max ? db - dg : (hue = rgb.g == max ? 0.3333333333333333 + dr - db : 0.6666666666666666 + dg - dr);
            if (hue < 0.0) {
                hue += 1.0;
            } else if (hue > 1.0) {
                hue -= 1.0;
            }
        }
        hsl[0] = hue;
        hsl[1] = sat;
        hsl[2] = luma;
    }

    private void hsl2rgb(double[] hsl, double[] rgb) {
        double hue = hsl[0];
        double sat = hsl[1];
        double luma = hsl[2];
        if (hue > 1.0) {
            hue -= 1.0;
        }
        if (sat == 0.0) {
            rgb[1] = rgb[2] = luma;
            rgb[0] = rgb[2];
        } else {
            double t2 = luma < 0.5 ? luma * (1.0 + sat) : luma + sat - luma * sat;
            double t1 = luma * 2.0 - t2;
            rgb[0] = this.hue2rgb(t1, t2, hue + 0.3333333333333333);
            rgb[1] = this.hue2rgb(t1, t2, hue);
            rgb[2] = this.hue2rgb(t1, t2, hue - 0.3333333333333333);
        }
    }

    private double hue2rgb(double t1, double t2, double hue) {
        if (hue < 0.0) {
            hue += 1.0;
        } else if (hue > 1.0) {
            hue -= 1.0;
        }
        return hue * 6.0 < 1.0 ? t1 + (t2 - t1) * 6.0 * hue : (hue * 2.0 < 1.0 ? t2 : (hue * 3.0 < 2.0 ? t1 + (t2 - t1) * (0.6666666666666666 - hue) * 6.0 : t1));
    }
}

