/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.time;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.Echo", category="ch.kuramo.javie.api.effectCategory.time")
public class Echo {
    @Property(value="-0.0333")
    private IAnimatableDouble echoTime;
    @Property(value="1", min="0")
    private IAnimatableInteger numberOfEchoes;
    @Property(value="1", min="0", max="1")
    private IAnimatableDouble startingIntensity;
    @Property(value="1", min="0")
    private IAnimatableDouble decay;
    @Property
    private IAnimatableEnum<EchoOperator> echoOperator;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final Map<EchoOperator, IShaderProgram> programs = new EnumMap<EchoOperator, IShaderProgram>(EchoOperator.class);
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] ADD = Echo.createProgramSource("add");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] MAXIMUM = Echo.createProgramSource("lighten");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] MINIMUM = Echo.createProgramSource("darken");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] SCREEN = Echo.createProgramSource("screen");
    @ShaderSource(attach={"ch.kuramo.javie.core.shaders.BlendModeShaders.blend_functions"})
    public static final String[] COMPOSITE = Echo.createProgramSource("normal");

    @Inject
    public Echo(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.programs.put(EchoOperator.ADD, shaders.getProgram(Echo.class, "ADD"));
        this.programs.put(EchoOperator.MAXIMUM, shaders.getProgram(Echo.class, "MAXIMUM"));
        this.programs.put(EchoOperator.MINIMUM, shaders.getProgram(Echo.class, "MINIMUM"));
        this.programs.put(EchoOperator.SCREEN, shaders.getProgram(Echo.class, "SCREEN"));
        this.programs.put(EchoOperator.COMPOSITE_IN_BACK, shaders.getProgram(Echo.class, "COMPOSITE"));
        this.programs.put(EchoOperator.COMPOSITE_IN_FRONT, shaders.getProgram(Echo.class, "COMPOSITE"));
    }

    public VideoBounds getVideoBounds() {
        Time time = this.context.getTime();
        double echoTime = (Double)this.context.value((IAnimatableValue)this.echoTime);
        int numberOfEchoes = (Integer)this.context.value((IAnimatableValue)this.numberOfEchoes);
        VideoBounds bounds = null;
        int i = 0;
        while (i <= numberOfEchoes) {
            Time t = time.add(new Time(Math.round((double)i * echoTime * (double)time.timeScale), time.timeScale));
            this.context.setTime(t);
            VideoBounds b = this.context.getPreviousBounds();
            if (!b.isEmpty()) {
                if (bounds == null) {
                    bounds = b;
                } else {
                    double left = Math.min(b.x, bounds.x);
                    double top = Math.min(b.y, bounds.y);
                    double right = Math.max(b.x + (double)b.width, bounds.x + (double)bounds.width);
                    double bottom = Math.max(b.y + (double)b.height, bounds.y + (double)bounds.height);
                    bounds = new VideoBounds(left, top, (int)Math.ceil(right - left), (int)Math.ceil(bottom - top));
                }
            }
            ++i;
        }
        if (bounds == null) {
            bounds = new VideoBounds(0, 0);
        }
        return bounds;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IVideoBuffer doVideoEffect() {
        time = this.context.getTime();
        echoTime = (Double)this.context.value((IAnimatableValue)this.echoTime);
        numberOfEchoes = (Integer)this.context.value((IAnimatableValue)this.numberOfEchoes);
        startingIntensity = (Double)this.context.value((IAnimatableValue)this.startingIntensity);
        decay = (Double)this.context.value((IAnimatableValue)this.decay);
        op = (EchoOperator)this.context.value(this.echoOperator);
        dstIn = null;
        try {
            i = 0;
            while (i <= numberOfEchoes) {
                echoIndex = op == EchoOperator.COMPOSITE_IN_FRONT ? numberOfEchoes - i : i;
                intensity = Math.min(1.0, startingIntensity * Math.pow(decay, echoIndex));
                t = time.add(new Time(Math.round((double)echoIndex * echoTime * (double)time.timeScale), time.timeScale));
                this.context.setTime(t);
                tmpBuffers = new HashSet<IVideoBuffer>();
                try {
                    src = this.context.doPreviousEffect();
                    tmpBuffers.add(src);
                    if (src.getBounds().isEmpty()) {
                    }
                    if (dstIn == null) {
                        dstIn = this.context.createVideoBuffer(src.getBounds());
                        dstIn.clear();
                    }
                    b1 = src.getBounds();
                    b2 = dstIn.getBounds();
                    left = Math.min(b1.x, b2.x);
                    top = Math.min(b1.y, b2.y);
                    right = Math.max(b1.x + (double)b1.width, b2.x + (double)b2.width);
                    bottom = Math.max(b1.y + (double)b1.height, b2.y + (double)b2.height);
                    bounds = new VideoBounds(left, top, (int)Math.ceil(right - left), (int)Math.ceil(bottom - top));
                    dstOut = this.context.createVideoBuffer(bounds);
                    tmpBuffers.add(dstOut);
                    dstOut.clear();
                    uniforms = new HashSet<GLUniformData>();
                    uniforms.add(new GLUniformData("texDst", 0));
                    uniforms.add(new GLUniformData("texSrc", 1));
                    uniforms.add(new GLUniformData("intensity", (float)intensity));
                    this.support.useShaderProgram(this.programs.get((Object)op), uniforms, dstOut, new IVideoBuffer[]{dstIn, src});
                    tmpBuffers.add(dstIn);
                    tmpBuffers.remove(dstOut);
                    dstIn = dstOut;
                }
                finally {
                    ** for (vb : tmpBuffers)
                }
lbl-1000:
                // 1 sources

                {
                    vb.dispose();
                    continue;
                }
lbl55:
                // 1 sources

                ++i;
            }
            if (dstIn == null) {
                var35_27 = this.context.createVideoBuffer(new VideoBounds(0, 0));
                return var35_27;
            }
            this.premultiply(dstIn);
            result = dstIn;
            dstIn = null;
            var35_28 = result;
            return var35_28;
        }
        finally {
            if (dstIn != null) {
                dstIn.dispose();
            }
        }
    }

    private void premultiply(final IVideoBuffer buffer) {
        Runnable operation = new Runnable(){

            public void run() {
                GL2 gl = Echo.this.context.getGL().getGL2();
                gl.glEnable(3042);
                gl.glBlendFuncSeparate(0, 772, 0, 1);
                Echo.this.support.ortho2D(buffer);
                Echo.this.support.quad2D(buffer, new IVideoBuffer[0]);
            }
        };
        this.support.useFramebuffer(operation, 24576, buffer, new IVideoBuffer[0]);
    }

    private static final String[] createProgramSource(String name) {
        return new String[]{"uniform sampler2DRect texDst;", "uniform sampler2DRect texSrc;", "uniform float intensity;", "", String.format("vec4 blend_%s(vec4 pDst, vec4 pSrc, float intensity);", name), "", "void main(void)", "{", "\tvec4 dst = texture2DRect(texDst, gl_TexCoord[0].st);", "\tvec4 src = texture2DRect(texSrc, gl_TexCoord[1].st);", String.format("\tdst = blend_%s(vec4(dst.rgb*dst.a, dst.a), src, intensity);", name), "\tgl_FragColor = (dst.a != 0.0) ? vec4(dst.rgb/dst.a, dst.a) : vec4(0.0);", "}"};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EchoOperator {
        ADD,
        MAXIMUM,
        MINIMUM,
        SCREEN,
        COMPOSITE_IN_BACK,
        COMPOSITE_IN_FRONT;

    }
}

