/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.core.CameraLayer;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.FileItem;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.ImageSequenceItem;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.MediaItemLayer;
import ch.kuramo.javie.core.NullLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.SolidColorItem;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.CameraLayerImpl;
import ch.kuramo.javie.core.internal.CompositionItemImpl;
import ch.kuramo.javie.core.internal.FolderImpl;
import ch.kuramo.javie.core.internal.ImageSequenceItemImpl;
import ch.kuramo.javie.core.internal.LayerCompositionImpl;
import ch.kuramo.javie.core.internal.MediaFileItem;
import ch.kuramo.javie.core.internal.MediaItemLayerImpl;
import ch.kuramo.javie.core.internal.NullLayerImpl;
import ch.kuramo.javie.core.internal.ProjectImpl;
import ch.kuramo.javie.core.internal.SolidColorItemImpl;
import ch.kuramo.javie.core.internal.TextLayerImpl;
import ch.kuramo.javie.core.internal.services.ModifiedClassLoader;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import java.util.Map;
import java.util.Set;
import javassist.CannotCompileException;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtNewMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.scannotation.AnnotationDB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectElementFactoryImpl
implements ProjectElementFactory {
    private final Map<String, Class<?>> _registry = Util.newMap();
    @Inject
    private Injector _injector;

    @Override
    public void searchClasses(AnnotationDB db, ClassLoader cl) {
        Set classNames = (Set)db.getAnnotationIndex().get(ProjectElement.class.getName());
        if (classNames == null) {
            return;
        }
        ModifiedClassLoader modifiedClassLoader = new ModifiedClassLoader();
        Map<String, String> tmpMap = Util.newMap();
        ClassPool pool = new ClassPool();
        pool.appendClassPath((ClassPath)new LoaderClassPath(cl));
        block4: for (String string : classNames) {
            CtClass cc;
            try {
                cc = pool.get(string);
            }
            catch (NotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            Object[] objectArray = cc.getAvailableAnnotations();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object anno = objectArray[n2];
                if (anno instanceof ProjectElement) {
                    String type = ((ProjectElement)anno).value();
                    if (type.equals("")) {
                        type = string;
                    }
                    this.modifyClass(cc, type);
                    modifiedClassLoader.add(cc);
                    tmpMap.put(type, string);
                    continue block4;
                }
                ++n2;
            }
        }
        modifiedClassLoader.loadAll(cl);
        try {
            for (Map.Entry entry : tmpMap.entrySet()) {
                this._registry.put((String)entry.getKey(), Class.forName((String)entry.getValue(), true, cl));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new Error(classNotFoundException);
        }
    }

    private void modifyClass(CtClass cc, String type) {
        try {
            String src = String.format("public String getTYPE() { return \"%s\"; }", type.replaceAll("\"", "\\\\\""));
            cc.addMethod(CtNewMethod.make((String)src, (CtClass)cc));
        }
        catch (CannotCompileException e) {
            throw new JavieRuntimeException(e);
        }
    }

    @Override
    public <T> Class<T> getClass(String type) {
        return this._registry.get(type);
    }

    @Override
    public Project newProject() {
        ProjectImpl project = (ProjectImpl)this._injector.getInstance(ProjectImpl.class);
        project.initialize();
        return project;
    }

    @Override
    public Folder newFolder() {
        FolderImpl folder = (FolderImpl)this._injector.getInstance(FolderImpl.class);
        folder.initialize();
        return folder;
    }

    @Override
    public ImageSequenceItem newImageSequenceItem(File file, Time frameDuration) {
        ImageSequenceItemImpl item = (ImageSequenceItemImpl)this._injector.getInstance(ImageSequenceItemImpl.class);
        item.initialize(file, frameDuration);
        if (item.getMediaInput() != null) {
            return item;
        }
        item.dispose();
        return null;
    }

    @Override
    public FileItem newFileItem(File file) {
        MediaFileItem item = (MediaFileItem)this._injector.getInstance(MediaFileItem.class);
        item.initialize(file);
        if (item.getMediaInput() != null) {
            return item;
        }
        item.dispose();
        item = null;
        return null;
    }

    @Override
    public SolidColorItem newSolidColorItem(Color color, Size2i size) {
        SolidColorItemImpl item = (SolidColorItemImpl)this._injector.getInstance(SolidColorItemImpl.class);
        item.initialize(color, size);
        return item;
    }

    @Override
    public CompositionItem newCompositionItem(Composition composition) {
        CompositionItemImpl item = (CompositionItemImpl)this._injector.getInstance(CompositionItemImpl.class);
        item.initialize(composition);
        return item;
    }

    @Override
    public LayerComposition newLayerComposition(ColorMode colorMode, Size2i size, Time frameDuration, Time duration) {
        LayerCompositionImpl layerComp = (LayerCompositionImpl)this._injector.getInstance(LayerCompositionImpl.class);
        layerComp.initialize(colorMode, size, frameDuration, duration);
        return layerComp;
    }

    @Override
    public CameraLayer newCameraLayer() {
        CameraLayerImpl cameraLayer = (CameraLayerImpl)this._injector.getInstance(CameraLayerImpl.class);
        cameraLayer.initialize();
        return cameraLayer;
    }

    @Override
    public MediaItemLayer newMediaItemLayer(MediaItem mediaItem) {
        MediaInput input = mediaItem.getMediaInput();
        if (input == null) {
            return null;
        }
        MediaItemLayerImpl layer = (MediaItemLayerImpl)this._injector.getInstance(MediaItemLayerImpl.class);
        layer.initialize(mediaItem);
        return layer;
    }

    @Override
    public NullLayer newNullLayer() {
        NullLayerImpl nullLayer = (NullLayerImpl)this._injector.getInstance(NullLayerImpl.class);
        nullLayer.initialize();
        return nullLayer;
    }

    @Override
    public TextLayer newTextLayer() {
        TextLayerImpl textLayer = (TextLayerImpl)this._injector.getInstance(TextLayerImpl.class);
        textLayer.initialize();
        return textLayer;
    }
}

