/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.app.Activator;
import ch.kuramo.javie.app.widgets.WSWin32;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.FileItem;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.ImageSequenceItem;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.MediaInputPlaceholder;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.SolidColorItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.misc.ExternalProgramImageDescriptor;

public class ImageUtil {
    private static final byte[] COLOR_ICON_BYTES;
    private static final RGB RGB_BLACK;

    static {
        byte[] byArray = new byte[32];
        byArray[2] = 127;
        byArray[3] = -2;
        byArray[4] = 127;
        byArray[5] = -2;
        byArray[6] = 127;
        byArray[7] = -2;
        byArray[8] = 127;
        byArray[9] = -2;
        byArray[10] = 127;
        byArray[11] = -2;
        byArray[12] = 127;
        byArray[13] = -2;
        byArray[14] = 127;
        byArray[15] = -2;
        byArray[16] = 127;
        byArray[17] = -2;
        byArray[18] = 127;
        byArray[19] = -2;
        byArray[20] = 127;
        byArray[21] = -2;
        byArray[22] = 127;
        byArray[23] = -2;
        byArray[24] = 127;
        byArray[25] = -2;
        byArray[26] = 127;
        byArray[27] = -2;
        byArray[28] = 127;
        byArray[29] = -2;
        COLOR_ICON_BYTES = byArray;
        RGB_BLACK = new RGB(0, 0, 0);
    }

    private static ImageRegistry getRegistry() {
        return Activator.getDefault().getImageRegistry();
    }

    private static Image getColorIcon(Color color) {
        ImageRegistry registry = ImageUtil.getRegistry();
        color = color.clamp();
        final int red = (int)(color.r * 255.0);
        final int green = (int)(color.g * 255.0);
        final int blue = (int)(color.b * 255.0);
        String key = String.format("color.%d.%d.%d", red, green, blue);
        Image image = registry.get(key);
        if (image != null) {
            return image;
        }
        ImageDescriptor descriptor = new ImageDescriptor(){

            public ImageData getImageData() {
                PaletteData palette = new PaletteData(new RGB[]{RGB_BLACK, new RGB(red, green, blue)});
                return new ImageData(16, 16, 1, palette, 1, COLOR_ICON_BYTES);
            }
        };
        registry.put(key, descriptor);
        return registry.get(key);
    }

    public static Image getSolidColorItemIcon(SolidColorItem item) {
        return ImageUtil.getColorIcon(item.getColor());
    }

    public static Image getFileItemIcon(FileItem item) {
        ImageRegistry registry = ImageUtil.getRegistry();
        String name = item.getFile().getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot == -1) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        String extension = name.substring(lastDot + 1);
        String key = "program." + extension;
        Image image = registry.get(key);
        if (image != null) {
            return image;
        }
        Program program = Program.findProgram((String)extension);
        if (program == null) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        ExternalProgramImageDescriptor descriptor = new ExternalProgramImageDescriptor(program);
        registry.put(key, (ImageDescriptor)descriptor);
        return registry.get(key);
    }

    public static Image getItemIcon(Item item) {
        if (item instanceof Folder) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (item instanceof MediaItem && ((MediaItem)item).getMediaInput() instanceof MediaInputPlaceholder) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        }
        if (item instanceof ImageSequenceItem) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        if (item instanceof FileItem) {
            return ImageUtil.getFileItemIcon((FileItem)item);
        }
        if (item instanceof SolidColorItem) {
            return ImageUtil.getSolidColorItemIcon((SolidColorItem)item);
        }
        if (item instanceof CompositionItem) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
    }

    public static Image getCameraIcon() {
        return ImageUtil.getRegistry().get("IMG_CAMERA");
    }

    public static Image getNullIcon() {
        return ImageUtil.getColorIcon(Color.BLACK);
    }

    public static Image getTextIcon() {
        return ImageUtil.getRegistry().get("IMG_TEXT");
    }

    public static Image getKeyframeIcon(Interpolation interpolation, boolean selected) {
        String key = "IMG_KF_" + interpolation.name() + (selected ? "_SELECT" : "");
        return ImageUtil.getRegistry().get(key);
    }

    public static Image getStopwatchIcon(boolean hasKeyframe) {
        return ImageUtil.getRegistry().get(hasKeyframe ? "IMG_STOPWATCH_HAS_KF" : "IMG_STOPWATCH_NO_KF");
    }

    public static Image getSwitchesHeaderIcon() {
        return ImageUtil.getRegistry().get("IMG_HEADER_SWITCHES");
    }

    public static Image getShowhideHeaderIcon() {
        return ImageUtil.getRegistry().get(WSWin32.isXPThemed() ? "IMG_HEADER_SHOWHIDE_XP_THEMED" : (WSWin32.isXPClassic() ? "IMG_HEADER_SHOWHIDE_XP_CLASSIC" : "IMG_HEADER_SHOWHIDE"));
    }

    public static ImageDescriptor getPlayerZoomIcon() {
        return ImageUtil.getRegistry().getDescriptor("IMG_PLAYER_ZOOM");
    }

    public static ImageDescriptor getPlayerResolutionIcon() {
        return ImageUtil.getRegistry().getDescriptor("IMG_PLAYER_RESOLUTION");
    }

    public static ImageDescriptor getPlayerMuteIcon(boolean muted) {
        return ImageUtil.getRegistry().getDescriptor(muted ? "IMG_PLAYER_MUTE" : "IMG_PLAYER_NOMUTE");
    }

    public static ImageDescriptor getPlayerInfoIcon() {
        return ImageUtil.getRegistry().getDescriptor("IMG_PLAYER_INFO");
    }

    public static ImageDescriptor getPlayerPinIcon() {
        return ImageUtil.getRegistry().getDescriptor("IMG_PLAYER_PIN");
    }

    public static ImageDescriptor getCompositionSettingsIcon() {
        return ImageUtil.getRegistry().getDescriptor("IMG_COMP_SETTINGS");
    }

    public static ImageDescriptor getCompositionMotionBlurIcon() {
        return ImageUtil.getRegistry().getDescriptor("IMG_COMP_MBLUR");
    }

    public static ImageDescriptor getCompositionFrameBlendIcon() {
        return ImageUtil.getRegistry().getDescriptor("IMG_COMP_FBLEND");
    }

    public static ImageDescriptor getCompositionShyIcon() {
        return ImageUtil.getRegistry().getDescriptor("IMG_COMP_SHY");
    }

    private ImageUtil() {
    }
}

