/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.player;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.player.PlayerLock;
import ch.kuramo.javie.app.player.PlayerThreadEvent;
import ch.kuramo.javie.app.player.PlayerThreadListener;
import ch.kuramo.javie.app.player.TimeKeeper;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicReference;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.eclipse.core.runtime.ListenerList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AudioThread
extends Thread {
    private static final Logger _logger = LoggerFactory.getLogger(AudioThread.class);
    private final SourceDataLine _line;
    private final TimeKeeper _timeKeeper;
    private final MediaItem _mediaItem;
    private final AtomicReference<Time> _newTime = new AtomicReference();
    private final ListenerList _playerThreadListeners = new ListenerList();
    private final Object _monitor = new Object();
    private volatile boolean _playing;
    private volatile boolean _finished;
    private volatile boolean _muted;
    @Inject
    private RenderContext _context;
    @Inject
    private IArrayPools _arrayPools;

    public AudioThread(MediaItem mediaItem) throws LineUnavailableException {
        super("AudioThread: " + mediaItem.getName());
        this.setPriority(this.getThreadGroup().getMaxPriority());
        MediaInput input = mediaItem.getMediaInput();
        if (input == null) {
            throw new IllegalArgumentException("no MediaInput is available");
        }
        if (!input.isAudioAvailable()) {
            throw new IllegalArgumentException("no audio is available");
        }
        AudioFormat lineFormat = new AudioFormat(48000.0f, 16, 2, true, ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN));
        DataLine.Info lineInfo = new DataLine.Info(SourceDataLine.class, lineFormat);
        this._line = (SourceDataLine)AudioSystem.getLine(lineInfo);
        this._line.open(lineFormat, lineFormat.getFrameSize() * (int)(lineFormat.getFrameRate() / 10.0f));
        this._timeKeeper = TimeKeeper.fromAudioLine(this._line);
        InjectorHolder.getInjector().injectMembers((Object)this);
        this._mediaItem = mediaItem;
    }

    public TimeKeeper getTimeKeeper() {
        return this._timeKeeper;
    }

    public boolean isMuted() {
        return this._muted;
    }

    public void setMuted(boolean muted) {
        this._muted = muted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            MediaInput input = this._mediaItem.getMediaInput();
            Time duration = input.getDuration();
            AudioMode audioMode = AudioMode.STEREO_48KHZ_INT16;
            int frameCount = audioMode.sampleRate / 10;
            this._line.start();
            this._context.activate();
            Time nextTime = Time.fromFrameNumber((long)0L, (Time)audioMode.sampleDuration);
            while (this.waitForPlaying()) {
                IAudioBuffer ab;
                Time time;
                block22: {
                    time = this._newTime.getAndSet(null);
                    if (time != null) {
                        this._line.flush();
                        this._timeKeeper.setTime(time);
                    } else {
                        time = nextTime;
                    }
                    if (!time.before(duration)) {
                        this._line.drain();
                        Object object = this._monitor;
                        synchronized (object) {
                            this._playing = false;
                        }
                        this.fireThreadEndOfDuration(time);
                        continue;
                    }
                    ab = null;
                    if (!this._muted) {
                        this._context.reset();
                        this._context.setAudioMode(audioMode);
                        this._context.setAudioAnimationRate(audioMode.sampleRate / 100);
                        this._context.setAudioFrameCount(frameCount);
                        this._context.setVideoResolution(Resolution.FULL);
                        if (this._mediaItem instanceof CompositionItem) {
                            Composition comp = ((CompositionItem)this._mediaItem).getComposition();
                            this._context.setVideoFrameDuration(comp.getFrameDuration());
                            PlayerLock.readLock().lock();
                            try {
                                try {
                                    comp.prepareExpression(this._context.createInitialExpressionScope(comp));
                                    ab = input.getAudioChunk(time);
                                }
                                catch (Exception e) {
                                    _logger.error("error getting audio chunk", (Throwable)e);
                                    PlayerLock.readLock().unlock();
                                    break block22;
                                }
                            }
                            catch (Throwable throwable) {
                                PlayerLock.readLock().unlock();
                                throw throwable;
                            }
                            PlayerLock.readLock().unlock();
                        } else {
                            try {
                                ab = input.getAudioChunk(time);
                            }
                            catch (Exception e) {
                                _logger.error("error getting audio chunk", (Throwable)e);
                            }
                        }
                    }
                }
                if (ab != null) {
                    this.write(ab);
                    ab.dispose();
                } else {
                    this.writeZero(frameCount);
                }
                nextTime = time.add(Time.fromFrameNumber((long)(ab != null ? ab.getFrameCount() : frameCount), (Time)audioMode.sampleDuration));
                this.fireThreadRender(time);
            }
        }
        finally {
            this._context.deactivate();
            this._line.close();
        }
    }

    public void setTime(Time time) {
        this._newTime.set(time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void play(boolean play) {
        if (this._playing == play) {
            return;
        }
        Object object = this._monitor;
        synchronized (object) {
            this._playing = play;
            this._monitor.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        if (this._finished) {
            return;
        }
        Object object = this._monitor;
        synchronized (object) {
            this._finished = true;
            this._monitor.notify();
        }
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean waitForPlaying() {
        if (!this._playing) {
            this._line.flush();
            Object object = this._monitor;
            synchronized (object) {
                while (!this._finished && !this._playing) {
                    try {
                        this._monitor.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        if (!this._finished) return true;
        return false;
    }

    private void write(IAudioBuffer ab) {
        AudioMode audioMode = ab.getAudioMode();
        int dataLen = ab.getDataLength();
        int lineDataLen = this._line.getFormat().getFrameSize() * ab.getFrameCount();
        IArray pa = this._arrayPools.getByteArray(lineDataLen);
        byte[] lineBuf = (byte[])pa.getArray();
        switch (audioMode.dataType) {
            case SHORT: {
                ByteBuffer.wrap(lineBuf, 0, lineDataLen).order(ByteOrder.nativeOrder()).asShortBuffer().put((short[])ab.getData(), 0, dataLen);
                break;
            }
            case INT: {
                Object[] data = (int[])ab.getData();
                int i = 0;
                while (i < dataLen) {
                    lineBuf[i * 2] = (byte)(data[i] >>> 16 & 0xFF);
                    lineBuf[i * 2 + 1] = (byte)(data[i] >>> 24 & 0xFF);
                    ++i;
                }
                break;
            }
            case FLOAT: {
                Object[] data = (float[])ab.getData();
                int i = 0;
                while (i < dataLen) {
                    short shortVal = (short)(Math.min(Math.max((double)data[i], -1.0), 1.0) * 32767.0);
                    lineBuf[i * 2] = (byte)(shortVal & 0xFF);
                    lineBuf[i * 2 + 1] = (byte)(shortVal >>> 8 & 0xFF);
                    ++i;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audioMode.dataType);
            }
        }
        if (audioMode.sampleRate == 96000) {
            int i = 0;
            int n = dataLen / 2;
            while (i < n) {
                short s1 = (short)(lineBuf[i * 2 * 2] & 0xFF | (lineBuf[i * 2 * 2 + 1] & 0xFF) << 8);
                short s2 = (short)(lineBuf[i * 2 * 2 + 2] & 0xFF | (lineBuf[i * 2 * 2 + 3] & 0xFF) << 8);
                short s = (short)((s1 + s2) / 2);
                lineBuf[i * 2] = (byte)(s & 0xFF);
                lineBuf[i * 2 + 1] = (byte)(s >>> 8 & 0xFF);
                ++i;
            }
            lineDataLen /= 2;
        }
        this._line.write(lineBuf, 0, lineDataLen);
        pa.release();
    }

    private void writeZero(int frameCount) {
        IArray pa = this._arrayPools.getByteArray(this._line.getFormat().getFrameSize() * frameCount);
        pa.clear();
        this._line.write((byte[])pa.getArray(), 0, pa.getLength());
        pa.release();
    }

    public void addPlayerThreadListener(PlayerThreadListener listener) {
        this._playerThreadListeners.add((Object)listener);
    }

    public void removePlayerThreadListener(PlayerThreadListener listener) {
        this._playerThreadListeners.remove((Object)listener);
    }

    private void fireThreadRender(Time time) {
        PlayerThreadEvent event = new PlayerThreadEvent(this, time);
        Object[] objectArray = this._playerThreadListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((PlayerThreadListener)l).threadRender(event);
            ++n2;
        }
    }

    private void fireThreadEndOfDuration(Time time) {
        PlayerThreadEvent event = new PlayerThreadEvent(this, time);
        Object[] objectArray = this._playerThreadListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((PlayerThreadListener)l).threadEndOfDuration(event);
            ++n2;
        }
    }
}

