/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.player;

import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.app.ImageUtil;
import ch.kuramo.javie.app.player.MediaPlayer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class PlayerResolutionAction
extends Action
implements IMenuCreator {
    private static final Resolution[] RESOLUTIONS = new Resolution[]{Resolution.FULL, Resolution.HALF, Resolution.ONETHIRD, Resolution.QUARTER};
    private final MediaPlayer mediaPlayer;
    private Menu menu;

    public PlayerResolutionAction(MediaPlayer mediaPlayer) {
        super("\u89e3\u50cf\u5ea6");
        this.mediaPlayer = mediaPlayer;
        this.setImageDescriptor(ImageUtil.getPlayerResolutionIcon());
        this.setMenuCreator(this);
        this.setEnabled(mediaPlayer.hasVideo());
    }

    public void dispose() {
        this.disposeMenu();
    }

    private void disposeMenu() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public Menu getMenu(Control parent) {
        this.disposeMenu();
        if (!this.isEnabled()) {
            return null;
        }
        this.menu = new Menu(parent);
        this.addAction(this.menu, null);
        new MenuItem(this.menu, 2);
        Resolution[] resolutionArray = RESOLUTIONS;
        int n = RESOLUTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            Resolution resolution = resolutionArray[n2];
            this.addAction(this.menu, resolution);
            ++n2;
        }
        return this.menu;
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    private void addAction(Menu parent, final Resolution resolution) {
        String text = resolution == null ? "\u81ea\u52d5" : (resolution.equals((Object)Resolution.FULL) ? "\u30d5\u30eb\u753b\u8cea" : (resolution.equals((Object)Resolution.HALF) ? "1/2 \u753b\u8cea" : (resolution.equals((Object)Resolution.ONETHIRD) ? "1/3 \u753b\u8cea" : (resolution.equals((Object)Resolution.QUARTER) ? "1/4 \u753b\u8cea" : String.valueOf(String.valueOf(resolution.scale)) + " \u753b\u8cea"))));
        Action action = new Action(text, 8){

            public void run() {
                PlayerResolutionAction.this.mediaPlayer.setVideoResolution(resolution);
            }
        };
        if (resolution == null) {
            action.setChecked(this.mediaPlayer.getVideoResolution() == null);
        } else {
            action.setChecked(resolution.equals((Object)this.mediaPlayer.getVideoResolution()));
        }
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void runWithEvent(Event event) {
        if (event.widget instanceof ToolItem) {
            ToolItem toolItem = (ToolItem)event.widget;
            ToolBar control = toolItem.getParent();
            Menu menu = this.getMenu((Control)control);
            Rectangle bounds = toolItem.getBounds();
            Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
            menu.setLocation(control.toDisplay(topLeft));
            menu.setVisible(true);
        }
    }
}

