/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNewLayerOperation<T extends Layer>
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;
    private final String _data;
    @Inject
    private ProjectElementFactory _elementFactory;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public AbstractNewLayerOperation(ProjectManager projectManager, LayerComposition comp, String label) {
        super(projectManager, label);
        InjectorHolder.getInjector().injectMembers((Object)this);
        projectManager.checkComposition((Composition)comp);
        this._compId = comp.getId();
        T layer = this.createNewLayer(projectManager, comp, this._elementFactory);
        Time time0 = Time.fromFrameNumber((long)0L, (Time)comp.getFrameDuration());
        layer.setStartTime(time0);
        layer.setInPoint(time0);
        layer.setOutPoint(comp.getDuration());
        this._layerId = layer.getId();
        this._data = this._encoder.encodeElement(layer);
    }

    protected abstract T createNewLayer(ProjectManager var1, LayerComposition var2, ProjectElementFactory var3);

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        Layer layer;
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        try {
            layer = (Layer)this._decoder.decodeElement((CharSequence)this._data, Layer.class);
            layer.afterDecode(project, comp);
        }
        catch (ProjectDecodeException e) {
            throw new ExecutionException("error decoding layer data", (Throwable)e);
        }
        comp.getLayers().add(layer);
        if (pm != null) {
            pm.fireLayersAdd(comp, Collections.singleton(layer));
        }
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Layer layer = comp.getLayer(this._layerId);
        comp.getLayers().remove(layer);
        if (pm != null) {
            pm.fireLayersRemove(comp, Collections.singleton(layer));
        }
        return Status.OK_STATUS;
    }
}

