/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClearLayerKeyframesOperation<V>
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;
    private final String _property;
    private final String _data;
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;

    public ClearLayerKeyframesOperation(ProjectManager projectManager, Layer layer, String property) {
        super(projectManager, "\u30b9\u30c8\u30c3\u30d7\u30a6\u30a9\u30c3\u30c1\u306e\u89e3\u9664");
        InjectorHolder.getInjector().injectMembers((Object)this);
        LayerComposition comp = projectManager.checkLayer(layer);
        AnimatableValue avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
        if (!avalue.hasKeyframe()) {
            throw new IllegalArgumentException("no keyframes");
        }
        this._compId = comp.getId();
        this._layerId = layer.getId();
        this._property = property;
        this._data = this._encoder.encodeElement((Object)avalue);
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.clearOrRestore(true, project, pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.clearOrRestore(false, project, pm);
        return Status.OK_STATUS;
    }

    private void clearOrRestore(boolean clear, Project project, ProjectManager pm) throws ExecutionException {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Layer layer = comp.getLayer(this._layerId);
        AnimatableValue avalue = (AnimatableValue)PropertyUtil.getProperty(layer, this._property);
        if (clear) {
            avalue.clearKeyframes();
            if (pm != null) {
                Object[][] objectArray = new Object[1][];
                Object[] objectArray2 = new Object[4];
                objectArray2[0] = layer;
                objectArray2[1] = -1;
                objectArray2[2] = this._property;
                objectArray[0] = objectArray2;
                pm.fireKeyframesChange(comp, objectArray);
            }
        } else {
            this.restore(avalue);
            if (pm != null) {
                Collection keyframes = avalue.getKeyframeMap().values();
                Object[][] data = new Object[keyframes.size()][];
                int i = 0;
                for (Keyframe kf : keyframes) {
                    data[i++] = new Object[]{layer, -1, this._property, kf.time};
                }
                pm.fireKeyframesChange(comp, data);
            }
        }
    }

    private <A extends AnimatableValue<V>> void restore(A dst) throws ExecutionException {
        try {
            AnimatableValue src = (AnimatableValue)this._decoder.decodeElement((CharSequence)this._data, dst.getClass());
            dst.reset(src.getStaticValue());
            dst.setExpression(src.getExpression());
            for (Keyframe kf : src.getKeyframeMap().values()) {
                dst.putKeyframe(kf);
            }
        }
        catch (ProjectDecodeException e) {
            throw new ExecutionException("error decoding AnimatableValue data", (Throwable)e);
        }
    }
}

