/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.SortedMap;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyLayerKeyframeOperation<V>
extends ProjectOperation {
    private final String _compId;
    private final String _layerId;
    private final String _property;
    private final Collection<Keyframe<V>> _oldKeyframes;
    private volatile Keyframe<V> _newKeyframe;

    public ModifyLayerKeyframeOperation(ProjectManager projectManager, Layer layer, String property, Time time, V value, String relation, String name) {
        super(projectManager, String.valueOf(name) + "\u306e\u5909\u66f4", relation);
        LayerComposition comp = projectManager.checkLayer(layer);
        AnimatableValue avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
        Time frameDuration = comp.getFrameDuration();
        Time halfOfFrameDuration = new Time(frameDuration.timeValue / 2L, frameDuration.timeScale);
        Time t1 = time.subtract(halfOfFrameDuration);
        Time t2 = time.add(frameDuration).subtract(halfOfFrameDuration);
        SortedMap oldKeyframeMap = avalue.getKeyframeMap().subMap(t1, t2);
        this.setLabel(avalue.hasKeyframe(), !oldKeyframeMap.isEmpty(), value != null);
        this._compId = comp.getId();
        this._layerId = layer.getId();
        this._property = property;
        this._oldKeyframes = Util.newSet(oldKeyframeMap.values());
        if (value != null) {
            Keyframe kf = (Keyframe)oldKeyframeMap.get(time);
            if (kf == null) {
                Keyframe kf2;
                SortedMap head = oldKeyframeMap.headMap(time);
                SortedMap tail = oldKeyframeMap.tailMap(time);
                Keyframe kf1 = head.isEmpty() ? null : (Keyframe)head.get(head.lastKey());
                Keyframe keyframe = kf2 = tail.isEmpty() ? null : (Keyframe)tail.get(tail.firstKey());
                if (kf1 != null && kf2 != null) {
                    kf = kf2.time.subtract(time).before(time.subtract(kf1.time)) ? kf2 : kf1;
                } else if (kf1 != null) {
                    kf = kf1;
                } else if (kf2 != null) {
                    kf = kf2;
                }
            }
            this._newKeyframe = new Keyframe(time, value, this.defaultInterpolation(avalue, kf, time));
        } else {
            this._newKeyframe = null;
        }
    }

    private void setLabel(boolean hasKeyframe, boolean oldKeyframe, boolean newKeyframe) {
        if (!oldKeyframe) {
            if (!newKeyframe) {
                throw new IllegalArgumentException();
            }
            if (hasKeyframe) {
                this.setLabel("\u30ad\u30fc\u30d5\u30ec\u30fc\u30e0\u306e\u8ffd\u52a0");
            } else {
                this.setLabel("\u30b9\u30c8\u30c3\u30d7\u30a6\u30a9\u30c3\u30c1\u306e\u4f7f\u7528");
            }
        } else if (!newKeyframe) {
            this.setLabel("\u30ad\u30fc\u30d5\u30ec\u30fc\u30e0\u306e\u6d88\u53bb");
        }
    }

    private Interpolation defaultInterpolation(AnimatableValue<V> avalue, Keyframe<V> oldKeyframe, Time time) {
        if (oldKeyframe != null) {
            return oldKeyframe.interpolation;
        }
        SortedMap head = avalue.getKeyframeMap().headMap(time);
        if (!head.isEmpty()) {
            return ((Keyframe)head.get((Object)head.lastKey())).interpolation;
        }
        return avalue.getDefaultInterpolation();
    }

    @Override
    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.replaceKeyframes(this._oldKeyframes, Collections.singleton(this._newKeyframe), project, pm);
        return Status.OK_STATUS;
    }

    @Override
    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.replaceKeyframes(Collections.singleton(this._newKeyframe), this._oldKeyframes, project, pm);
        return Status.OK_STATUS;
    }

    private void replaceKeyframes(Collection<Keyframe<V>> target, Collection<Keyframe<V>> replacement, Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Layer layer = comp.getLayer(this._layerId);
        AnimatableValue avalue = (AnimatableValue)PropertyUtil.getProperty(layer, this._property);
        Map data = null;
        if (pm != null) {
            data = Util.newMap();
        }
        for (Keyframe<V> kf : target) {
            avalue.removeKeyframe(kf.time);
            if (pm == null) continue;
            data.put(kf.time, new Object[]{layer, -1, this._property, kf.time});
        }
        for (Keyframe<V> kf : replacement) {
            avalue.putKeyframe(kf);
            if (pm == null) continue;
            data.put(kf.time, new Object[]{layer, -1, this._property, kf.time});
        }
        if (pm != null) {
            pm.fireKeyframesChange(comp, (Object[][])data.values().toArray((T[])new Object[data.size()][]));
        }
    }

    @Override
    protected boolean merge(ProjectOperation operation, IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) {
        if (pm == null) {
            this.replaceKeyframes(Collections.<Keyframe<V>>emptySet(), Collections.singleton(this._newKeyframe), project, pm);
            return true;
        }
        if (!(operation instanceof ModifyLayerKeyframeOperation)) {
            return false;
        }
        ModifyLayerKeyframeOperation newOp = (ModifyLayerKeyframeOperation)operation;
        if (!(newOp._compId.equals(this._compId) && newOp._layerId.equals(this._layerId) && newOp._property.equals(this._property))) {
            return false;
        }
        Keyframe<V> newKeyframe = newOp._newKeyframe;
        if (this._newKeyframe == null || newKeyframe == null) {
            return false;
        }
        if (!this._newKeyframe.time.equals((Object)newKeyframe.time) || !this._newKeyframe.interpolation.equals((Object)newKeyframe.interpolation)) {
            return false;
        }
        if (!this._newKeyframe.value.equals(newKeyframe.value)) {
            this._newKeyframe = newKeyframe;
            this.replaceKeyframes(Collections.<Keyframe<V>>emptySet(), Collections.singleton(this._newKeyframe), project, pm);
            boolean noEffect = false;
            if (this._oldKeyframes.size() == 1) {
                Keyframe<V> oldKeyframe = this._oldKeyframes.iterator().next();
                noEffect = oldKeyframe.time.equals((Object)this._newKeyframe.time) && oldKeyframe.value.equals(this._newKeyframe.value);
            }
            this._noEffect = noEffect;
        }
        return true;
    }
}

