/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.project.ProjectEvent;
import ch.kuramo.javie.app.project.ProjectEventHub;
import ch.kuramo.javie.app.project.ProjectListener;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.app.project.ShadowOperationRunner;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.ItemLayer;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.ProjectDecoder;
import ch.kuramo.javie.core.services.ProjectElementFactory;
import ch.kuramo.javie.core.services.ProjectEncoder;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectManager
implements IOperationHistoryListener {
    private static final Logger _logger = LoggerFactory.getLogger(ProjectManager.class);
    private static final String PROJECT_MANAGER = "PROJECT_MANAGER";
    public static final String DEFAULT_NAME = "\u540d\u79f0\u672a\u8a2d\u5b9a\u30d7\u30ed\u30b8\u30a7\u30af\u30c8.jvp";
    private IWorkbenchWindow _window;
    private Project _project;
    private Project _shadow;
    private final ShadowOperationRunner shadowOperationRunner = new ShadowOperationRunner(this);
    private File _file;
    private IUndoContext _undoContext = new UndoContext();
    private IUndoableOperation _firstOperation;
    private boolean _dirty;
    private boolean _historyBusy;
    private final ListenerList _projectListeners = new ListenerList();
    @Inject
    private ProjectEncoder _encoder;
    @Inject
    private ProjectDecoder _decoder;
    @Inject
    private ProjectElementFactory _elementFactory;

    public static ProjectManager forWorkbenchWindow(IWorkbenchWindow window) {
        return (ProjectManager)window.getShell().getData(PROJECT_MANAGER);
    }

    public static ProjectManager newProject(IWorkbenchWindow window) {
        ProjectManager pm = ProjectManager.forWorkbenchWindow(window);
        if (pm != null) {
            throw new IllegalStateException("another project is opened on the window");
        }
        return new ProjectManager(null, null, window);
    }

    public static ProjectManager openProject(File file, IWorkbenchWindow window) throws IOException, ProjectDecodeException {
        ProjectManager pm = ProjectManager.forWorkbenchWindow(window);
        if (pm != null) {
            throw new IllegalStateException("another project is opened on the window");
        }
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            ProjectManager pm2 = ProjectManager.forWorkbenchWindow(w);
            if (pm2 != null && file.equals(pm2.getFile())) {
                throw new IllegalStateException("the project is already opened");
            }
            ++n2;
        }
        return new ProjectManager(ProjectManager.loadProject(file, window), file, window);
    }

    private static Project loadProject(final File file, IWorkbenchWindow window) throws IOException, ProjectDecodeException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            String line;
            String header;
            LinkedHashMap headerMap = Util.newLinkedHashMap();
            while ((header = br.readLine()) != null && (header = header.trim()).length() != 0) {
                String[] split = header.split("\\s*:\\s*", 2);
                if (split.length != 2) continue;
                headerMap.put(split[0].toLowerCase(), split[1]);
            }
            String jvpVersion = (String)headerMap.get("jvp-version");
            if (!"0.9".equals(jvpVersion)) {
                throw new ProjectDecodeException("only jvpVersion 0.9 is supported: jvpVersion=" + jvpVersion);
            }
            final StringBuilder body = new StringBuilder();
            while ((line = br.readLine()) != null) {
                body.append(line).append("\n");
            }
            final Project[] project = new Project[1];
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        monitor.beginTask("\u30d7\u30ed\u30b8\u30a7\u30af\u30c8\u3092\u8aad\u307f\u8fbc\u307f\u4e2d...", -1);
                        ProjectDecoder decoder = (ProjectDecoder)InjectorHolder.getInjector().getInstance(ProjectDecoder.class);
                        project[0] = decoder.decode((CharSequence)body.toString(), file.getParentFile());
                        monitor.done();
                    }
                    catch (ProjectDecodeException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(window.getShell()){

                protected int getShellStyle() {
                    return super.getShellStyle() | 0x10000000;
                }
            };
            try {
                dialog.run(true, false, runnable);
            }
            catch (InvocationTargetException e) {
                throw new ProjectDecodeException(e.getCause());
            }
            catch (InterruptedException e) {
                throw new ProjectDecodeException((Throwable)e);
            }
            Project project2 = project[0];
            return project2;
        }
        finally {
            br.close();
        }
    }

    private ProjectManager(Project project, File file, IWorkbenchWindow window) {
        InjectorHolder.getInjector().injectMembers((Object)this);
        this._window = window;
        if (project != null) {
            this._project = project;
            this._file = file;
        } else {
            this._project = this._elementFactory.newProject();
        }
        try {
            this._shadow = (Project)this._decoder.decodeElement((CharSequence)this._encoder.encodeElement((Object)this._project), Project.class);
            this._shadow.afterDecode();
        }
        catch (ProjectDecodeException e) {
            throw new JavieRuntimeException((Throwable)e);
        }
        IOperationHistory history = this.getOperationHistory();
        history.setLimit(this._undoContext, 10000);
        history.addOperationHistoryListener((IOperationHistoryListener)this);
        window.getShell().setData(PROJECT_MANAGER, (Object)this);
        ProjectEventHub.getHub().listen(this);
        this.fireProjectEvent(ProjectEvent.createProjectInitializeEvent(this));
        this.shadowOperationRunner.start();
    }

    protected void finalize() throws Throwable {
        this.shadowOperationRunner.end();
        if (this._project != null) {
            _logger.error("finalizing ProjectManager, but not disposed.");
        }
        super.finalize();
    }

    public void dispose() {
        this.shadowOperationRunner.end();
        IOperationHistory operationHistory = this.getOperationHistory();
        operationHistory.removeOperationHistoryListener((IOperationHistoryListener)this);
        if (this._undoContext != null) {
            operationHistory.dispose(this._undoContext, true, true, true);
            this._undoContext = null;
        }
        if (this._shadow != null) {
            for (Item i : this._shadow.getItems()) {
                i.dispose();
            }
            this._shadow = null;
        }
        if (this._project != null) {
            for (Item i : this._project.getItems()) {
                i.dispose();
            }
            this._project = null;
        }
        this.fireProjectEvent(ProjectEvent.createProjectDisposeEvent(this));
        this._window.getShell().setData(PROJECT_MANAGER, null);
    }

    public IWorkbenchWindow getWorkbenchWindow() {
        return this._window;
    }

    public Project getProject() {
        return this._project;
    }

    public Project getShadow() {
        return this._shadow;
    }

    public File getFile() {
        return this._file;
    }

    public IUndoContext getUndoContext() {
        return this._undoContext;
    }

    public void addProjectListener(ProjectListener listener) {
        this._projectListeners.add((Object)listener);
    }

    public void removeProjectListener(ProjectListener listener) {
        this._projectListeners.remove((Object)listener);
    }

    private void fireProjectEvent(ProjectEvent event) {
        Object[] objectArray = this._projectListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((ProjectListener)l).handleProjectEvent(event);
            ++n2;
        }
    }

    void fireItemNameChange(Item item) {
        this.fireProjectEvent(ProjectEvent.createItemNameChangeEvent(this, item));
    }

    void fireItemUpdate(Item item) {
        this.fireProjectEvent(ProjectEvent.createItemUpdateEvent(this, item));
    }

    void fireItemsAdd(Collection<? extends Item> items, Collection<? extends Item> relatedItems) {
        this.fireProjectEvent(ProjectEvent.createItemsAddEvent(this, items, relatedItems));
    }

    void fireItemsRemove(Collection<? extends Item> items, Collection<? extends Item> relatedItems) {
        this.fireProjectEvent(ProjectEvent.createItemsRemoveEvent(this, items, relatedItems));
    }

    void fireItemsReparent(Collection<? extends Item> items, Collection<? extends Item> relatedItems) {
        this.fireProjectEvent(ProjectEvent.createItemsReparentEvent(this, items, relatedItems));
    }

    void fireCompositionSettingsChange(Composition comp) {
        this.fireProjectEvent(ProjectEvent.createCompositionSettingsChangeEvent(this, comp));
    }

    void fireCompositionPropertyChange(Composition comp, String property) {
        this.fireProjectEvent(ProjectEvent.createCompositionPropertyChangeEvent(this, comp, property));
    }

    void fireLayerPropertyChange(Layer layer, String property) {
        this.fireProjectEvent(ProjectEvent.createLayerPropertyChangeEvent(this, layer, property));
    }

    void fireLayerItemChange(ItemLayer<?> layer) {
        this.fireProjectEvent(ProjectEvent.createLayerItemChangeEvent(this, layer));
    }

    void fireLayersAdd(LayerComposition comp, Collection<? extends Layer> layers) {
        this.fireProjectEvent(ProjectEvent.createLayersAddEvent(this, comp, layers));
    }

    void fireLayersRemove(LayerComposition comp, Collection<? extends Layer> layers) {
        this.fireProjectEvent(ProjectEvent.createLayersRemoveEvent(this, comp, layers));
    }

    void fireLayersReorder(LayerComposition comp, Collection<? extends Layer> layers) {
        this.fireProjectEvent(ProjectEvent.createLayersReorderEvent(this, comp, layers));
    }

    void fireEffectPropertyChange(EffectableLayer layer, int effectIndex, String property) {
        this.fireProjectEvent(ProjectEvent.createEffectPropertyChangeEvent(this, layer, effectIndex, property));
    }

    void fireEffectsAdd(LayerComposition comp, Object[][] data) {
        this.fireProjectEvent(ProjectEvent.createEffectsAddEvent(this, comp, data));
    }

    void fireEffectsRemove(LayerComposition comp, Object[][] data) {
        this.fireProjectEvent(ProjectEvent.createEffectsRemoveEvent(this, comp, data));
    }

    void fireLayerExpressionChange(Layer layer, String property) {
        this.fireProjectEvent(ProjectEvent.createLayerExpressionChangeEvent(this, layer, property));
    }

    void fireEffectExpressionChange(EffectableLayer layer, int effectIndex, String property) {
        this.fireProjectEvent(ProjectEvent.createEffectExpressionChangeEvent(this, layer, effectIndex, property));
    }

    void fireExpressionsAdd(LayerComposition comp, Object[][] data) {
        this.fireProjectEvent(ProjectEvent.createExpressionsAddEvent(this, comp, data));
    }

    void fireExpressionsRemove(LayerComposition comp, Object[][] data) {
        this.fireProjectEvent(ProjectEvent.createExpressionsRemoveEvent(this, comp, data));
    }

    void fireLayerTimesChange(LayerComposition comp, Collection<? extends Layer> layers) {
        this.fireProjectEvent(ProjectEvent.createLayerTimesChangeEvent(this, comp, layers));
    }

    void fireKeyframesChange(LayerComposition comp, Object[][] data) {
        this.fireProjectEvent(ProjectEvent.createKeyframesChangeEvent(this, comp, data));
    }

    void fireLayerSlipEdit(LayerComposition comp, Object[] data) {
        this.fireProjectEvent(ProjectEvent.createLayerSlipEditEvent(this, comp, data));
    }

    void fireShadowOperationExecution() {
        this.fireProjectEvent(ProjectEvent.createShadowOperationExecutionEvent(this));
    }

    public void undo() {
        block6: {
            if (!this._historyBusy) {
                this._historyBusy = true;
                try {
                    try {
                        this.getOperationHistory().undo(this._undoContext, null, null);
                        break block6;
                    }
                    catch (ExecutionException e) {
                        throw new JavieRuntimeException((Throwable)e);
                    }
                }
                finally {
                    this._historyBusy = false;
                }
            }
            _logger.warn("the operation history is busy.");
        }
    }

    public void redo() {
        block6: {
            if (!this._historyBusy) {
                this._historyBusy = true;
                try {
                    try {
                        this.getOperationHistory().redo(this._undoContext, null, null);
                        break block6;
                    }
                    catch (ExecutionException e) {
                        throw new JavieRuntimeException((Throwable)e);
                    }
                }
                finally {
                    this._historyBusy = false;
                }
            }
            _logger.warn("the operation history is busy.");
        }
    }

    public boolean canUndo() {
        return this.getOperationHistory().canUndo(this._undoContext);
    }

    public boolean canRedo() {
        return this.getOperationHistory().canRedo(this._undoContext);
    }

    public String getUndoLabel() {
        IUndoableOperation op = this.getOperationHistory().getUndoOperation(this._undoContext);
        return op != null ? op.getLabel() : null;
    }

    public String getRedoLabel() {
        IUndoableOperation op = this.getOperationHistory().getRedoOperation(this._undoContext);
        return op != null ? op.getLabel() : null;
    }

    public void historyNotification(OperationHistoryEvent event) {
        IUndoableOperation op = event.getOperation();
        if (!op.hasContext(this._undoContext)) {
            return;
        }
        switch (event.getEventType()) {
            case 5: {
                if (!this._dirty) {
                    this._firstOperation = event.getOperation();
                }
            }
            case 9: 
            case 10: {
                this.updateDirty();
            }
        }
    }

    private IOperationHistory getOperationHistory() {
        return PlatformUI.getWorkbench().getOperationSupport().getOperationHistory();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void postOperation(ProjectOperation operation) {
        block16: {
            IUndoableOperation undoOperation;
            IOperationHistory history;
            if (!operation.projectManagerMatches(this)) {
                throw new IllegalArgumentException("different ProjectManager");
            }
            if (operation.isNoEffect()) {
                return;
            }
            if (operation.getRelation() != null && this._dirty && !(history = this.getOperationHistory()).canRedo(this._undoContext) && (undoOperation = history.getUndoOperation(this._undoContext)) instanceof ProjectOperation) {
                ProjectOperation prevOp = (ProjectOperation)undoOperation;
                if (operation.getRelation().equals(prevOp.getRelation())) {
                    if (!this._historyBusy) {
                        this._historyBusy = true;
                        try {
                            if (prevOp.tryMerging(operation, null, null)) {
                                history.operationChanged((IUndoableOperation)prevOp);
                                if (!prevOp.isNoEffect()) return;
                                history.replaceOperation((IUndoableOperation)prevOp, new IUndoableOperation[0]);
                                if (this._firstOperation != prevOp) return;
                                this.clearDirty();
                                return;
                            }
                            break block16;
                        }
                        finally {
                            this._historyBusy = false;
                        }
                    }
                    _logger.warn("the operation history is busy.");
                    return;
                }
            }
        }
        if (!this._historyBusy) {
            this._historyBusy = true;
            try {
                try {
                    operation.addContext(this._undoContext);
                    this.getOperationHistory().execute((IUndoableOperation)operation, null, null);
                    return;
                }
                catch (ExecutionException e) {
                    throw new JavieRuntimeException((Throwable)e);
                }
            }
            finally {
                this._historyBusy = false;
            }
        }
        _logger.warn("the operation history is busy.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postShadowOperation(boolean sync, final Runnable shadowOperation) {
        if (sync) {
            final Object monitor = new Object();
            Runnable wrapper = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    shadowOperation.run();
                    Object object = monitor;
                    synchronized (object) {
                        monitor.notify();
                    }
                }
            };
            Object object = monitor;
            synchronized (object) {
                this.shadowOperationRunner.put(wrapper);
                try {
                    monitor.wait();
                }
                catch (InterruptedException e) {
                    throw new JavieRuntimeException("unexpected interruption", (Throwable)e);
                }
            }
        }
        this.shadowOperationRunner.put(shadowOperation);
    }

    public boolean isDirty() {
        return this._dirty;
    }

    private void updateDirty() {
        boolean newDirty;
        IUndoableOperation nextRedo = this.getOperationHistory().getRedoOperation(this._undoContext);
        boolean bl = newDirty = nextRedo != this._firstOperation;
        if (this._dirty != newDirty) {
            this._dirty = newDirty;
            this.fireProjectEvent(ProjectEvent.createDirtyChangeEvent(this));
        }
    }

    private void clearDirty() {
        this._firstOperation = this.getOperationHistory().getRedoOperation(this._undoContext);
        this.updateDirty();
    }

    public void save() throws IOException {
        if (this._file == null) {
            throw new IllegalStateException("no file is specified");
        }
        this.save(this._file);
        this.clearDirty();
    }

    public void saveAs(File file) throws IOException {
        this.save(file);
        if (!file.equals(this._file)) {
            this._file = file;
            this.fireProjectEvent(ProjectEvent.createFileChangeEvent(this));
        }
        this.clearDirty();
    }

    public void saveCopy(File file) throws IOException {
        this.save(file);
    }

    private void save(File file) throws IOException {
        String body = this._encoder.encode(this._project, file.getParentFile(), true);
        PrintWriter pw = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8")));
        try {
            pw.print("JVP-Version: 0.9\n\n");
            pw.print(body);
            pw.print('\n');
        }
        finally {
            pw.close();
        }
    }

    public String getUnusedItemName(String prefix) {
        String name;
        Set names = Util.newSet();
        for (Item i : this._project.getItems()) {
            names.add(i.getName());
        }
        int n = 1;
        while (names.contains(name = String.valueOf(prefix) + " " + n++)) {
        }
        return name;
    }

    public String getUnusedLayerName(LayerComposition comp, String prefix) {
        String name;
        this.checkComposition((Composition)comp);
        Set names = Util.newSet();
        for (Layer l : comp.getLayers()) {
            names.add(l.getName());
        }
        int n = 1;
        while (names.contains(name = String.valueOf(prefix) + " " + n++)) {
        }
        return name;
    }

    public List<Item> listChildren(Folder parent) {
        List list = Util.newList();
        for (Item i : this._project.getItems()) {
            if (i.getParent() != parent) continue;
            list.add(i);
        }
        return list;
    }

    public boolean hasChildren(Folder parent) {
        for (Item i : this._project.getItems()) {
            if (i.getParent() != parent) continue;
            return true;
        }
        return false;
    }

    void checkItem(Item item) {
        if (item != null && this._project.getItem(item.getId()) != item) {
            throw new IllegalArgumentException("no such item found: " + item.getId());
        }
    }

    void checkComposition(Composition comp) {
        if (comp != null && this._project.getComposition(comp.getId()) != comp) {
            throw new IllegalArgumentException("no such composition found: " + comp.getId());
        }
    }

    LayerComposition checkLayer(Layer layer) {
        if (layer == null) {
            return null;
        }
        for (Composition comp : this._project.getCompositions()) {
            LayerComposition layerComp;
            if (!(comp instanceof LayerComposition) || (layerComp = (LayerComposition)comp).getLayer(layer.getId()) != layer) continue;
            return layerComp;
        }
        throw new IllegalArgumentException("no such layer found: " + layer.getId());
    }
}

