/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.ColorUtil;
import ch.kuramo.javie.app.ImageUtil;
import ch.kuramo.javie.app.InjectorHolder;
import ch.kuramo.javie.app.IntervalTask;
import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.UIUtil;
import ch.kuramo.javie.app.actions.AVIOutputAction;
import ch.kuramo.javie.app.actions.AddEffectAction;
import ch.kuramo.javie.app.actions.AddExpressionsAction;
import ch.kuramo.javie.app.actions.KeyframeInterpolationAction;
import ch.kuramo.javie.app.actions.PrecomposeAction;
import ch.kuramo.javie.app.actions.QTMovieOutputAction;
import ch.kuramo.javie.app.actions.RemoveKeyframesAction;
import ch.kuramo.javie.app.actions.RenameLayerOrEffectAction;
import ch.kuramo.javie.app.actions.ReplaceLayerItemAction;
import ch.kuramo.javie.app.actions.ResetAnimatableValuesAction;
import ch.kuramo.javie.app.actions.ReverseLayerTimeAction;
import ch.kuramo.javie.app.actions.SequenceOutputAction;
import ch.kuramo.javie.app.actions.TimeRemapAction;
import ch.kuramo.javie.app.actions.WaveOutputAction;
import ch.kuramo.javie.app.player.MediaPlayer;
import ch.kuramo.javie.app.player.PlayerLinkEvent;
import ch.kuramo.javie.app.player.PlayerLinkListener;
import ch.kuramo.javie.app.project.DuplicateEffectsOperation;
import ch.kuramo.javie.app.project.DuplicateLayersOperation;
import ch.kuramo.javie.app.project.MoveEffectsOperation;
import ch.kuramo.javie.app.project.NewCameraLayerOperation;
import ch.kuramo.javie.app.project.NewLayerFromItemOperation;
import ch.kuramo.javie.app.project.NewNullLayerOperation;
import ch.kuramo.javie.app.project.NewTextLayerOperation;
import ch.kuramo.javie.app.project.ProjectEvent;
import ch.kuramo.javie.app.project.ProjectEventHub;
import ch.kuramo.javie.app.project.ProjectListener;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.RemoveEffectsOperation;
import ch.kuramo.javie.app.project.RemoveLayersOperation;
import ch.kuramo.javie.app.project.ReorderLayersOperation;
import ch.kuramo.javie.app.views.LayerCompositionContentProvider;
import ch.kuramo.javie.app.views.LayerCompositionLabelProvider;
import ch.kuramo.javie.app.views.LocalSelectionWrapper;
import ch.kuramo.javie.app.views.MediaPlayerView;
import ch.kuramo.javie.app.views.ShyFilter;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElementDelegate;
import ch.kuramo.javie.app.views.layercomp.EffectAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.EffectElement;
import ch.kuramo.javie.app.views.layercomp.EffectsElement;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.LayerAnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.LayerCompFrameBlendAction;
import ch.kuramo.javie.app.views.layercomp.LayerCompMotionBlurAction;
import ch.kuramo.javie.app.views.layercomp.LayerCompSettingsAction;
import ch.kuramo.javie.app.views.layercomp.LayerCompShyAction;
import ch.kuramo.javie.app.views.layercomp.LayerElement;
import ch.kuramo.javie.app.views.layercomp.TimelineManager;
import ch.kuramo.javie.app.widgets.FontUtil;
import ch.kuramo.javie.core.AnimatableLayerReference;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectDescriptor;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.ItemLayer;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.TimeCode;
import ch.kuramo.javie.core.TransformableLayer;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.AnimatableValueCollector;
import ch.kuramo.javie.core.services.EffectRegistry;
import com.google.inject.Inject;
import com.ibm.icu.text.Normalizer;
import com.ibm.icu.text.Transliterator;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeColumnViewerLabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Slider;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerCompositionView
extends ViewPart
implements ProjectListener,
PlayerLinkListener {
    public static final String ID = "ch.kuramo.javie.app.views.layerCompositionView";
    public static final int NAME_COL = 0;
    public static final int VALUE_COL = 1;
    public static final int MODE_COL = 2;
    public static final int TRACKMATTE_COL = 3;
    public static final int PARENT_COL = 4;
    public static final int SHOWHIDE_COL = 5;
    public static final int LABEL_COL = 6;
    public static final int TIMELINE_COL = 7;
    public static final String PROJECT_MANAGER = "PROJECT_MANAGER";
    public static final String LAYER_COMPOSITION = "LAYER_COMPOSITION";
    public static final String ANIMATABLE_VALUES = "ANIMATABLE_VALUES";
    public static final String TIMELINE_MANAGER = "TIMELINE_MANAGER";
    public static final String LAYER_NAME_MODE = "LAYER_NAME_MODE";
    public static final String EDIT_ELEMENT_NAME = "EDIT_ELEMENT_NAME";
    private static final Logger _logger = LoggerFactory.getLogger(LayerCompositionView.class);
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    private static final boolean WIN32 = SWT.getPlatform().equals("win32");
    private static final int ROW_PADDING = 4;
    private Text _searchText;
    private Composite _timeCodeComposite;
    private Label _fpsLabel;
    private Composite _topSpacer;
    private Composite _bottomSpacer;
    private Composite _timelineMeter;
    private Scale _timelineScale;
    private Slider _timelineSlider;
    private TreeViewer _treeViewer;
    private TreeViewerColumn _nameColumn;
    private Point _mouseDownPoint;
    private volatile Time _time;
    private IntervalTask _timelineUpdateTask;
    private IntervalTask _collectTask;
    private ProjectManager _projectManager;
    private CompositionItem _compItem;
    private LayerComposition _composition;
    private TimelineManager _timelineManager;
    private Action _splitLayersAction;
    @Inject
    private EffectRegistry _effectRegistry;
    @Inject
    private AnimatableValueCollector _collector;
    private static Method cocoaGetCurrentButtonStateMethod;
    private static final Transliterator H2K_TRANSLITERATOR;
    private TreeItem _shiftSelectionBaseItem;
    private final ListenerList _playerLinkListeners = new ListenerList();
    private static final Set<String> _connectingIds;

    static {
        H2K_TRANSLITERATOR = Transliterator.getInstance((String)"Hiragana-Katakana");
        _connectingIds = Util.newSet();
    }

    public LayerCompositionView() {
        InjectorHolder.getInjector().injectMembers((Object)this);
        this._collector.activate();
    }

    public void createPartControl(final Composite parent) {
        ProjectManager pm = ProjectManager.forWorkbenchWindow(this.getSite().getWorkbenchWindow());
        if (pm == null) {
            throw new IllegalStateException("No ProjectManager exists for this window.");
        }
        parent.setLayout((Layout)new FormLayout());
        this._topSpacer = new Composite(parent, 0);
        this._bottomSpacer = new Composite(parent, 0);
        this.createTreeViewer(parent);
        this.createTimelineControls(parent);
        this.createSearchText(parent);
        this.createTimeCodeControls(parent);
        this.setLayoutData();
        this.setupGlobalActionsAndContextMenu();
        this.setupDragAndDrop();
        this._timelineUpdateTask = new IntervalTask(parent.getDisplay(), 50){

            public void run() {
                if (!parent.isDisposed()) {
                    if (LayerCompositionView.this._timelineManager != null) {
                        LayerCompositionView.this._timelineManager.update(LayerCompositionView.this._time, true);
                    }
                    LayerCompositionView.this._timeCodeComposite.redraw();
                    LayerCompositionView.this._splitLayersAction.setEnabled(LayerCompositionView.this.canSplitSelectedLayers());
                }
            }
        };
        this._collectTask = new IntervalTask(parent.getDisplay(), 300){

            public void run() {
                if (!parent.isDisposed()) {
                    LayerCompositionView.this.collectAnimatableValues(LayerCompositionView.this._time);
                }
            }
        };
        this.setProjectManager(pm);
        this.setupActionBars();
        ProjectEventHub.getHub().addProjectListener(this);
    }

    public void dispose() {
        ProjectEventHub.getHub().removeProjectListener(this);
        this._collector.deactivate();
        super.dispose();
    }

    public void setFocus() {
        this._treeViewer.getControl().setFocus();
    }

    private String getItemId() {
        return this.getViewSite().getSecondaryId();
    }

    private void setProjectManager(ProjectManager pm) {
        this._compItem = (CompositionItem)pm.getProject().getItem(this.getItemId());
        if (this._compItem == null) {
            throw new IllegalStateException("no such CompositionItem found: " + this.getItemId());
        }
        this._projectManager = pm;
        this._composition = (LayerComposition)this._compItem.getComposition();
        this.setPartName(this._compItem.getName());
        this._treeViewer.setData(PROJECT_MANAGER, (Object)pm);
        this._treeViewer.setData(LAYER_COMPOSITION, (Object)this._composition);
        this._treeViewer.setInput((Object)this._composition);
        Time frameDuration = this._composition.getFrameDuration();
        this._fpsLabel.setText(String.format("(%.2f fps)", (double)frameDuration.timeScale / (double)frameDuration.timeValue));
        this._time = Time.fromFrameNumber((long)0L, (Time)frameDuration);
        this._timelineManager = new TimelineManager(pm, this._composition, this, this._timelineMeter, this._timelineScale, this._timelineSlider, this._treeViewer.getTree());
        this._treeViewer.setData(TIMELINE_MANAGER, (Object)this._timelineManager);
        this.collectAnimatableValues();
        this.connectToPlayer();
    }

    @Override
    public void handleProjectEvent(ProjectEvent event) {
        if (event.getProjectManager() != this._projectManager) {
            return;
        }
        switch (event.type) {
            case LAYER_PROPERTY_CHANGE: 
            case LAYER_ITEM_CHANGE: 
            case LAYERS_REMOVE: 
            case EFFECT_PROPERTY_CHANGE: 
            case EFFECTS_REMOVE: {
                if (event.composition != this._composition) break;
                this._timelineManager.clearKeyframeSelection();
                this._timelineManager.redraw();
            }
        }
        switch (event.type) {
            case ITEM_NAME_CHANGE: {
                this.handleItemUpdate(event, true);
                break;
            }
            case ITEM_UPDATE: {
                this.handleItemUpdate(event, false);
                break;
            }
            case COMPOSITION_SETTINGS_CHANGE: {
                this.handleCompositionSettingsChange(event);
                break;
            }
            case COMPOSITION_PROPERTY_CHANGE: {
                this.handleCompositionPropertyChange(event);
                break;
            }
            case LAYER_PROPERTY_CHANGE: {
                this.handleLayerPropertyChange(event);
                break;
            }
            case LAYER_EXPRESSION_CHANGE: {
                this.handleLayerExpressionChange(event);
                break;
            }
            case LAYER_ITEM_CHANGE: {
                this.handleLayerItemChange(event);
                break;
            }
            case LAYERS_ADD: 
            case LAYERS_REMOVE: 
            case LAYERS_REORDER: {
                this.handleLayersAddRemoveReorder(event);
                break;
            }
            case EXPRESSIONS_ADD: 
            case EXPRESSIONS_REMOVE: {
                this.handleExpressionsAddRemove(event);
                break;
            }
            case EFFECTS_ADD: 
            case EFFECTS_REMOVE: {
                this.handleEffectsAddRemove(event);
                break;
            }
            case EFFECT_PROPERTY_CHANGE: {
                this.handleEffectPropertyChange(event);
                break;
            }
            case EFFECT_EXPRESSION_CHANGE: {
                this.handleEffectExpressionChange(event);
                break;
            }
            case LAYER_TIMES_CHANGE: {
                this.handleLayerTimesChange(event);
                break;
            }
            case KEYFRAMES_CHANGE: {
                this.handleKeyframesChange(event);
                break;
            }
            case LAYER_SLIP_EDIT: {
                this.handleLayerSlipEdit(event);
            }
        }
    }

    private void createTimelineControls(Composite parent) {
        this._timelineMeter = new Composite(parent, WIN32 ? 0x20000000 : 0);
        this._timelineScale = new Scale(parent, 256);
        this._timelineSlider = new Slider(parent, 256);
        FontUtil.setCompatibleFont((Control)this._timelineMeter);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayerCompositionView.this._timelineManager.update(LayerCompositionView.this._time, false);
            }
        };
        this._timelineScale.addSelectionListener((SelectionListener)selectionListener);
        this._timelineSlider.addSelectionListener((SelectionListener)selectionListener);
    }

    private void createTreeViewer(Composite parent) {
        Color layerColor;
        this._treeViewer = new TreeViewer(parent, 530);
        this._treeViewer.setUseHashlookup(true);
        this._treeViewer.setContentProvider((IContentProvider)new LayerCompositionContentProvider());
        Tree tree = this._treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(!COCOA);
        FontUtil.setCompatibleFont((Control)tree);
        class DragSourceEffect
        extends TreeDragSourceEffect {
            private boolean creatingImage;

            public DragSourceEffect(Tree tree) {
                super(tree);
            }

            public void dragStart(DragSourceEvent event) {
                this.creatingImage = true;
                try {
                    super.dragStart(event);
                }
                finally {
                    this.creatingImage = false;
                }
            }
        }
        final DragSourceEffect dragEffect = new DragSourceEffect(tree);
        tree.setData("DEFAULT_DRAG_SOURCE_EFFECT", (Object)dragEffect);
        this._nameColumn = this.createViewerColumn(0, 200, null, "\u30bd\u30fc\u30b9\u540d");
        this.createViewerColumn(1, 150, ImageUtil.getSwitchesHeaderIcon(), "");
        this.createViewerColumn(2, 50, null, "\u30e2\u30fc\u30c9");
        this.createViewerColumn(3, 50, null, "\uff84\uff97\uff6f\uff78\uff8f\uff6f\uff84");
        this.createViewerColumn(4, 100, null, "\u89aa");
        this.createViewerColumn(5, 60, ImageUtil.getShowhideHeaderIcon(), "");
        this.createViewerColumn(6, 40, null, "");
        this.createViewerColumn(7, 300, null, "");
        this.setLayerNameMode(false);
        ControlAdapter columnWidthAdjuster = new ControlAdapter(){
            private boolean adjusting = false;

            public void controlResized(ControlEvent e) {
                if (!this.adjusting) {
                    this.adjusting = true;
                    try {
                        LayerCompositionView.this.adjustColumnWidth();
                        if (LayerCompositionView.this._timelineManager != null) {
                            LayerCompositionView.this._timelineManager.update(LayerCompositionView.this._time, false);
                        }
                    }
                    finally {
                        this.adjusting = false;
                    }
                }
            }
        };
        tree.addControlListener((ControlListener)columnWidthAdjuster);
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            column.addControlListener((ControlListener)columnWidthAdjuster);
            ++n2;
        }
        tree.setBackground(ColorUtil.tableBackground());
        if (COCOA) {
            layerColor = ColorUtil.layerRowBackground();
            final Color lineColor = ColorUtil.tableRowLine();
            tree.addListener(40, new Listener(){
                {
                }

                public void handleEvent(Event event) {
                    if (dragEffect.creatingImage) {
                        return;
                    }
                    GC gc = event.gc;
                    TreeItem treeItem = (TreeItem)event.item;
                    Object element = treeItem.getData();
                    if (element instanceof LayerElement) {
                        gc.setBackground(layerColor);
                        gc.fillRectangle(event.x, event.y, event.width, event.height - 1);
                    }
                    int x = event.x;
                    int y = event.y + event.height - 1;
                    gc.setForeground(lineColor);
                    gc.drawLine(x, y, x + event.width, y);
                }
            });
        } else {
            layerColor = ColorUtil.layerRowBackground();
            tree.addListener(40, new Listener(){
                {
                }

                public void handleEvent(Event event) {
                    if (dragEffect.creatingImage) {
                        return;
                    }
                    TreeItem treeItem = (TreeItem)event.item;
                    Object element = treeItem.getData();
                    if (element instanceof LayerElement) {
                        GC gc = event.gc;
                        gc.setBackground(layerColor);
                        gc.fillRectangle(event.x, event.y, event.width, event.height);
                        treeItem.setBackground(layerColor);
                    }
                }
            });
        }
        tree.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                Object element = event.item.getData();
                if (element instanceof Element) {
                    ((Element)element).paintColumn(event);
                }
            }
        });
        tree.addListener(41, new Listener(){

            public void handleEvent(Event e) {
                e.height = Math.max(e.height, e.gc.getFontMetrics().getHeight() + 8);
            }
        });
        tree.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                LayerCompositionView.this.updateCursor(e);
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (COCOA) {
                    LayerCompositionView.this._mouseDownPoint = new Point(e.x, e.y);
                }
                LayerCompositionView.this.handleMouseDown(e);
            }
        });
        tree.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                LayerCompositionView.this.handleKeyPressed(e);
            }
        });
        tree.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (LayerCompositionView.this._timelineManager != null) {
                    LayerCompositionView.this._timelineManager.drawTimeIndicatorLine(e);
                    if (COCOA) {
                        LayerCompositionView.this._timelineManager.drawColumnLeftLine(e);
                    }
                }
            }
        });
    }

    private TreeViewerColumn createViewerColumn(final int columnIndex, int width, Image image, String name) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this._treeViewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setWidth(width);
        column.setImage(image);
        column.setText(name);
        column.setMoveable(false);
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LayerCompositionView.this.treeColumnSelected(columnIndex);
            }
        });
        viewerColumn.setLabelProvider((CellLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)new LayerCompositionLabelProvider()));
        viewerColumn.setEditingSupport(this.createEditingSupport(columnIndex));
        return viewerColumn;
    }

    private EditingSupport createEditingSupport(final int columnIndex) {
        return new EditingSupport((ColumnViewer)this._treeViewer){

            protected boolean canEdit(Object element) {
                return element instanceof Element ? ((Element)element).canEdit(columnIndex) : false;
            }

            protected CellEditor getCellEditor(Object element) {
                return element instanceof Element ? ((Element)element).getCellEditor(columnIndex) : null;
            }

            protected Object getValue(Object element) {
                return element instanceof Element ? ((Element)element).getCellEditorValue(columnIndex) : null;
            }

            protected void setValue(Object element, Object value) {
                if (element instanceof Element) {
                    ((Element)element).setCellEditorValue(columnIndex, value);
                }
            }
        };
    }

    private void createSearchText(Composite parent) {
        final TreePath[][] treePaths = new TreePath[1][];
        final Color colorGray = parent.getDisplay().getSystemColor(15);
        final Color colorBlack = parent.getDisplay().getSystemColor(2);
        this._searchText = new Text(parent, 640);
        this._searchText.setForeground(colorGray);
        this._searchText.setText("\u691c\u7d22");
        FontUtil.setCompatibleFont((Control)this._searchText);
        this._searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.character) {
                    case '\r': {
                        LayerCompositionView.this.searchTreeItem();
                        break;
                    }
                    case '\u001b': {
                        if (treePaths[0] != null) {
                            LayerCompositionView.this._treeViewer.setExpandedTreePaths(treePaths[0]);
                        }
                        LayerCompositionView.this._searchText.setText("");
                    }
                }
            }
        });
        this._searchText.addFocusListener(new FocusListener(){
            private String savedText = "";

            public void focusGained(FocusEvent e) {
                treePaths[0] = LayerCompositionView.this._treeViewer.getExpandedTreePaths();
                LayerCompositionView.this._searchText.setText(this.savedText);
                LayerCompositionView.this._searchText.setForeground(colorBlack);
            }

            public void focusLost(FocusEvent e) {
                treePaths[0] = null;
                this.savedText = LayerCompositionView.this._searchText.getText();
                LayerCompositionView.this._searchText.setForeground(colorGray);
                LayerCompositionView.this._searchText.setText("\u691c\u7d22");
            }
        });
    }

    private void createTimeCodeControls(Composite parent) {
        Display display = parent.getDisplay();
        this._timeCodeComposite = new Composite(parent, WIN32 ? 0x20000000 : 0);
        this._fpsLabel = new Label(parent, 0);
        FontUtil.setCompatibleFont((Control)this._timeCodeComposite);
        FontUtil.setCompatibleFont((Control)this._fpsLabel);
        final Font font = new Font((Device)display, this._timeCodeComposite.getFont().getFontData()[0].getName(), COCOA ? 16 : 14, 1);
        this._timeCodeComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                font.dispose();
            }
        });
        this._timeCodeComposite.setFont(font);
        this._timeCodeComposite.setForeground(display.getSystemColor(10));
        this._timeCodeComposite.setLayout((Layout)new FillLayout());
        final Text editor = new Text(this._timeCodeComposite, 131072);
        editor.setVisible(false);
        editor.setFont(font);
        editor.setBackground(this._timeCodeComposite.getBackground());
        final boolean[] editorCanceled = new boolean[1];
        editor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                editor.setVisible(false);
                if (!editorCanceled[0]) {
                    Time frameDuration = LayerCompositionView.this._composition.getFrameDuration();
                    Time time = Time.fromFrameNumber((long)TimeCode.parseTimeCode((String)editor.getText(), (Time)frameDuration), (Time)frameDuration);
                    if (time.timeValue < 0L) {
                        time = new Time(0L, time.timeScale);
                    } else if (!time.before(LayerCompositionView.this._composition.getDuration())) {
                        time = LayerCompositionView.this._composition.getDuration().subtract(frameDuration);
                    }
                    time = Time.fromFrameNumber((long)time.toFrameNumber(frameDuration), (Time)frameDuration);
                    LayerCompositionView.this.update(time);
                }
            }
        });
        editor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                switch (e.character) {
                    case '\u001b': {
                        editorCanceled[0] = true;
                    }
                    case '\r': {
                        e.display.asyncExec(new Runnable(){

                            public void run() {
                                editor.setVisible(false);
                            }
                        });
                    }
                }
            }
        });
        final Rectangle timeCodeArea = new Rectangle(0, 0, 0, 0);
        final Time[] newTime = new Time[1];
        this._timeCodeComposite.addPaintListener(new PaintListener(){
            private final int[] underlineDash = new int[]{2, 2};

            public void paintControl(PaintEvent e) {
                Time time;
                if (LayerCompositionView.this._composition == null) {
                    return;
                }
                GC gc = e.gc;
                if (newTime[0] != null) {
                    gc.setForeground(e.display.getSystemColor(4));
                    time = newTime[0];
                } else {
                    time = LayerCompositionView.this._time;
                }
                String timeCode = TimeCode.toTimeCode((Time)time, (Time)LayerCompositionView.this._composition.getFrameDuration());
                Point extent = gc.textExtent(timeCode, 1);
                Point size = LayerCompositionView.this._timeCodeComposite.getSize();
                int x = size.x - extent.x + (COCOA ? -3 : (WIN32 ? -1 : 0));
                int y = (size.y - extent.y) / 2;
                gc.drawString(timeCode, x, y, true);
                timeCodeArea.x = x;
                timeCodeArea.y = y;
                timeCodeArea.width = extent.x;
                timeCodeArea.height = extent.y;
                y += extent.y;
                gc.setLineDash(this.underlineDash);
                if (COCOA) {
                    gc.drawLine(x, y - 1, x + extent.x + 1, y - 1);
                } else if (WIN32) {
                    gc.drawLine(x, y, x + extent.x - 3, y);
                } else {
                    gc.drawLine(x, y, x + extent.x, y);
                }
            }
        });
        final Cursor handCursor = display.getSystemCursor(21);
        this._timeCodeComposite.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                LayerCompositionView.this._timeCodeComposite.setCursor(timeCodeArea.contains(e.x, e.y) ? handCursor : null);
            }
        });
        this._timeCodeComposite.addMouseListener((MouseListener)new MouseAdapter(){
            private Listener filter;

            public void mouseDown(MouseEvent event) {
                if (!timeCodeArea.contains(event.x, event.y) || this.filter != null) {
                    return;
                }
                final Display display = event.display;
                final long downTime = System.currentTimeMillis();
                final Point downPoint = LayerCompositionView.this._timeCodeComposite.toDisplay(event.x, event.y);
                final Time frameDuration = LayerCompositionView.this._composition.getFrameDuration();
                final long originalValue = LayerCompositionView.this._time.toFrameNumber(frameDuration);
                this.filter = new Listener(){
                    private boolean dragDetected;
                    private Point detectPoint;
                    private Point prevPoint;
                    private double[] currentPoint;

                    public void handleEvent(Event e) {
                        switch (e.type) {
                            case 5: {
                                if (!LayerCompositionView.this._timeCodeComposite.isDisposed()) {
                                    if (COCOA && (LayerCompositionView.getCocoaCurrentButtonState() & 1) == 0) break;
                                    Point pt = display.getCursorLocation();
                                    if (!this.dragDetected) {
                                        boolean bl = this.dragDetected = System.currentTimeMillis() - downTime > 100L && (Math.abs(pt.x - downPoint.x) > 3 || Math.abs(pt.y - downPoint.y) > 3);
                                        if (this.dragDetected) {
                                            this.currentPoint = new double[]{pt.x, pt.y};
                                            this.prevPoint = this.detectPoint = pt;
                                        }
                                    }
                                    if (!this.dragDetected) break;
                                    double deltaScale = (e.stateMask & SWT.MOD2) != 0 ? 10.0 : ((e.stateMask & SWT.MOD1) != 0 ? 0.1 : 1.0);
                                    this.currentPoint[0] = this.currentPoint[0] + (double)(pt.x - this.prevPoint.x) * deltaScale;
                                    this.currentPoint[1] = this.currentPoint[1] + (double)(pt.y - this.prevPoint.y) * deltaScale;
                                    this.prevPoint = pt;
                                    long newValue = (long)((double)originalValue + this.currentPoint[0] - (double)this.detectPoint.x);
                                    Time time = Time.fromFrameNumber((long)newValue, (Time)frameDuration);
                                    if (time.timeValue < 0L) {
                                        time = new Time(0L, time.timeScale);
                                    } else if (!time.before(LayerCompositionView.this._composition.getDuration())) {
                                        time = LayerCompositionView.this._composition.getDuration().subtract(frameDuration);
                                    }
                                    newTime[0] = Time.fromFrameNumber((long)time.toFrameNumber(frameDuration), (Time)frameDuration);
                                    LayerCompositionView.this.update(newTime[0]);
                                    LayerCompositionView.this._timeCodeComposite.redraw();
                                    break;
                                }
                            }
                            case 4: 
                            case 27: {
                                filter = null;
                                display.removeFilter(5, (Listener)this);
                                display.removeFilter(4, (Listener)this);
                                display.removeFilter(27, (Listener)this);
                                LayerCompositionView.this._timelineManager.setWrapMode(true);
                                newTime[0] = null;
                                if (LayerCompositionView.this._timeCodeComposite.isDisposed()) break;
                                if (e.type == 4 && !this.dragDetected) {
                                    editorCanceled[0] = false;
                                    editor.setText(TimeCode.toTimeCode((Time)LayerCompositionView.this._time, (Time)LayerCompositionView.this._composition.getFrameDuration()));
                                    editor.selectAll();
                                    editor.setVisible(true);
                                    if (editor.setFocus()) break;
                                    editor.setVisible(false);
                                    break;
                                }
                                LayerCompositionView.this._timeCodeComposite.redraw();
                            }
                        }
                    }
                };
                LayerCompositionView.this._timelineManager.setWrapMode(false);
                display.addFilter(5, this.filter);
                display.addFilter(4, this.filter);
                display.addFilter(27, this.filter);
            }
        });
    }

    private static int getCocoaCurrentButtonState() {
        try {
            if (cocoaGetCurrentButtonStateMethod == null) {
                Class<?> clazz = Class.forName("org.eclipse.swt.internal.cocoa.OS");
                cocoaGetCurrentButtonStateMethod = clazz.getMethod("GetCurrentButtonState", new Class[0]);
            }
            return (Integer)cocoaGetCurrentButtonStateMethod.invoke(null, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JavieRuntimeException((Throwable)e);
        }
    }

    private void setupGlobalActionsAndContextMenu() {
        Action deleteAction = new Action("\u524a\u9664"){
            {
                this.setEnabled(false);
                LayerCompositionView.this._treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        this.setEnabled(LayerCompositionView.this.canRmDupSelectedLayersOrEffects());
                    }
                });
            }

            public void run() {
                LayerCompositionView.this.removeSelectedLayersOrEffects();
            }
        };
        Action duplicateAction = new Action("\u8907\u88fd"){
            {
                this.setEnabled(false);
                LayerCompositionView.this._treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        this.setEnabled(LayerCompositionView.this.canRmDupSelectedLayersOrEffects());
                    }
                });
            }

            public void run() {
                LayerCompositionView.this.duplicateSelectedLayersOrEffects();
            }
        };
        Action newCameraLayerAction = new Action("\u30ab\u30e1\u30e9"){

            public void run() {
                LayerCompositionView.this.handleNewCameraLayerAction();
            }
        };
        Action newNullLayerAction = new Action("\u30cc\u30eb\u30aa\u30d6\u30b8\u30a7\u30af\u30c8"){

            public void run() {
                LayerCompositionView.this.handleNewNullLayerAction();
            }
        };
        Action newTextLayerAction = new Action("\u30c6\u30ad\u30b9\u30c8"){

            public void run() {
                LayerCompositionView.this.handleNewTextLayerAction();
            }
        };
        this._splitLayersAction = new Action("\u30ec\u30a4\u30e4\u30fc\u306e\u5206\u5272"){
            {
                this.setEnabled(false);
                LayerCompositionView.this._treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        this.setEnabled(LayerCompositionView.this.canSplitSelectedLayers());
                    }
                });
            }

            public void run() {
                LayerCompositionView.this.splitSelectedLayers();
            }
        };
        IViewSite site = this.getViewSite();
        IActionBars actionBars = site.getActionBars();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        actionBars.setGlobalActionHandler("delete", (IAction)deleteAction);
        actionBars.setGlobalActionHandler("ch.kuramo.javie.app.commands.duplicate", (IAction)duplicateAction);
        actionBars.setGlobalActionHandler("ch.kuramo.javie.app.commands.splitLayers", (IAction)this._splitLayersAction);
        actionBars.setGlobalActionHandler("ch.kuramo.javie.app.commands.newCameraLayer", (IAction)newCameraLayerAction);
        actionBars.setGlobalActionHandler("ch.kuramo.javie.app.commands.newNullLayer", (IAction)newNullLayerAction);
        actionBars.setGlobalActionHandler("ch.kuramo.javie.app.commands.newTextLayer", (IAction)newTextLayerAction);
        if (AVIOutputAction.isAvailable()) {
            actionBars.setGlobalActionHandler("ch.kuramo.javie.app.commands.AVIOutput", (IAction)new AVIOutputAction(this));
        }
        if (QTMovieOutputAction.isAvailable()) {
            actionBars.setGlobalActionHandler("ch.kuramo.javie.app.commands.QTMovieOutput", (IAction)new QTMovieOutputAction(this));
        }
        actionBars.setGlobalActionHandler("ch.kuramo.javie.app.commands.sequenceOutput", (IAction)new SequenceOutputAction(this));
        actionBars.setGlobalActionHandler("ch.kuramo.javie.app.commands.waveOutput", (IAction)new WaveOutputAction(this));
        List effectActions = Util.newList();
        for (EffectDescriptor ed : this._effectRegistry.getEffectDescriptors()) {
            AddEffectAction action = new AddEffectAction(window, (Viewer)this._treeViewer, ed);
            actionBars.setGlobalActionHandler("EFFECT." + ed.getType(), (IAction)action);
            effectActions.add(action);
        }
        MenuManager menuMgr = new MenuManager();
        MenuManager newMenu = new MenuManager("\u65b0\u898f");
        MenuManager timeMenu = new MenuManager("\u6642\u9593");
        MenuManager effectMenu = new MenuManager("\u30a8\u30d5\u30a7\u30af\u30c8");
        MenuManager animeMenu = new MenuManager("\u30a2\u30cb\u30e1\u30fc\u30b7\u30e7\u30f3");
        MenuManager interpolationMenu = new MenuManager("\u30ad\u30fc\u30d5\u30ec\u30fc\u30e0\u88dc\u9593\u6cd5");
        menuMgr.add((IContributionItem)newMenu);
        menuMgr.add((IContributionItem)timeMenu);
        menuMgr.add((IContributionItem)effectMenu);
        menuMgr.add((IContributionItem)animeMenu);
        menuMgr.add((IContributionItem)new Separator());
        menuMgr.add((IAction)new RenameLayerOrEffectAction(this, (Viewer)this._treeViewer));
        menuMgr.add((IAction)deleteAction);
        menuMgr.add((IAction)duplicateAction);
        menuMgr.add((IAction)this._splitLayersAction);
        menuMgr.add((IAction)new ReplaceLayerItemAction(this, this._treeViewer));
        menuMgr.add((IAction)new PrecomposeAction(this, this._treeViewer));
        menuMgr.add((IAction)new ResetAnimatableValuesAction(window, this._treeViewer));
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        newMenu.add((IAction)newCameraLayerAction);
        newMenu.add((IAction)newNullLayerAction);
        newMenu.add((IAction)newTextLayerAction);
        timeMenu.add((IAction)new TimeRemapAction(window, this._treeViewer));
        timeMenu.add((IAction)new ReverseLayerTimeAction(this._treeViewer));
        this.setupEffectContextMenu(effectMenu, effectActions);
        animeMenu.add((IContributionItem)interpolationMenu);
        animeMenu.add((IAction)new RemoveKeyframesAction(this._treeViewer));
        animeMenu.add((IAction)new AddExpressionsAction(window, (Viewer)this._treeViewer));
        interpolationMenu.add((IAction)new KeyframeInterpolationAction(this._treeViewer, Interpolation.HOLD));
        interpolationMenu.add((IAction)new KeyframeInterpolationAction(this._treeViewer, Interpolation.LINEAR));
        interpolationMenu.add((IAction)new KeyframeInterpolationAction(this._treeViewer, Interpolation.CATMULL_ROM));
        site.registerContextMenu(menuMgr, (ISelectionProvider)this._treeViewer);
        Control treeViewControl = this._treeViewer.getControl();
        Menu treeViewMenu = menuMgr.createContextMenu(treeViewControl);
        treeViewControl.setMenu(treeViewMenu);
    }

    private void setupEffectContextMenu(MenuManager effectMenu, List<AddEffectAction> effectActions) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("ch.kuramo.javie.api.effectCategory");
        if (point == null) {
            return;
        }
        Map subMenuMap = Util.newMap();
        List subMenuList = Util.newList();
        IExtension[] iExtensionArray = point.getExtensions();
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = ext.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement cfgElem = iConfigurationElementArray[n4];
                if ("effect-category".equals(cfgElem.getName())) {
                    String category = cfgElem.getAttribute("category");
                    String name = cfgElem.getAttribute("name").replaceAll("&", "&&");
                    MenuManager subMenu = new MenuManager(name);
                    subMenuMap.put(category, subMenu);
                    subMenuList.add(subMenu);
                }
                ++n4;
            }
            ++n2;
        }
        Collections.sort(subMenuList, new Comparator<MenuManager>(){

            @Override
            public int compare(MenuManager o1, MenuManager o2) {
                return o1.getMenuText().compareTo(o2.getMenuText());
            }
        });
        for (MenuManager subMenu : subMenuList) {
            effectMenu.add((IContributionItem)subMenu);
        }
        List actions = Util.newList();
        for (AddEffectAction action : effectActions) {
            MenuManager subMenu = (MenuManager)subMenuMap.get(action.getEffectDescriptor().getCategory());
            if (subMenu != null) {
                subMenu.add((IAction)action);
                continue;
            }
            actions.add(action);
        }
        Collections.sort(actions, new Comparator<Action>(){

            @Override
            public int compare(Action o1, Action o2) {
                return o1.getText().compareTo(o2.getText());
            }
        });
        for (AddEffectAction action : actions) {
            effectMenu.add((IAction)action);
        }
    }

    private void setupDragAndDrop() {
        final LocalSelectionTransfer selectionTransfer = LocalSelectionTransfer.getTransfer();
        DragSourceListener sourceListener = new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                if (!LayerCompositionView.this.canDrag(event)) {
                    event.doit = false;
                    return;
                }
                LocalSelectionWrapper selection = new LocalSelectionWrapper((Viewer)LayerCompositionView.this._treeViewer);
                if (selection.isEmpty()) {
                    event.doit = false;
                } else {
                    selectionTransfer.setSelection((ISelection)selection);
                    selectionTransfer.setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
                    event.doit = true;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = selectionTransfer.getSelection();
            }

            public void dragFinished(DragSourceEvent event) {
                selectionTransfer.setSelection(null);
                selectionTransfer.setSelectionSetTime(0L);
            }
        };
        DropTargetAdapter targetListener = new DropTargetAdapter(){

            private <T extends Element> T getTargetElement(DropTargetEvent event, Class<T> elementClass) {
                Object data;
                TreeItem treeItem = (TreeItem)event.item;
                if (treeItem != null && elementClass.isInstance(data = treeItem.getData())) {
                    Element element = (Element)data;
                    return (T)element;
                }
                return null;
            }

            private List<LayerElement> getSourceLayerElements(DropTargetEvent event) {
                List list = Util.newList();
                ITreeSelection selection = (ITreeSelection)LocalSelectionWrapper.getSelection(selectionTransfer, (Viewer)LayerCompositionView.this._treeViewer);
                if (selection != null) {
                    for (Object o : selection.toList()) {
                        if (o instanceof LayerElement) {
                            list.add((LayerElement)o);
                            continue;
                        }
                        return null;
                    }
                }
                return list.isEmpty() ? null : list;
            }

            private List<Item> getSourceItems(DropTargetEvent event) {
                List list = Util.newList();
                ITreeSelection selection = (ITreeSelection)LocalSelectionWrapper.getSelection(selectionTransfer);
                if (selection != null) {
                    for (Object o : selection.toList()) {
                        boolean cfr_ignored_0 = o instanceof Folder;
                        if (o instanceof MediaItem) {
                            list.add((MediaItem)o);
                            continue;
                        }
                        return null;
                    }
                }
                return list.isEmpty() ? null : list;
            }

            private List<EffectElement> getSourceEffectElements(DropTargetEvent event) {
                List list = Util.newList();
                ITreeSelection selection = (ITreeSelection)LocalSelectionWrapper.getSelection(selectionTransfer, (Viewer)LayerCompositionView.this._treeViewer);
                if (selection != null) {
                    for (Object o : selection.toList()) {
                        if (o instanceof EffectElement) {
                            list.add((EffectElement)o);
                            continue;
                        }
                        return null;
                    }
                }
                return list.isEmpty() ? null : list;
            }

            public void dragOver(DropTargetEvent event) {
                int operations = event.operations;
                if (WIN32) {
                    try {
                        Class<?> os = Class.forName("org.eclipse.swt.internal.win32.OS");
                        Method m = os.getMethod("GetKeyState", Integer.TYPE);
                        short keyState = (Short)m.invoke(null, 17);
                        operations &= (keyState < 0 ? 1 : 2) | 4;
                    }
                    catch (Exception e) {
                        _logger.warn("error getting key state", (Throwable)e);
                    }
                }
                if (!selectionTransfer.isSupportedType(event.currentDataType)) {
                    event.detail = 0;
                    event.feedback = 0;
                    return;
                }
                if (this.getSourceLayerElements(event) != null) {
                    if (event.item != null && this.getTargetElement(event, LayerElement.class) == null) {
                        event.detail = 0;
                        event.feedback = 0;
                    } else {
                        event.detail = (operations & 2) == 2 ? 2 : operations & 1;
                        event.feedback = (event.feedback | 2) & 0xFFFFFFFE & 0xFFFFFFEF;
                    }
                    return;
                }
                if (this.getSourceItems(event) != null) {
                    if (event.item != null && this.getTargetElement(event, LayerElement.class) == null) {
                        event.detail = 0;
                        event.feedback = 0;
                    } else {
                        event.detail = operations & 4;
                        event.feedback = (event.feedback | 2) & 0xFFFFFFFE & 0xFFFFFFEF;
                    }
                    return;
                }
                if (this.getSourceEffectElements(event) != null && event.item != null) {
                    if (this.getTargetElement(event, EffectsElement.class) != null) {
                        event.detail = (operations & 2) == 2 ? 2 : operations & 1;
                        event.feedback = (event.feedback | 1) & 0xFFFFFFEF;
                    } else if (this.getTargetElement(event, EffectElement.class) != null) {
                        event.detail = (operations & 2) == 2 ? 2 : operations & 1;
                        event.feedback = (event.feedback | 2) & 0xFFFFFFFE & 0xFFFFFFEF;
                    } else {
                        event.detail = 0;
                        event.feedback = 0;
                    }
                    return;
                }
                event.detail = 0;
                event.feedback = 0;
            }

            public void dropAccept(DropTargetEvent event) {
                this.dragOver(event);
            }

            public void drop(DropTargetEvent event) {
                List<LayerElement> sourceLayerElements = this.getSourceLayerElements(event);
                if (sourceLayerElements != null) {
                    if (event.detail == 1) {
                        LayerCompositionView.this.duplicateLayers((Collection<LayerElement>)sourceLayerElements, this.getTargetElement(event, LayerElement.class));
                    } else {
                        LayerCompositionView.this.moveLayers(sourceLayerElements, this.getTargetElement(event, LayerElement.class));
                    }
                    return;
                }
                List<Item> sourceItems = this.getSourceItems(event);
                if (sourceItems != null) {
                    LayerCompositionView.this.newLayers(sourceItems, this.getTargetElement(event, LayerElement.class));
                    return;
                }
                List<EffectElement> sourceEffectElements = this.getSourceEffectElements(event);
                if (sourceEffectElements != null) {
                    EffectElement ee;
                    int targetIndex = -1;
                    EffectsElement effectsElement = this.getTargetElement(event, EffectsElement.class);
                    if (effectsElement == null && (ee = this.getTargetElement(event, EffectElement.class)) != null) {
                        effectsElement = (EffectsElement)ee.parent;
                        LayerElement le = (LayerElement)effectsElement.parent;
                        targetIndex = ((EffectableLayer)le.layer).getEffects().indexOf(ee.effect);
                    }
                    if (effectsElement != null) {
                        EffectableLayer dstLayer = (EffectableLayer)((LayerElement)effectsElement.parent).layer;
                        if (event.detail == 1) {
                            LayerCompositionView.this.duplicateEffects(sourceEffectElements, dstLayer, targetIndex);
                        } else {
                            LayerCompositionView.this.moveEffects(sourceEffectElements, dstLayer, targetIndex);
                        }
                        return;
                    }
                }
                event.detail = 0;
            }
        };
        this._treeViewer.addDragSupport(3, new Transfer[]{selectionTransfer}, sourceListener);
        this._treeViewer.addDropSupport(7, new Transfer[]{selectionTransfer}, (DropTargetListener)targetListener);
    }

    private void setLayoutData() {
        FormData data = new FormData();
        data.left = new FormAttachment(0, COCOA ? 4 : 6);
        data.right = new FormAttachment(0, 200);
        data.top = new FormAttachment(0, COCOA ? 4 : 6);
        data.bottom = new FormAttachment(0, COCOA ? 26 : 24);
        this._searchText.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this._searchText, 10, 131072);
        data.right = new FormAttachment((Control)this._searchText, 150, 131072);
        data.top = new FormAttachment(0, 5);
        data.bottom = new FormAttachment(0, 25);
        this._timeCodeComposite.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this._timeCodeComposite, 10, 131072);
        data.right = new FormAttachment((Control)this._timeCodeComposite, 90, 131072);
        data.top = new FormAttachment(0, COCOA ? 7 : 9);
        data.bottom = new FormAttachment(0, COCOA ? 23 : 21);
        this._fpsLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this._fpsLabel, 0, 131072);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 12);
        data.bottom = new FormAttachment(0, 30);
        this._topSpacer.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(100, COCOA ? -15 : -16);
        data.bottom = new FormAttachment(100, 0);
        this._bottomSpacer.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this._topSpacer, 0, 131072);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 12);
        data.bottom = new FormAttachment(0, 30);
        this._timelineMeter.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this._bottomSpacer, 0, 131072);
        data.right = new FormAttachment((Control)this._bottomSpacer, 150, 131072);
        data.top = new FormAttachment(100, COCOA ? -15 : -27);
        data.bottom = new FormAttachment(100, 0);
        this._timelineScale.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this._timelineScale, 0, 131072);
        data.right = new FormAttachment(100, COCOA ? -15 : -16);
        data.top = new FormAttachment(100, COCOA ? -15 : -16);
        data.bottom = new FormAttachment(100, 0);
        this._timelineSlider.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)this._topSpacer, 0, 1024);
        data.bottom = new FormAttachment((Control)this._timelineSlider, 0, 128);
        this._treeViewer.getTree().setLayoutData((Object)data);
    }

    private void treeColumnSelected(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                this.setLayerNameMode(!this.isLayerNameMode());
            }
        }
    }

    private boolean isLayerNameMode() {
        return Boolean.TRUE.equals(this._treeViewer.getData(LAYER_NAME_MODE));
    }

    private void setLayerNameMode(boolean layerNameMode) {
        if (this.isLayerNameMode() != layerNameMode) {
            this._treeViewer.setData(LAYER_NAME_MODE, (Object)layerNameMode);
            this._nameColumn.getColumn().setText(layerNameMode ? "\u30ec\u30a4\u30e4\u30fc\u540d" : "\u30bd\u30fc\u30b9\u540d");
            this._treeViewer.refresh();
            this.redrawLayerReferences();
        }
    }

    public void editElementName(Element element) {
        if (element instanceof LayerElement || element instanceof EffectElement) {
            if (element instanceof LayerElement) {
                this.setLayerNameMode(true);
            }
        } else {
            throw new IllegalArgumentException("element must be LayerElement or EffectElement");
        }
        this._treeViewer.setData(EDIT_ELEMENT_NAME, (Object)Boolean.TRUE);
        this._treeViewer.editElement((Object)element, 0);
        this._treeViewer.setData(EDIT_ELEMENT_NAME, null);
    }

    private void searchTreeItem() {
        String query = this._searchText.getText();
        query = Normalizer.normalize((String)query, (Normalizer.Mode)Normalizer.NFKC);
        query = H2K_TRANSLITERATOR.transliterate(query);
        query = query.trim().toLowerCase();
        Tree tree = this._treeViewer.getTree();
        TreeItem found = null;
        if (query.length() != 0) {
            TreeItem ti;
            int n;
            TreeItem[] treeItemArray;
            TreeItem item = null;
            TreeSelection selection = (TreeSelection)this._treeViewer.getSelection();
            Object element = selection.getFirstElement();
            if (element != null) {
                treeItemArray = tree.getSelection();
                n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ti = treeItemArray[n2];
                    if (ti.getData() == element) {
                        item = ti;
                        break;
                    }
                    ++n2;
                }
            }
            if (item != null) {
                found = this.searchTreeItem(query, item, false);
                while (found == null && item != null) {
                    TreeItem parentItem = item.getParentItem();
                    List<TreeItem> items = Arrays.asList(parentItem != null ? parentItem.getItems() : tree.getItems());
                    int index = items.indexOf(item);
                    int i = index + 1;
                    while (found == null && i < items.size()) {
                        found = this.searchTreeItem(query, items.get(i), true);
                        ++i;
                    }
                    item = parentItem;
                }
            }
            if (found == null) {
                treeItemArray = tree.getItems();
                n = treeItemArray.length;
                int n3 = 0;
                while (n3 < n) {
                    ti = treeItemArray[n3];
                    found = this.searchTreeItem(query, ti, true);
                    if (found != null) break;
                    ++n3;
                }
            }
        }
        this.selectAndReveal(found);
        if (found == null) {
            tree.getDisplay().beep();
        }
    }

    private TreeItem searchTreeItem(String query, TreeItem fromItem, boolean includeFromItem) {
        Object element;
        if (includeFromItem) {
            String text = fromItem.getText();
            text = Normalizer.normalize((String)text, (Normalizer.Mode)Normalizer.NFKC);
            text = H2K_TRANSLITERATOR.transliterate(text);
            if ((text = text.trim().toLowerCase()).contains(query)) {
                return fromItem;
            }
        }
        if (this._treeViewer.isExpandable(element = fromItem.getData())) {
            boolean expanded = this._treeViewer.getExpandedState(element);
            this._treeViewer.getTree().setRedraw(false);
            try {
                this._treeViewer.setExpandedState(element, true);
                TreeItem[] treeItemArray = fromItem.getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem ti = treeItemArray[n2];
                    if ((ti = this.searchTreeItem(query, ti, true)) != null) {
                        TreeItem treeItem = ti;
                        return treeItem;
                    }
                    ++n2;
                }
            }
            finally {
                this._treeViewer.setExpandedState(element, expanded);
                this._treeViewer.getTree().setRedraw(true);
            }
        }
        return null;
    }

    private void adjustColumnWidth() {
        Tree tree = this._treeViewer.getTree();
        int clientWidth = tree.getClientArea().width;
        if (clientWidth == 0) {
            return;
        }
        TreeColumn[] columns = tree.getColumns();
        int totalColumnWidth = 0;
        TreeColumn[] treeColumnArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            totalColumnWidth += column.getWidth();
            ++n2;
        }
        TreeColumn lastColumn = columns[columns.length - 1];
        int lastColumnWidth = lastColumn.getWidth() + clientWidth - totalColumnWidth;
        if (lastColumnWidth > 0) {
            lastColumn.setWidth(lastColumnWidth);
        }
        FormData data1 = (FormData)this._topSpacer.getLayoutData();
        FormData data2 = (FormData)this._bottomSpacer.getLayoutData();
        data2.right.numerator = 0;
        data1.right.numerator = 0;
        data1.right.offset = data2.right.offset = clientWidth - lastColumnWidth;
        final Composite parent = this._bottomSpacer.getParent();
        parent.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!parent.isDisposed()) {
                    parent.layout(new Control[]{LayerCompositionView.this._topSpacer, LayerCompositionView.this._bottomSpacer});
                }
            }
        });
    }

    private void updateCursor(MouseEvent e) {
        Object element;
        Point pt = new Point(e.x, e.y);
        TreeItem item = this.getItem(pt);
        if (item != null && (element = item.getData()) instanceof Element) {
            int i = 0;
            int cc = this._treeViewer.getTree().getColumnCount();
            while (i < cc) {
                if (item.getBounds(i).contains(pt)) {
                    ((Element)element).updateCursor(e, i);
                    return;
                }
                ++i;
            }
        }
        this._treeViewer.getTree().setCursor(null);
    }

    private void setupActionBars() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager tbm = actionBars.getToolBarManager();
        tbm.add((IAction)new LayerCompShyAction(this));
        tbm.add((IAction)new LayerCompFrameBlendAction(this));
        tbm.add((IAction)new LayerCompMotionBlurAction(this));
        tbm.add((IContributionItem)new Separator());
        tbm.add((IAction)new LayerCompSettingsAction(this));
        actionBars.updateActionBars();
    }

    private void emulateFullSelectionMouseDown(MouseEvent e, TreeItem item, int columnIndex) {
        final Tree tree = this._treeViewer.getTree();
        Collection<TreeItem> treeItems = null;
        if ((e.stateMask & SWT.MOD1) != 0) {
            treeItems = Util.newSet(Arrays.asList(tree.getSelection()));
            if (treeItems.contains(item)) {
                treeItems.remove(item);
            } else {
                treeItems.add(item);
            }
            this._shiftSelectionBaseItem = item;
        } else if ((e.stateMask & SWT.MOD2) != 0 && this._shiftSelectionBaseItem != null) {
            List<TreeItem> list = new Object(){
                final List<TreeItem> items = Util.newList();

                List<TreeItem> getVisibleExpandedItems() {
                    this.getVisibleExpandedItems(tree.getItems());
                    return this.items;
                }

                void getVisibleExpandedItems(TreeItem[] treeItems) {
                    TreeItem[] treeItemArray = treeItems;
                    int n = treeItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem ti = treeItemArray[n2];
                        this.items.add(ti);
                        if (ti.getExpanded()) {
                            this.getVisibleExpandedItems(ti.getItems());
                        }
                        ++n2;
                    }
                }
            }.getVisibleExpandedItems();
            int i1 = list.indexOf(this._shiftSelectionBaseItem);
            int i2 = list.indexOf(item);
            if (i1 != -1 && i2 != -1) {
                treeItems = list.subList(Math.min(i1, i2), Math.max(i1, i2) + 1);
            }
        } else if (columnIndex == 7 && (e.stateMask & SWT.BUTTON_MASK) == 0 && Arrays.asList(tree.getSelection()).contains(item)) {
            return;
        }
        if (treeItems == null) {
            treeItems = Collections.singleton(item);
            this._shiftSelectionBaseItem = item;
        }
        if (columnIndex != 0 || !item.getBounds().contains(new Point(e.x, e.y))) {
            this.selectAndReveal(treeItems);
        }
    }

    private void handleMouseDown(MouseEvent e) {
        Object element;
        Point pt = new Point(e.x, e.y);
        TreeItem item = this.getItem(pt);
        if (item != null && (element = item.getData()) instanceof Element) {
            int i = 0;
            int cc = this._treeViewer.getTree().getColumnCount();
            while (i < cc) {
                if (item.getBounds(i).contains(pt)) {
                    if (WIN32) {
                        this.emulateFullSelectionMouseDown(e, item, i);
                    }
                    ((Element)element).mouseDown(e, i);
                    return;
                }
                ++i;
            }
        }
        this._timelineManager.mouseDown(e);
    }

    private void handleKeyPressed(KeyEvent e) {
        if (e.stateMask == 0 && COCOA && e.keyCode == 8) {
            this.removeSelectedLayersOrEffects();
        }
    }

    private boolean canRmDupSelectedLayersOrEffects() {
        return this.canRmDupSelectedLayersOrEffects(Util.newSet(), Util.newSet());
    }

    private boolean canRmDupSelectedLayersOrEffects(Set<LayerElement> layerElements, Set<EffectElement> effectElements) {
        layerElements.clear();
        effectElements.clear();
        for (Object o : ((TreeSelection)this._treeViewer.getSelection()).toList()) {
            if (o instanceof LayerElement) {
                layerElements.add((LayerElement)o);
                continue;
            }
            if (o instanceof EffectElement) {
                effectElements.add((EffectElement)o);
                continue;
            }
            if (o instanceof EffectsElement) {
                Element[] elementArray = ((EffectsElement)o).getChildren();
                int n = elementArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Element child = elementArray[n2];
                    effectElements.add((EffectElement)child);
                    ++n2;
                }
                continue;
            }
            return false;
        }
        return layerElements.isEmpty() ^ effectElements.isEmpty();
    }

    private void removeSelectedLayersOrEffects() {
        Set effectElements;
        Set layerElements = Util.newSet();
        if (this.canRmDupSelectedLayersOrEffects(layerElements, effectElements = Util.newSet())) {
            if (!effectElements.isEmpty()) {
                List effects = Util.newList();
                for (EffectElement ee : effectElements) {
                    effects.add(new Object[]{((LayerElement)ee.parent.parent).layer, ee.effect});
                }
                this._projectManager.postOperation(new RemoveEffectsOperation(this._projectManager, effects));
            } else {
                List layers = Util.newList();
                for (LayerElement le : layerElements) {
                    layers.add(le.layer);
                }
                this._projectManager.postOperation(new RemoveLayersOperation(this._projectManager, layers));
            }
        }
    }

    private void duplicateSelectedLayersOrEffects() {
        Set effectElements;
        Set layerElements = Util.newSet();
        if (this.canRmDupSelectedLayersOrEffects(layerElements, effectElements = Util.newSet())) {
            if (!effectElements.isEmpty()) {
                this.duplicateEffects(effectElements);
            } else {
                this.duplicateLayers(layerElements);
            }
        }
    }

    private boolean canSplitSelectedLayers() {
        return this.canSplitSelectedLayers(Util.newSet(), new Time[1]);
    }

    private boolean canSplitSelectedLayers(Set<LayerElement> layerElements, Time[] time) {
        layerElements.clear();
        Time t = this._time;
        for (Object o : ((TreeSelection)this._treeViewer.getSelection()).toList()) {
            Layer layer;
            if (!(o instanceof LayerElement) || !t.after((layer = ((LayerElement)o).layer).getInPoint()) || !t.before(layer.getOutPoint())) continue;
            layerElements.add((LayerElement)o);
        }
        if (layerElements.isEmpty()) {
            return false;
        }
        time[0] = t;
        return true;
    }

    private void splitSelectedLayers() {
        Time[] time;
        Set layerElements = Util.newSet();
        if (this.canSplitSelectedLayers(layerElements, time = new Time[1])) {
            Set layers = Util.newSet();
            for (LayerElement e : layerElements) {
                layers.add(e.layer);
            }
            this._projectManager.postOperation(new DuplicateLayersOperation(this._projectManager, (Collection<Layer>)layers, time[0]));
        }
    }

    private boolean canDrag(DragSourceEvent e) {
        Point pt = COCOA && this._mouseDownPoint != null ? this._mouseDownPoint : new Point(e.x, e.y);
        TreeItem item = this.getItem(pt);
        if (item == null || !item.getBounds(0).contains(pt)) {
            return false;
        }
        TreeSelection selection = (TreeSelection)this._treeViewer.getSelection();
        if (selection.isEmpty()) {
            return false;
        }
        Object first = selection.getFirstElement();
        if (first instanceof LayerElement) {
            for (Object o : selection.toList()) {
                if (o instanceof LayerElement) continue;
                return false;
            }
            return true;
        }
        if (first instanceof EffectElement) {
            for (Object o : selection.toList()) {
                if (o instanceof EffectElement) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private TreeItem getItem(Point pt) {
        return this.getItem(pt, this._treeViewer.getTree().getItems());
    }

    private TreeItem getItem(Point pt, TreeItem[] items) {
        int i = items.length - 1;
        while (i >= 0) {
            TreeItem item = items[i];
            Rectangle bounds = item.getBounds();
            if (bounds.y <= pt.y) {
                if (bounds.y + bounds.height > pt.y) {
                    return item;
                }
                if (item.getExpanded()) {
                    return this.getItem(pt, item.getItems());
                }
            }
            --i;
        }
        return null;
    }

    private List<LayerElement> getLayerElements() {
        List list = Util.newList();
        LayerCompositionContentProvider cp = (LayerCompositionContentProvider)this._treeViewer.getContentProvider();
        Object[] objectArray = cp.getElements(this._composition);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            list.add((LayerElement)element);
            ++n2;
        }
        return list;
    }

    private void moveLayers(List<LayerElement> layerElements, LayerElement moveBefore) {
        List<LayerElement> current = this.getLayerElements();
        int moveToIndex = moveBefore != null ? current.indexOf(moveBefore) : current.size();
        List frontSub = Util.newList(current.subList(0, moveToIndex));
        List backSub = Util.newList(current.subList(moveToIndex, current.size()));
        frontSub.removeAll(layerElements);
        backSub.removeAll(layerElements);
        List newOrderOfElements = Util.newList();
        newOrderOfElements.addAll(frontSub);
        newOrderOfElements.addAll(layerElements);
        newOrderOfElements.addAll(backSub);
        Collections.reverse(newOrderOfElements);
        List newOrder = Util.newList();
        for (LayerElement e : newOrderOfElements) {
            newOrder.add(e.layer);
        }
        List layers = Util.newList();
        for (LayerElement e : layerElements) {
            layers.add(e.layer);
        }
        this._projectManager.postOperation(new ReorderLayersOperation(this._projectManager, newOrder, layers));
    }

    private void duplicateLayers(Collection<LayerElement> layerElements) {
        this.duplicateLayers(layerElements, -1);
    }

    private void duplicateLayers(Collection<LayerElement> layerElements, LayerElement insertBefore) {
        if (insertBefore != null) {
            int insertIndex = this._composition.getLayers().indexOf(insertBefore.layer) + 1;
            this.duplicateLayers(layerElements, insertIndex);
        } else {
            this.duplicateLayers(layerElements, 0);
        }
    }

    private void duplicateLayers(Collection<LayerElement> layerElements, int insertIndex) {
        Set layers = Util.newSet();
        for (LayerElement e : layerElements) {
            layers.add(e.layer);
        }
        this._projectManager.postOperation(new DuplicateLayersOperation(this._projectManager, (Collection<Layer>)layers, insertIndex));
    }

    private void newLayers(List<Item> items, LayerElement insertBefore) {
        List<LayerElement> current = this.getLayerElements();
        int insertIndex = -1;
        if (insertBefore == null) {
            insertIndex = current.size();
        } else {
            int i = 0;
            while (i < current.size()) {
                if (current.get(i) == insertBefore) {
                    insertIndex = i;
                    break;
                }
                ++i;
            }
            if (insertIndex == -1) {
                throw new IllegalArgumentException("no such layerElement found");
            }
        }
        insertIndex = current.size() - insertIndex;
        items = Util.newList(items);
        Collections.reverse(items);
        this._projectManager.postOperation(new NewLayerFromItemOperation(this._projectManager, this._composition, insertIndex, items));
    }

    private void moveEffects(List<EffectElement> effectElements, EffectableLayer dstLayer, int moveBefore) {
        List srcLayers = Util.newList();
        List effects = Util.newList();
        for (EffectElement ee : effectElements) {
            srcLayers.add((EffectableLayer)((LayerElement)ee.parent.parent).layer);
            effects.add(ee.effect);
        }
        this._projectManager.postOperation(new MoveEffectsOperation(this._projectManager, srcLayers, effects, dstLayer, moveBefore));
    }

    private void duplicateEffects(Collection<EffectElement> effectElements) {
        this.duplicateEffects(effectElements, null, 0);
    }

    private void duplicateEffects(Collection<EffectElement> effectElements, EffectableLayer dstLayer, int insertBefore) {
        List srcLayers = Util.newList();
        List effects = Util.newList();
        for (EffectElement ee : effectElements) {
            srcLayers.add((EffectableLayer)((LayerElement)ee.parent.parent).layer);
            effects.add(ee.effect);
        }
        this._projectManager.postOperation(new DuplicateEffectsOperation(this._projectManager, srcLayers, effects, dstLayer, insertBefore));
    }

    private void collectAnimatableValues() {
        this.collectAnimatableValues(this._timelineManager.getCurrentTime());
    }

    private void collectAnimatableValues(Time time) {
        this._collector.reset();
        this._collector.setTime(time);
        this._composition.prepareExpression(this._collector.createInitialExpressionScope((Composition)this._composition));
        this._treeViewer.setData(ANIMATABLE_VALUES, (Object)this._collector.collect());
        this.updateProperties();
    }

    private void updateProperties() {
        this.updateProperties(this._treeViewer.getTree().getItems());
    }

    private void updateProperties(TreeItem[] treeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            AnimatableValueElement avalueElement;
            TreeItem item = treeItemArray[n2];
            Object element = item.getData();
            if (element instanceof AnimatableValueElement && (avalueElement = (AnimatableValueElement)element).updateValue()) {
                Rectangle bounds = item.getBounds(1);
                this._treeViewer.getTree().redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
            }
            if (item.getExpanded()) {
                this.updateProperties(item.getItems());
            }
            ++n2;
        }
    }

    private void redrawLayerReferences() {
        this.redrawLayerReferences(this._treeViewer.getTree().getItems());
    }

    private void redrawLayerReferences(TreeItem[] treeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            Object element = item.getData();
            if (element instanceof AnimatableValueElement && ((AnimatableValueElement)element).getAnimatableValue() instanceof AnimatableLayerReference) {
                Rectangle bounds = item.getBounds(1);
                this._treeViewer.getTree().redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
            }
            if (item.getExpanded()) {
                this.redrawLayerReferences(item.getItems());
            }
            ++n2;
        }
    }

    private TreeItem findLayerAnimatableValueItem(TreeItem layerItem, final String property) {
        return new Object(){

            TreeItem find(TreeItem treeItem) {
                Object element = treeItem.getData();
                if (element instanceof LayerAnimatableValueElement && ((LayerAnimatableValueElement)element).getProperty().equals(property)) {
                    return treeItem;
                }
                if (treeItem.getItemCount() > 0) {
                    boolean expanded = LayerCompositionView.this._treeViewer.getExpandedState(element);
                    LayerCompositionView.this._treeViewer.getTree().setRedraw(false);
                    try {
                        LayerCompositionView.this._treeViewer.setExpandedState(element, true);
                        TreeItem[] treeItemArray = treeItem.getItems();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem ti = treeItemArray[n2];
                            if ((ti = this.find(ti)) != null) {
                                TreeItem treeItem2 = ti;
                                return treeItem2;
                            }
                            ++n2;
                        }
                        return null;
                    }
                    finally {
                        LayerCompositionView.this._treeViewer.setExpandedState(element, expanded);
                        LayerCompositionView.this._treeViewer.getTree().setRedraw(true);
                    }
                }
                return null;
            }
        }.find(layerItem);
    }

    private TreeItem findEffectAnimatableValueItem(TreeItem layerItem, final Effect effect, final String property) {
        return new Object(){

            TreeItem find(TreeItem treeItem) {
                Object element = treeItem.getData();
                if (element instanceof EffectAnimatableValueElement && ((EffectAnimatableValueElement)element).getProperty().equals(property)) {
                    return treeItem;
                }
                if ((element instanceof LayerElement || element instanceof EffectsElement || element instanceof EffectElement) && treeItem.getItemCount() > 0) {
                    if (element instanceof EffectElement && ((EffectElement)element).effect != effect) {
                        return null;
                    }
                    boolean expanded = LayerCompositionView.this._treeViewer.getExpandedState(element);
                    LayerCompositionView.this._treeViewer.getTree().setRedraw(false);
                    try {
                        LayerCompositionView.this._treeViewer.setExpandedState(element, true);
                        TreeItem[] treeItemArray = treeItem.getItems();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem ti = treeItemArray[n2];
                            if ((ti = this.find(ti)) != null) {
                                TreeItem treeItem2 = ti;
                                return treeItem2;
                            }
                            ++n2;
                        }
                        return null;
                    }
                    finally {
                        LayerCompositionView.this._treeViewer.setExpandedState(element, expanded);
                        LayerCompositionView.this._treeViewer.getTree().setRedraw(true);
                    }
                }
                return null;
            }
        }.find(layerItem);
    }

    private TreeItem findEffectItem(TreeItem layerItem, final Effect effect) {
        return new Object(){

            TreeItem find(TreeItem treeItem) {
                Object element = treeItem.getData();
                if (element instanceof EffectElement) {
                    return ((EffectElement)element).effect == effect ? treeItem : null;
                }
                if ((element instanceof LayerElement || element instanceof EffectsElement) && treeItem.getItemCount() > 0) {
                    boolean expanded = LayerCompositionView.this._treeViewer.getExpandedState(element);
                    LayerCompositionView.this._treeViewer.getTree().setRedraw(false);
                    try {
                        LayerCompositionView.this._treeViewer.setExpandedState(element, true);
                        TreeItem[] treeItemArray = treeItem.getItems();
                        int n = treeItemArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem ti = treeItemArray[n2];
                            if ((ti = this.find(ti)) != null) {
                                TreeItem treeItem2 = ti;
                                return treeItem2;
                            }
                            ++n2;
                        }
                        return null;
                    }
                    finally {
                        LayerCompositionView.this._treeViewer.setExpandedState(element, expanded);
                        LayerCompositionView.this._treeViewer.getTree().setRedraw(true);
                    }
                }
                return null;
            }
        }.find(layerItem);
    }

    private void selectAndReveal(TreeItem treeItem) {
        if (treeItem == null) {
            this._treeViewer.setSelection(null);
            return;
        }
        this.selectAndReveal(Collections.singleton(treeItem));
    }

    private void selectAndReveal(Collection<TreeItem> treeItems) {
        if (treeItems == null || treeItems.isEmpty()) {
            this._treeViewer.setSelection(null);
            return;
        }
        List list = Util.newList();
        for (TreeItem treeItem : treeItems) {
            LinkedList segmentList = Util.newLinkedList();
            do {
                segmentList.addFirst(treeItem.getData());
            } while ((treeItem = treeItem.getParentItem()) != null);
            list.add(new TreePath(segmentList.toArray()));
        }
        this._treeViewer.setSelection((ISelection)new TreeSelection(list.toArray(new TreePath[list.size()])), true);
    }

    private void handleCompositionSettingsChange(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
    }

    private void handleCompositionPropertyChange(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        if (event.property.equals("shyEnabled")) {
            if (this._composition.isShyEnabled()) {
                this._timelineManager.clearKeyframeSelection();
                this._treeViewer.addFilter((ViewerFilter)ShyFilter.INSTANCE);
            } else {
                this._treeViewer.removeFilter((ViewerFilter)ShyFilter.INSTANCE);
            }
        }
    }

    private void handleLayerPropertyChange(ProjectEvent event) {
        int n;
        if (event.composition != this._composition) {
            return;
        }
        if (event.property.equals("shy") && this._composition.isShyEnabled()) {
            this._treeViewer.refresh();
            return;
        }
        Tree tree = this._treeViewer.getTree();
        TreeItem[] treeItems = tree.getItems();
        if (event.property.equals("name")) {
            Set elements = Util.newSet();
            TreeItem[] treeItemArray = treeItems;
            int n2 = treeItems.length;
            n = 0;
            while (n < n2) {
                TreeItem treeItem = treeItemArray[n];
                LayerElement layerElement = (LayerElement)treeItem.getData();
                if (this._composition.getParentLayer(layerElement.layer) == event.layer) {
                    elements.add(layerElement);
                }
                ++n;
            }
            if (!elements.isEmpty()) {
                this._treeViewer.update(elements.toArray(), null);
            }
            this.redrawLayerReferences();
        }
        TreeItem[] treeItemArray = treeItems;
        n = treeItems.length;
        int n3 = 0;
        while (n3 < n) {
            TreeItem treeItem = treeItemArray[n3];
            LayerElement layerElement = (LayerElement)treeItem.getData();
            if (layerElement.layer == event.layer) {
                if (ProjectEvent.propertyIsAnimatable(event)) {
                    treeItem = this.findLayerAnimatableValueItem(treeItem, event.property);
                } else {
                    if (layerElement.layer instanceof TransformableLayer && event.property.equals("threeD")) {
                        this._treeViewer.refresh((Object)layerElement, true);
                    } else {
                        this._treeViewer.update((Object)layerElement, null);
                    }
                    Rectangle bounds = treeItem.getBounds();
                    if (WIN32) {
                        Rectangle clientArea = tree.getClientArea();
                        bounds.x = clientArea.x;
                        bounds.width = clientArea.width;
                    }
                    tree.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
                }
                this.selectAndReveal(treeItem);
                break;
            }
            ++n3;
        }
        this.collectAnimatableValues();
    }

    private void handleLayerExpressionChange(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement layerElement = (LayerElement)treeItem.getData();
            if (layerElement.layer == event.layer) {
                if ((treeItem = this.findLayerAnimatableValueItem(treeItem, event.property)) == null) break;
                Element element = (Element)treeItem.getData();
                this._treeViewer.setExpandedState((Object)element, false);
                this._treeViewer.refresh((Object)element, false);
                if (treeItem.getItemCount() > 0) {
                    this._treeViewer.setExpandedState((Object)element, true);
                    treeItem = treeItem.getItem(0);
                }
                this.selectAndReveal(treeItem);
                break;
            }
            ++n2;
        }
        this.collectAnimatableValues();
    }

    private void handleLayerItemChange(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        this._treeViewer.refresh();
        TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement layerElement = (LayerElement)treeItem.getData();
            if (layerElement.layer == event.layer) {
                this.selectAndReveal(treeItem);
                break;
            }
            ++n2;
        }
        this.collectAnimatableValues();
    }

    private void handleLayersAddRemoveReorder(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        this._treeViewer.getTree().setRedraw(false);
        try {
            Object[] expandedElements = this._treeViewer.getExpandedElements();
            this._treeViewer.refresh();
            this._treeViewer.setExpandedElements(expandedElements);
            if (event.type == ProjectEvent.Type.LAYERS_ADD || event.type == ProjectEvent.Type.LAYERS_REORDER) {
                Set<Layer> layers = ProjectEvent.getLayers(event);
                Set treeItems = Util.newSet();
                TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
                int n = treeItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem treeItem = treeItemArray[n2];
                    LayerElement layerElement = (LayerElement)treeItem.getData();
                    if (layers.contains(layerElement.layer)) {
                        treeItems.add(treeItem);
                    }
                    ++n2;
                }
                this.selectAndReveal(treeItems);
            }
        }
        finally {
            this._treeViewer.getTree().setRedraw(true);
        }
        this._splitLayersAction.setEnabled(this.canSplitSelectedLayers());
        this.collectAnimatableValues();
    }

    private void handleItemUpdate(ProjectEvent event, boolean checkParent) {
        Item item = ProjectEvent.getItem(event);
        if (item == this._compItem) {
            this.setPartName(this._compItem.getName());
            return;
        }
        Set elements = Util.newSet();
        TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            Layer parentLayer;
            ItemLayer itemLayer;
            TreeItem treeItem = treeItemArray[n2];
            LayerElement element = (LayerElement)treeItem.getData();
            if (element.layer instanceof ItemLayer && (itemLayer = (ItemLayer)element.layer).getItem() == item) {
                elements.add(element);
            }
            if (checkParent && (parentLayer = this._composition.getParentLayer(element.layer)) instanceof ItemLayer && ((ItemLayer)parentLayer).getItem() == item) {
                elements.add(element);
            }
            ++n2;
        }
        if (!elements.isEmpty()) {
            this._treeViewer.update(elements.toArray(), null);
        }
    }

    private void handleExpressionsAddRemove(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        boolean add = event.type == ProjectEvent.Type.EXPRESSIONS_ADD;
        Map layerToTreeItem = Util.newMap();
        TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement element = (LayerElement)treeItem.getData();
            layerToTreeItem.put(element.layer, treeItem);
            ++n2;
        }
        Set treeItems = Util.newSet();
        Object[][] objectArray = (Object[][])event.data;
        int n3 = objectArray.length;
        n = 0;
        while (n < n3) {
            Object[] o = objectArray[n];
            TreeItem treeItem = (TreeItem)layerToTreeItem.get(o[0]);
            if (o[1] instanceof String) {
                String property = (String)o[1];
                treeItem = this.findLayerAnimatableValueItem(treeItem, property);
            } else if (o[1] instanceof Integer) {
                EffectableLayer layer = (EffectableLayer)o[0];
                Effect effect = (Effect)layer.getEffects().get((Integer)o[1]);
                String property = (String)o[2];
                treeItem = this.findEffectAnimatableValueItem(treeItem, effect, property);
            } else {
                throw new Error();
            }
            if (treeItem != null) {
                if (add) {
                    treeItem = treeItem.getItem(0);
                }
                treeItems.add(treeItem);
            }
            ++n;
        }
        this.selectAndReveal(treeItems);
    }

    private void handleEffectsAddRemove(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        this.selectAndReveal((TreeItem)null);
        boolean add = event.type == ProjectEvent.Type.EFFECTS_ADD;
        Map layerToTreeItem = Util.newMap();
        TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement element = (LayerElement)treeItem.getData();
            layerToTreeItem.put(element.layer, treeItem);
            ++n2;
        }
        Set treeItems = Util.newSet();
        Object[][] objectArray = (Object[][])event.data;
        int n3 = objectArray.length;
        n = 0;
        while (n < n3) {
            Object[] o = objectArray[n];
            TreeItem treeItem = (TreeItem)layerToTreeItem.get(o[0]);
            LayerElement element = (LayerElement)treeItem.getData();
            Integer effectIndex = (Integer)o[1];
            this._treeViewer.refresh((Object)element);
            this._treeViewer.setExpandedState((Object)element, true);
            TreeItem itemToSelect = treeItem;
            TreeItem[] treeItemArray2 = treeItem.getItems();
            int n4 = treeItemArray2.length;
            int n5 = 0;
            while (n5 < n4) {
                TreeItem child = treeItemArray2[n5];
                if (child.getData() instanceof EffectsElement) {
                    if (add) {
                        this._treeViewer.setExpandedState(child.getData(), true);
                        itemToSelect = child.getItem(effectIndex.intValue());
                        break;
                    }
                    itemToSelect = child;
                    break;
                }
                ++n5;
            }
            treeItems.add(itemToSelect);
            ++n;
        }
        this.selectAndReveal(treeItems);
        this.collectAnimatableValues();
    }

    private void handleEffectPropertyChange(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        EffectableLayer layer = (EffectableLayer)event.layer;
        Effect effect = (Effect)layer.getEffects().get(event.effectIndex);
        String property = event.property;
        TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement layerElement = (LayerElement)treeItem.getData();
            if (layerElement.layer == layer) {
                if (ProjectEvent.propertyIsAnimatable(event)) {
                    treeItem = this.findEffectAnimatableValueItem(treeItem, effect, property);
                } else if (property.equals("name") || property.equals("enabled")) {
                    treeItem = this.findEffectItem(treeItem, effect);
                    this._treeViewer.update(treeItem.getData(), null);
                }
                this.selectAndReveal(treeItem);
                break;
            }
            ++n2;
        }
        this.collectAnimatableValues();
    }

    private void handleEffectExpressionChange(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        EffectableLayer layer = (EffectableLayer)event.layer;
        Effect effect = (Effect)layer.getEffects().get(event.effectIndex);
        TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement layerElement = (LayerElement)treeItem.getData();
            if (layerElement.layer == layer) {
                treeItem = this.findEffectAnimatableValueItem(treeItem, effect, event.property);
                Element element = (Element)treeItem.getData();
                this._treeViewer.setExpandedState((Object)element, false);
                this._treeViewer.refresh((Object)element, false);
                if (treeItem.getItemCount() > 0) {
                    this._treeViewer.setExpandedState((Object)element, true);
                    treeItem = treeItem.getItem(0);
                }
                this.selectAndReveal(treeItem);
                break;
            }
            ++n2;
        }
        this.collectAnimatableValues();
    }

    private void handleLayerTimesChange(ProjectEvent event) {
        if (event.composition != this._composition) {
            return;
        }
        Tree tree = this._treeViewer.getTree();
        Map layerToTreeItem = Util.newMap();
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement element = (LayerElement)treeItem.getData();
            layerToTreeItem.put(element.layer, treeItem);
            ++n2;
        }
        Set treeItems = Util.newSet();
        Collection layers = (Collection)event.data;
        for (Layer layer : layers) {
            TreeItem treeItem = (TreeItem)layerToTreeItem.get(layer);
            treeItems.add(treeItem);
        }
        this._timelineManager.redraw();
        this._splitLayersAction.setEnabled(this.canSplitSelectedLayers());
        this.selectAndReveal(treeItems);
        this.collectAnimatableValues();
    }

    private void handleKeyframesChange(ProjectEvent event) {
        Object[][] data;
        if (event.composition != this._composition) {
            return;
        }
        Map layerToTreeItem = Util.newMap();
        TreeItem[] treeItemArray = this._treeViewer.getTree().getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement element = (LayerElement)treeItem.getData();
            layerToTreeItem.put(element.layer, treeItem);
            ++n2;
        }
        Set treeItems = Util.newSet();
        this._timelineManager.clearKeyframeSelection();
        Object[][] objectArray = data = (Object[][])event.data;
        int n3 = data.length;
        int n4 = 0;
        while (n4 < n3) {
            AnimatableValue avalue;
            TreeItem treeItem;
            Object[] o = objectArray[n4];
            Layer layer = (Layer)o[0];
            int effectIndex = (Integer)o[1];
            String property = (String)o[2];
            Time time = (Time)o[3];
            TreeItem layerItem = (TreeItem)layerToTreeItem.get(layer);
            if (effectIndex == -1) {
                treeItem = this.findLayerAnimatableValueItem(layerItem, property);
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
                if (property.equals("timeRemap")) {
                    if (treeItem == null && avalue.hasKeyframe()) {
                        this._treeViewer.refresh(layerItem.getData(), false);
                        treeItem = this.findLayerAnimatableValueItem(layerItem, property);
                    } else if (treeItem != null && !avalue.hasKeyframe()) {
                        this._treeViewer.refresh(layerItem.getData(), false);
                        treeItem = null;
                        treeItems.add(layerItem);
                    }
                }
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(effectIndex);
                treeItem = this.findEffectAnimatableValueItem(layerItem, effect, property);
                avalue = (AnimatableValue)PropertyUtil.getProperty(effect, property);
            }
            if (treeItem != null) {
                treeItems.add(treeItem);
                AnimatableValueElement element = (AnimatableValueElement)treeItem.getData();
                this._treeViewer.update((Object)element, null);
                if (time != null) {
                    Keyframe kf = avalue.getKeyframe(time);
                    this._timelineManager.addKeyframeSelection(kf, element);
                }
            }
            ++n4;
        }
        this.selectAndReveal(treeItems);
        this.collectAnimatableValues();
    }

    private void handleLayerSlipEdit(ProjectEvent event) {
        Object[][] data;
        if (event.composition != this._composition) {
            return;
        }
        Tree tree = this._treeViewer.getTree();
        Map layerToTreeItem = Util.newMap();
        TreeItem[] treeItemArray = tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            LayerElement element = (LayerElement)treeItem.getData();
            layerToTreeItem.put(element.layer, treeItem);
            ++n2;
        }
        Set treeItems = Util.newSet();
        Collection layers = (Collection)((Object[])event.data)[0];
        for (Layer layer : layers) {
            TreeItem treeItem = (TreeItem)layerToTreeItem.get(layer);
            treeItems.add(treeItem);
            this._treeViewer.update(treeItem.getData(), null);
            Rectangle bounds = treeItem.getBounds();
            if (WIN32) {
                Rectangle clientArea = tree.getClientArea();
                bounds.x = clientArea.x;
                bounds.width = clientArea.width;
            }
            tree.redraw(bounds.x, bounds.y, bounds.width, bounds.height, false);
        }
        this._timelineManager.clearKeyframeSelection();
        Object[][] objectArray = data = (Object[][])((Object[])event.data)[1];
        int n3 = data.length;
        int n4 = 0;
        while (n4 < n3) {
            AnimatableValue avalue;
            TreeItem treeItem;
            Object[] o = objectArray[n4];
            Layer layer = (Layer)o[0];
            int effectIndex = (Integer)o[1];
            String property = (String)o[2];
            Time time = (Time)o[3];
            if (effectIndex == -1) {
                treeItem = this.findLayerAnimatableValueItem((TreeItem)layerToTreeItem.get(layer), property);
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(effectIndex);
                treeItem = this.findEffectAnimatableValueItem((TreeItem)layerToTreeItem.get(layer), effect, property);
                avalue = (AnimatableValue)PropertyUtil.getProperty(effect, property);
            }
            treeItems.add(treeItem);
            AnimatableValueElement element = (AnimatableValueElement)treeItem.getData();
            this._treeViewer.update((Object)element, null);
            if (time != null) {
                Keyframe kf = avalue.getKeyframe(time);
                this._timelineManager.addKeyframeSelection(kf, element);
            }
            ++n4;
        }
        this.selectAndReveal(treeItems);
        this.collectAnimatableValues();
    }

    private void handleNewCameraLayerAction() {
        if (this._projectManager != null && this._composition != null) {
            this._projectManager.postOperation(new NewCameraLayerOperation(this._projectManager, this._composition));
        }
    }

    private void handleNewNullLayerAction() {
        if (this._projectManager != null && this._composition != null) {
            this._projectManager.postOperation(new NewNullLayerOperation(this._projectManager, this._composition));
        }
    }

    private void handleNewTextLayerAction() {
        if (this._projectManager != null && this._composition != null) {
            this._projectManager.postOperation(new NewTextLayerOperation(this._projectManager, this._composition));
        }
    }

    public CompositionItem getCompositionItem() {
        return this._compItem;
    }

    public LayerComposition getLayerComposition() {
        return this._composition;
    }

    public void editExpression(AnimatableValueElement avalueElement) {
        this._treeViewer.setExpandedState((Object)avalueElement, true);
        AnimatableValueElementDelegate.ExpressionElement exprElement = (AnimatableValueElementDelegate.ExpressionElement)avalueElement.getChildren()[0];
        this._treeViewer.editElement((Object)exprElement, 7);
    }

    public void update(Time time) {
        if (this._playerLinkListeners.isEmpty()) {
            this._time = time;
            this.collectAnimatableValues(time);
            this._timelineManager.update(time, true);
            this._timeCodeComposite.redraw();
            this._splitLayersAction.setEnabled(this.canSplitSelectedLayers());
        } else {
            this.collectAnimatableValues(time);
            this.refreshPlayer(time);
        }
    }

    public void addPlayerLinkListener(PlayerLinkListener listener) {
        this._playerLinkListeners.add((Object)listener);
    }

    public void removePlayerLinkListener(PlayerLinkListener listener) {
        this._playerLinkListeners.remove((Object)listener);
    }

    private void refreshPlayer(Time time) {
        PlayerLinkEvent event = new PlayerLinkEvent(this, time);
        Object[] objectArray = this._playerLinkListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object l = objectArray[n2];
            ((PlayerLinkListener)l).handlePlayerLinkEvent(event);
            ++n2;
        }
    }

    @Override
    public void handlePlayerLinkEvent(PlayerLinkEvent event) {
        this._time = event.time;
        this._timelineUpdateTask.schedule();
        this._collectTask.schedule();
    }

    private void connectToPlayer() {
        String itemId = this.getItemId();
        if (!_connectingIds.contains(itemId)) {
            _connectingIds.add(itemId);
            try {
                MediaPlayerView playerView = (MediaPlayerView)UIUtil.findView(this.getSite().getPage(), "ch.kuramo.javie.app.views.mediaPlayerView", itemId);
                LayerCompositionView.connectToPlayer(this, playerView);
            }
            finally {
                _connectingIds.remove(itemId);
            }
        }
    }

    static void connectToPlayer(MediaPlayerView playerView) {
        String itemId = playerView.getItemId();
        if (!_connectingIds.contains(itemId)) {
            _connectingIds.add(itemId);
            try {
                LayerCompositionView compView = (LayerCompositionView)UIUtil.findView(playerView.getSite().getPage(), ID, itemId);
                LayerCompositionView.connectToPlayer(compView, playerView);
            }
            finally {
                _connectingIds.remove(itemId);
            }
        }
    }

    private static void connectToPlayer(final LayerCompositionView compView, final MediaPlayerView playerView) {
        if (compView == null || playerView == null) {
            return;
        }
        final MediaPlayer player = playerView.getMediaPlayer();
        compView.addPlayerLinkListener(player);
        player.addPlayerLinkListener(compView);
        final IWorkbenchPage page = compView.getSite().getPage();
        IPartListener partListener = new IPartListener(){

            public void partClosed(IWorkbenchPart part) {
                if (part == playerView || part == compView) {
                    compView.removePlayerLinkListener(player);
                    player.removePlayerLinkListener(compView);
                    page.removePartListener((IPartListener)this);
                }
            }

            public void partActivated(IWorkbenchPart part) {
                if (part == compView) {
                    this.showView((IViewPart)playerView, (IViewPart)compView);
                } else if (part == playerView) {
                    this.showView((IViewPart)compView, (IViewPart)playerView);
                }
            }

            private void showView(IViewPart targetView, IViewPart companionView) {
                IViewPart[] iViewPartArray = page.getViewStack(companionView);
                int n = iViewPartArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewPart vp = iViewPartArray[n2];
                    if (vp == targetView) {
                        return;
                    }
                    ++n2;
                }
                IViewPart[] stack = page.getViewStack(targetView);
                if (stack == null) {
                    return;
                }
                IViewPart[] iViewPartArray2 = stack;
                int n3 = stack.length;
                n = 0;
                while (n < n3) {
                    IViewPart vp = iViewPartArray2[n];
                    if (vp != targetView && page.isPartVisible((IWorkbenchPart)vp) && vp instanceof MediaPlayerView && ((MediaPlayerView)vp).isPinned()) {
                        return;
                    }
                    ++n;
                }
                try {
                    IViewSite viewSite = targetView.getViewSite();
                    page.showView(viewSite.getId(), viewSite.getSecondaryId(), 2);
                }
                catch (PartInitException e) {
                    _logger.error("error activating ViewPart", (Throwable)e);
                }
            }

            public void partOpened(IWorkbenchPart part) {
            }

            public void partDeactivated(IWorkbenchPart part) {
            }

            public void partBroughtToTop(IWorkbenchPart part) {
            }
        };
        page.addPartListener(partListener);
    }
}

