/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.api;

public final class Color {
    public static final Color COLORLESS_TRANSPARENT = new Color(0.0, 0.0, 0.0, 0.0);
    public static final Color BLACK = new Color(0.0, 0.0, 0.0, 1.0);
    public static final Color WHITE = new Color(1.0, 1.0, 1.0, 1.0);
    public static final Color GRAY = new Color(0.5, 0.5, 0.5, 1.0);
    public final double r;
    public final double g;
    public final double b;
    public final double a;
    private final Color clampedColor;

    public Color(double red, double green, double blue, double alpha) {
        this.r = red;
        this.g = green;
        this.b = blue;
        this.a = alpha;
        this.clampedColor = this.r >= 0.0 && this.r <= 1.0 && this.g >= 0.0 && this.g <= 1.0 && this.b >= 0.0 && this.b <= 1.0 && this.a >= 0.0 && this.a <= 1.0 ? this : new Color(Double.isNaN(this.r) ? 0.0 : Math.max(0.0, Math.min(1.0, this.r)), Double.isNaN(this.g) ? 0.0 : Math.max(0.0, Math.min(1.0, this.g)), Double.isNaN(this.b) ? 0.0 : Math.max(0.0, Math.min(1.0, this.b)), Double.isNaN(this.a) ? 1.0 : Math.max(0.0, Math.min(1.0, this.a)));
    }

    public Color(double red, double green, double blue) {
        this(red, green, blue, 1.0);
    }

    public Color clamp() {
        return this.clampedColor;
    }

    public int hashCode() {
        int result = 1;
        long temp = Double.doubleToLongBits(this.a);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.b);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.g);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.r);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Color other = (Color)obj;
        if (Double.doubleToLongBits(this.a) != Double.doubleToLongBits(other.a)) {
            return false;
        }
        if (Double.doubleToLongBits(this.b) != Double.doubleToLongBits(other.b)) {
            return false;
        }
        if (Double.doubleToLongBits(this.g) != Double.doubleToLongBits(other.g)) {
            return false;
        }
        return Double.doubleToLongBits(this.r) == Double.doubleToLongBits(other.r);
    }

    public String toString() {
        return "Color [r=" + this.r + ", g=" + this.g + ", b=" + this.b + ", a=" + this.a + "]";
    }
}

