/*
 * Decompiled with CFR 0.152.
 */
package ca.uol.aig.fftpack;

import ca.uol.aig.fftpack.Complex1D;
import ca.uol.aig.fftpack.RealDoubleFFT_Mixed;

public class RealDoubleFFT
extends RealDoubleFFT_Mixed {
    public final double norm_factor;
    private final double[] wavetable;
    private final int ndim;

    public RealDoubleFFT(int n) {
        this.ndim = n;
        this.norm_factor = n;
        this.wavetable = new double[2 * this.ndim + 15];
        this.rffti(this.ndim, this.wavetable);
    }

    public void ft(double[] x) {
        if (x.length != this.ndim) {
            throw new IllegalArgumentException("The length of data can not match that of the wavetable");
        }
        this.rfftf(this.ndim, x, this.wavetable);
    }

    public void ft(double[] x, int len) {
        if (len != this.ndim) {
            throw new IllegalArgumentException("The length of data can not match that of the wavetable");
        }
        if (x.length < len) {
            throw new IndexOutOfBoundsException();
        }
        this.rfftf(this.ndim, x, this.wavetable);
    }

    public void ft(double[] x, Complex1D y) {
        if (x.length != this.ndim) {
            throw new IllegalArgumentException("The length of data can not match that of the wavetable");
        }
        this.rfftf(this.ndim, x, this.wavetable);
        if (this.ndim % 2 == 0) {
            y.x = new double[this.ndim / 2 + 1];
            y.y = new double[this.ndim / 2 + 1];
        } else {
            y.x = new double[(this.ndim + 1) / 2];
            y.y = new double[(this.ndim + 1) / 2];
        }
        y.x[0] = x[0];
        y.y[0] = 0.0;
        int i = 1;
        while (i < (this.ndim + 1) / 2) {
            y.x[i] = x[2 * i - 1];
            y.y[i] = x[2 * i];
            ++i;
        }
        if (this.ndim % 2 == 0) {
            y.x[this.ndim / 2] = x[this.ndim - 1];
            y.y[this.ndim / 2] = 0.0;
        }
    }

    public void bt(double[] x) {
        if (x.length != this.ndim) {
            throw new IllegalArgumentException("The length of data can not match that of the wavetable");
        }
        this.rfftb(this.ndim, x, this.wavetable);
    }

    public void bt(Complex1D x, double[] y) {
        if (this.ndim % 2 == 0 ? x.x.length != this.ndim / 2 + 1 : x.x.length != (this.ndim + 1) / 2) {
            throw new IllegalArgumentException("The length of data can not match that of the wavetable");
        }
        y[0] = x.x[0];
        int i = 1;
        while (i < (this.ndim + 1) / 2) {
            y[2 * i - 1] = x.x[i];
            y[2 * i] = x.y[i];
            ++i;
        }
        if (this.ndim % 2 == 0) {
            y[this.ndim - 1] = x.x[this.ndim / 2];
        }
        this.rfftb(this.ndim, y, this.wavetable);
    }
}

