/*
 * Decompiled with CFR 0.152.
 */
package ca.uol.aig.fftpack;

import ca.uol.aig.fftpack.RealDoubleFFT_Mixed;

public class RealDoubleFFT_Even_Odd
extends RealDoubleFFT_Mixed {
    public double norm_factor;
    protected double[] wavetable;
    protected int ndim;

    public RealDoubleFFT_Even_Odd(int n) {
        this.ndim = n;
        this.norm_factor = 4 * n;
        if (this.wavetable == null || this.wavetable.length != 3 * this.ndim + 15) {
            this.wavetable = new double[3 * this.ndim + 15];
        }
        this.cosqi(this.ndim, this.wavetable);
    }

    public void ft(double[] x) {
        this.cosqf(this.ndim, x, this.wavetable);
    }

    public void bt(double[] x) {
        this.cosqb(this.ndim, x, this.wavetable);
    }

    void cosqf1(int n, double[] x, double[] wtable) {
        int kc;
        int ns2 = (n + 1) / 2;
        int k = 1;
        while (k < ns2) {
            kc = n - k;
            wtable[k + n] = x[k] + x[kc];
            wtable[kc + n] = x[k] - x[kc];
            ++k;
        }
        int modn = n % 2;
        if (modn == 0) {
            wtable[ns2 + n] = x[ns2] + x[ns2];
        }
        k = 1;
        while (k < ns2) {
            kc = n - k;
            x[k] = wtable[k - 1] * wtable[kc + n] + wtable[kc - 1] * wtable[k + n];
            x[kc] = wtable[k - 1] * wtable[k + n] - wtable[kc - 1] * wtable[kc + n];
            ++k;
        }
        if (modn == 0) {
            x[ns2] = wtable[ns2 - 1] * wtable[ns2 + n];
        }
        this.rfftf1(n, x, wtable, n);
        int i = 2;
        while (i < n) {
            double xim1 = x[i - 1] - x[i];
            x[i] = x[i - 1] + x[i];
            x[i - 1] = xim1;
            i += 2;
        }
    }

    void cosqb1(int n, double[] x, double[] wtable) {
        int kc;
        int ns2 = (n + 1) / 2;
        int i = 2;
        while (i < n) {
            double xim1 = x[i - 1] + x[i];
            int n2 = i;
            x[n2] = x[n2] - x[i - 1];
            x[i - 1] = xim1;
            i += 2;
        }
        x[0] = x[0] + x[0];
        int modn = n % 2;
        if (modn == 0) {
            int n3 = n - 1;
            x[n3] = x[n3] + x[n - 1];
        }
        this.rfftb1(n, x, wtable, n);
        int k = 1;
        while (k < ns2) {
            kc = n - k;
            wtable[k + n] = wtable[k - 1] * x[kc] + wtable[kc - 1] * x[k];
            wtable[kc + n] = wtable[k - 1] * x[k] - wtable[kc - 1] * x[kc];
            ++k;
        }
        if (modn == 0) {
            x[ns2] = wtable[ns2 - 1] * (x[ns2] + x[ns2]);
        }
        k = 1;
        while (k < ns2) {
            kc = n - k;
            x[k] = wtable[k + n] + wtable[kc + n];
            x[kc] = wtable[k + n] - wtable[kc + n];
            ++k;
        }
        x[0] = x[0] + x[0];
    }

    void cosqf(int n, double[] x, double[] wtable) {
        if (n < 2) {
            return;
        }
        if (n == 2) {
            double tsqx = 1.4142135623731 * x[1];
            x[1] = x[0] - tsqx;
            x[0] = x[0] + tsqx;
        } else {
            this.cosqf1(n, x, wtable);
        }
    }

    void cosqb(int n, double[] x, double[] wtable) {
        if (n < 2) {
            x[0] = x[0] * 4.0;
        } else if (n == 2) {
            double x1 = 4.0 * (x[0] + x[1]);
            x[1] = 2.82842712474619 * (x[0] - x[1]);
            x[0] = x1;
        } else {
            this.cosqb1(n, x, wtable);
        }
    }

    void cosqi(int n, double[] wtable) {
        double dt = 1.5707963267948966 / (double)n;
        int k = 0;
        while (k < n) {
            wtable[k] = Math.cos((double)(k + 1) * dt);
            ++k;
        }
        this.rffti1(n, wtable, n);
    }
}

