/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.transition;

import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.GradientWipe", category="ch.kuramo.javie.api.effectCategory.transition")
public class GradientWipe {
    @ShaderSource
    public static final String[] GRADIENT_WIPE_NORMAL = GradientWipe.createShaderSource(false, false);
    @ShaderSource
    public static final String[] GRADIENT_WIPE_NORMAL_TILE = GradientWipe.createShaderSource(false, true);
    @ShaderSource
    public static final String[] GRADIENT_WIPE_INVERT = GradientWipe.createShaderSource(true, false);
    @ShaderSource
    public static final String[] GRADIENT_WIPE_INVERT_TILE = GradientWipe.createShaderSource(true, true);
    @Property(min="0", max="100")
    private IAnimatableDouble transitionCompletion;
    @Property(min="0", max="100")
    private IAnimatableDouble transitionSoftness;
    @Property
    private IAnimatableLayerReference gradientLayer;
    @Property(value="STRETCH")
    private IAnimatableEnum<GradientPlacement> gradientPlacement;
    @Property
    private IAnimatableBoolean invertGradient;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram normalProgram;
    private final IShaderProgram normalTileProgram;
    private final IShaderProgram invertProgram;
    private final IShaderProgram invertTileProgram;
    private static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$effects$transition$GradientWipe$GradientPlacement;

    private static String[] createShaderSource(boolean invert, boolean tile) {
        return new String[]{"uniform sampler2DRect srcTex;", "uniform sampler2DRect grdTex;", "uniform float min;", "uniform float max;", tile ? "uniform vec2 size;" : "", "", "const vec3 yvec = vec3(0.299, 0.587, 0.114);", "", "void main(void)", "{", "\tvec4 src = texture2DRect(srcTex, gl_TexCoord[0].st);", "\tvec2 grdCoord = gl_TexCoord[1].st;", tile ? "\tvec4 grd = texture2DRect(grdTex, grdCoord - floor(grdCoord/size)*size);" : "\tvec4 grd = texture2DRect(grdTex, grdCoord);", invert ? "\tfloat y = 1.0 - dot(grd.rgb, yvec);" : "\tfloat y = dot(grd.rgb, yvec);", "\tfloat a = clamp((y-min)/(max-min), 0.0, 1.0);", "\tgl_FragColor = src*a;", "}"};
    }

    @Inject
    public GradientWipe(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.normalProgram = shaders.getProgram(GradientWipe.class, "GRADIENT_WIPE_NORMAL");
        this.normalTileProgram = shaders.getProgram(GradientWipe.class, "GRADIENT_WIPE_NORMAL_TILE");
        this.invertProgram = shaders.getProgram(GradientWipe.class, "GRADIENT_WIPE_INVERT");
        this.invertTileProgram = shaders.getProgram(GradientWipe.class, "GRADIENT_WIPE_INVERT_TILE");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IVideoBuffer doVideoEffect() {
        completion = (Double)this.context.value((IAnimatableValue)this.transitionCompletion) / 100.0;
        if (completion == 1.0) {
            buffer = this.context.createVideoBuffer(this.context.getPreviousBounds());
            buffer.clear();
            return buffer;
        }
        input = this.context.doPreviousEffect();
        if (completion == 0.0) {
            return input;
        }
        bounds = input.getBounds();
        if (bounds.isEmpty()) {
            return input;
        }
        tmpBuffers = new HashSet<IVideoBuffer>();
        tmpBuffers.add(input);
        try {
            softness = (Double)this.context.value((IAnimatableValue)this.transitionSoftness) / 100.0;
            placement = (GradientPlacement)this.context.value(this.gradientPlacement);
            tile = placement == GradientPlacement.TILE;
            invert = (Boolean)this.context.value((IAnimatableValue)this.invertGradient);
            max = (1.0 + softness) * completion;
            min = max - softness;
            gradient = this.context.getLayerVideoFrame(this.gradientLayer);
            if (gradient == null) {
                gradient = this.context.createVideoBuffer(new VideoBounds(0, 0));
                gradient.clear();
            }
            tmpBuffers.add(gradient);
            gradBounds = gradient.getBounds();
            texCoords = new double[2][][];
            w = bounds.width;
            h = bounds.height;
            texCoords[0] = new double[][]{{0.0, 0.0}, {w, 0.0}, {w, h}, {0.0, h}};
            switch (GradientWipe.$SWITCH_TABLE$ch$kuramo$javie$effects$transition$GradientWipe$GradientPlacement()[placement.ordinal()]) {
                case 2: {
                    s = (float)(gradBounds.width - bounds.width) / 2.0f;
                    t = (float)(gradBounds.height - bounds.height) / 2.0f;
                    texCoords[1] = new double[][]{{s, t}, {s + (float)w, t}, {s + (float)w, t + (float)h}, {s, t + (float)h}};
                    break;
                }
                case 3: {
                    gw = gradBounds.width;
                    gh = gradBounds.height;
                    texCoords[1] = new double[][]{{0.0, 0.0}, {gw, 0.0}, {gw, gh}, {0.0, gh}};
                    break;
                }
                default: {
                    texCoords[1] = new double[][]{{0.0, 0.0}, {w, 0.0}, {w, h}, {0.0, h}};
                }
            }
            program = tile ? (invert ? this.invertTileProgram : this.normalTileProgram) : (invert != false ? this.invertProgram : this.normalProgram);
            uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("srcTex", 0));
            uniforms.add(new GLUniformData("grdTex", 1));
            uniforms.add(new GLUniformData("min", (float)min));
            uniforms.add(new GLUniformData("max", (float)max));
            if (tile) {
                uniforms.add(new GLUniformData("size", 2, FloatBuffer.wrap(new float[]{gradBounds.width, gradBounds.height})));
            }
            operation = new Runnable(){

                public void run() {
                    GradientWipe.this.support.ortho2D(bounds);
                    GradientWipe.this.support.quad2D(bounds, texCoords);
                }
            };
            if (placement == GradientPlacement.STRETCH) {
                gradient.setTextureFilter(IVideoBuffer.TextureFilter.LINEAR);
            }
            var24_24 = this.support.useShaderProgram(program, uniforms, operation, 0, null, new IVideoBuffer[]{input, gradient});
            return var24_24;
        }
        finally {
            ** for (vb : tmpBuffers)
        }
lbl-1000:
        // 1 sources

        {
            vb.dispose();
            continue;
        }
lbl68:
        // 1 sources

        return var24_24;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$ch$kuramo$javie$effects$transition$GradientWipe$GradientPlacement() {
        if ($SWITCH_TABLE$ch$kuramo$javie$effects$transition$GradientWipe$GradientPlacement != null) {
            return $SWITCH_TABLE$ch$kuramo$javie$effects$transition$GradientWipe$GradientPlacement;
        }
        int[] nArray = new int[GradientPlacement.values().length];
        try {
            nArray[GradientPlacement.CENTER.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GradientPlacement.STRETCH.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GradientPlacement.TILE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$ch$kuramo$javie$effects$transition$GradientWipe$GradientPlacement = nArray;
        return nArray;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GradientPlacement {
        TILE,
        CENTER,
        STRETCH;

    }
}

