/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.core.AbstractItem;
import ch.kuramo.javie.core.ImageSequenceItem;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaOptions;
import ch.kuramo.javie.core.MediaSource;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.ProjectDecodeException;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.ImageSequenceSource;
import ch.kuramo.javie.core.internal.MediaInputPlaceholderImpl;
import ch.kuramo.javie.core.services.MediaSourceFactory;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.io.File;
import net.arnx.jsonic.JSONHint;

@ProjectElement(value="imageSequence")
public class ImageSequenceItemImpl
extends AbstractItem
implements ImageSequenceItem {
    private File _file;
    private MediaSource _mediaSource;
    private MediaOptions _mediaOptions;
    private MediaInput _mediaInput;
    private VideoBounds _placeholderBounds;
    private final MediaSourceFactory _mediaSourceFactory;
    private final Injector _injector;

    @Inject
    public ImageSequenceItemImpl(MediaSourceFactory mediaSourceFactory, Injector injector) {
        this._mediaSourceFactory = mediaSourceFactory;
        this._injector = injector;
    }

    public void initialize(File file, Time frameDuration) {
        super.initialize();
        ImageSequenceSource imgSeqSource = this._mediaSourceFactory.get(ImageSequenceSource.class, this.getId(), file);
        if (imgSeqSource != null) {
            this._file = imgSeqSource.getFirstFile();
            this.setName(this._file.getName());
            this._mediaSource = imgSeqSource;
            this._mediaOptions = imgSeqSource.validateOptions(null);
            this._mediaOptions.setVideoFrameDuration(frameDuration);
            this._mediaInput = new MediaInputImpl();
        }
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        this._mediaInput = null;
        if (this._mediaSource != null) {
            this._mediaSourceFactory.release(this.getId());
            this._mediaSource = null;
        }
    }

    public File getFile() {
        return this._file;
    }

    public void setFile(File file) {
        this._file = file;
    }

    @JSONHint(ignore=true)
    public MediaSource getMediaSource() {
        return this._mediaSource;
    }

    public MediaOptions getMediaOptions() {
        return this._mediaOptions != null ? this._mediaOptions.clone() : null;
    }

    public void setMediaOptions(MediaOptions options) {
        if (this._mediaSource != null) {
            this._mediaOptions = this._mediaSource.validateOptions(options);
        } else {
            if (this._mediaInput != null) {
                throw new UnsupportedOperationException();
            }
            this._mediaOptions = options != null ? options.clone() : null;
        }
    }

    @JSONHint(ignore=true)
    public MediaInput getMediaInput() {
        return this._mediaInput;
    }

    public VideoBounds getPlaceholderBounds() {
        this._placeholderBounds = this._mediaSource != null && this._mediaSource.isVideoAvailable() ? this._mediaSource.getVideoFrameBounds(this._mediaOptions) : null;
        return this._placeholderBounds;
    }

    public void setPlaceholderBounds(VideoBounds placeholderBounds) {
        this._placeholderBounds = placeholderBounds;
    }

    public void afterDecode(Project p) throws ProjectDecodeException {
        super.afterDecode(p);
        ImageSequenceSource imgSeqSource = this._mediaSourceFactory.get(ImageSequenceSource.class, this.getId(), this._file);
        if (imgSeqSource != null) {
            this._file = imgSeqSource.getFirstFile();
            this._mediaSource = imgSeqSource;
            this._mediaOptions = imgSeqSource.validateOptions(this._mediaOptions);
            this._mediaInput = new MediaInputImpl();
        } else {
            MediaInputPlaceholderImpl placeholder = (MediaInputPlaceholderImpl)this._injector.getInstance(MediaInputPlaceholderImpl.class);
            placeholder.setVideoFrameBounds(this._placeholderBounds);
            this._mediaInput = placeholder;
        }
    }

    @JSONHint(ignore=true)
    public String getKind() {
        return "\u30a4\u30e1\u30fc\u30b8\u30b7\u30fc\u30b1\u30f3\u30b9";
    }

    private class MediaInputImpl
    implements MediaInput {
        private MediaInputImpl() {
        }

        public boolean isVideoAvailable() {
            return ImageSequenceItemImpl.this._mediaSource.isVideoAvailable();
        }

        public boolean isAudioAvailable() {
            return ImageSequenceItemImpl.this._mediaSource.isAudioAvailable();
        }

        public Time getDuration() {
            return ImageSequenceItemImpl.this._mediaSource.getDuration(ImageSequenceItemImpl.this._mediaOptions);
        }

        public Time getVideoFrameDuration() {
            return ImageSequenceItemImpl.this._mediaSource.getVideoFrameDuration(ImageSequenceItemImpl.this._mediaOptions);
        }

        public VideoBounds getVideoFrameBounds() {
            return ImageSequenceItemImpl.this._mediaSource.getVideoFrameBounds(ImageSequenceItemImpl.this._mediaOptions);
        }

        public IVideoBuffer getVideoFrame(Time mediaTime) {
            return ImageSequenceItemImpl.this._mediaSource.getVideoFrame(mediaTime, ImageSequenceItemImpl.this._mediaOptions);
        }

        public IAudioBuffer getAudioChunk(Time mediaTime) {
            return ImageSequenceItemImpl.this._mediaSource.getAudioChunk(mediaTime, ImageSequenceItemImpl.this._mediaOptions);
        }
    }
}

