/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.services.GLGlobal;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLDrawableFactory;
import javax.media.opengl.GLException;
import javax.media.opengl.GLPbuffer;
import javax.media.opengl.GLProfile;
import javax.media.opengl.Threading;
import javax.media.opengl.awt.GLCanvas;

public class GLGlobalImpl
implements GLGlobal {
    private final ReentrantLock _lock = new ReentrantLock();
    private final String _initError;
    private final GLPbuffer _pbuffer;
    private final GLContext _sharedContext;
    private final String _vendor;
    private final boolean _intel;
    private final boolean _amdAti;
    private final boolean _nvidia;
    private final int _maxSamples;
    private final int _maxTextureImageUnits;
    private Queue<GLContext> _pool;
    private GLCapabilities _canvasCapabilities;

    public GLGlobalImpl() {
        GLProfile profile = GLProfile.get((String)"GL2");
        GLCapabilities glcap = new GLCapabilities(profile);
        glcap.setHardwareAccelerated(true);
        glcap.setDoubleBuffered(false);
        glcap.setOnscreen(true);
        glcap.setPBuffer(false);
        this.setCanvasCapabilities(glcap);
        glcap.setOnscreen(false);
        glcap.setPBuffer(true);
        GLPbuffer pbuf = null;
        GLException exception = null;
        try {
            pbuf = GLDrawableFactory.getFactory((GLProfile)profile).createGLPbuffer(glcap, null, 1, 1, null);
        }
        catch (GLException e) {
            exception = e;
        }
        Object[] strings = new String[1];
        int[] integers = new int[2];
        if (pbuf != null) {
            this._initError = null;
            this._pbuffer = pbuf;
            this._sharedContext = this._pbuffer.getContext();
            Threading.invokeOnOpenGLThread((Runnable)new Runnable((String[])strings, integers){
                private final /* synthetic */ String[] val$strings;
                private final /* synthetic */ int[] val$integers;
                {
                    this.val$strings = stringArray;
                    this.val$integers = nArray;
                }

                public void run() {
                    GLGlobalImpl.this._sharedContext.makeCurrent();
                    try {
                        GL gl = GLGlobalImpl.this._sharedContext.getGL();
                        this.val$strings[0] = gl.glGetString(7936);
                        gl.glGetIntegerv(36183, this.val$integers, 0);
                        gl.glGetIntegerv(34930, this.val$integers, 1);
                    }
                    finally {
                        GLGlobalImpl.this._sharedContext.release();
                    }
                }
            });
        } else {
            this._initError = exception.getMessage();
            this._pbuffer = null;
            this._sharedContext = null;
            Arrays.fill(strings, "");
            Arrays.fill(integers, 0);
        }
        this._vendor = strings[0];
        String lcVendor = this._vendor.toLowerCase();
        this._intel = lcVendor.contains("intel");
        this._amdAti = lcVendor.contains("amd") || lcVendor.contains("ati");
        this._nvidia = lcVendor.contains("nvidia");
        this._maxSamples = integers[0];
        this._maxTextureImageUnits = integers[1];
    }

    public ReentrantLock getGlobalLock() {
        return this._lock;
    }

    public String getInitError() {
        return this._initError;
    }

    public GLContext getSharedContext() {
        return this._sharedContext;
    }

    public String getVendor() {
        return this._vendor;
    }

    public boolean isIntel() {
        return this._intel;
    }

    public boolean isAmdAti() {
        return this._amdAti;
    }

    public boolean isNvidia() {
        return this._nvidia;
    }

    public int getMaxSamples() {
        return this._maxSamples;
    }

    public int getMaxTextureImageUnits() {
        return this._maxTextureImageUnits;
    }

    public void enterPoolMode(final int poolSize) {
        if (this._pool != null) {
            throw new IllegalStateException("already in pool mode");
        }
        if (poolSize <= 0) {
            throw new IllegalArgumentException("poolSize must be one or greater");
        }
        this._pool = new LinkedList<GLContext>();
        Threading.invokeOnOpenGLThread((Runnable)new Runnable(){

            public void run() {
                int i = 0;
                while (i < poolSize) {
                    GLContext context = GLGlobalImpl.this._pbuffer.createContext(GLGlobalImpl.this._sharedContext);
                    context.makeCurrent();
                    context.release();
                    GLGlobalImpl.this._pool.offer(context);
                    ++i;
                }
            }
        });
    }

    public GLContext createContext() {
        if (this._pool != null) {
            GLContext context = this._pool.poll();
            if (context == null) {
                throw new JavieRuntimeException("no GLContext is available");
            }
            return context;
        }
        return this._pbuffer.createContext(this._sharedContext);
    }

    public void destroyContext(GLContext context) {
        if (this._pool != null) {
            this._pool.offer(context);
        } else {
            context.destroy();
        }
    }

    public GLCapabilities getCanvasCapabilities() {
        return (GLCapabilities)this._canvasCapabilities.clone();
    }

    public void setCanvasCapabilities(GLCapabilities capabilities) {
        this._canvasCapabilities = (GLCapabilities)capabilities.clone();
    }

    public GLCanvas createCanvas() {
        return new GLCanvas(this._canvasCapabilities, null, this._sharedContext, null);
    }
}

