/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.actions;

import ch.kuramo.javie.app.ColorUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ReplaceLayerItemOperation;
import ch.kuramo.javie.app.views.ItemLabelProvider;
import ch.kuramo.javie.app.views.ItemTreeContentProvider;
import ch.kuramo.javie.app.widgets.FontUtil;
import ch.kuramo.javie.core.CompositionItem;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.ItemLayer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.MediaInputPlaceholder;
import ch.kuramo.javie.core.MediaItem;
import ch.kuramo.javie.core.MediaItemLayer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeColumnViewerLabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ReplaceLayerItemDialog
extends Dialog {
    private static final boolean COCOA = SWT.getPlatform().equals("cocoa");
    private final ProjectManager projectManager;
    private final LayerComposition composition;
    private final ItemLayer<?> layer;
    private TreeViewer treeViewer;
    private Label messageLabel;
    private Item selectedItem;

    ReplaceLayerItemDialog(Shell parentShell, ProjectManager pm, LayerComposition composition, ItemLayer<?> layer) {
        super(parentShell);
        this.projectManager = pm;
        this.composition = composition;
        this.layer = layer;
    }

    protected Point getInitialSize() {
        return new Point(700, 400);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("\u30bd\u30fc\u30b9\u306e\u7f6e\u304d\u63db\u3048");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.marginHeight = 0;
        layout.marginTop = 10;
        layout.verticalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.treeViewer = new TreeViewer(composite, 2820);
        this.treeViewer.setContentProvider((IContentProvider)new ItemTreeContentProvider());
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(!COCOA);
        FontUtil.setCompatibleFont((Control)tree);
        tree.setBackground(ColorUtil.tableBackground());
        if (COCOA) {
            final Color lineColor = ColorUtil.tableRowLine();
            tree.addListener(40, new Listener(){

                public void handleEvent(Event event) {
                    int x = event.x;
                    int y = event.y + event.height - 1;
                    GC gc = event.gc;
                    gc.setForeground(lineColor);
                    gc.drawLine(x, y, x + event.width, y);
                }
            });
        }
        this.createViewerColumn(200, null, "\u540d\u524d");
        Image labelIcon = null;
        this.createViewerColumn(25, labelIcon, "");
        this.createViewerColumn(90, null, "\u7a2e\u985e");
        this.createViewerColumn(60, null, "\u30b5\u30a4\u30ba");
        this.createViewerColumn(90, null, "\uff83\uff9e\uff6d\uff9a\uff70\uff7c\uff6e\uff9d");
        this.createViewerColumn(600, null, "\u30d5\u30a1\u30a4\u30eb\u30d1\u30b9");
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ReplaceLayerItemDialog.this.update((TreeSelection)event.getSelection());
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (ReplaceLayerItemDialog.this.selectedItem != null) {
                    ReplaceLayerItemDialog.this.setReturnCode(0);
                    ReplaceLayerItemDialog.this.close();
                }
            }
        });
        this.messageLabel = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.messageLabel.setLayoutData((Object)gridData);
        this.treeViewer.setInput((Object)this.projectManager);
        return composite;
    }

    public void create() {
        super.create();
        Button okButton = this.getButton(0);
        okButton.setEnabled(false);
    }

    private TreeViewerColumn createViewerColumn(int width, Image image, String name) {
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.treeViewer, 0);
        TreeColumn column = viewerColumn.getColumn();
        column.setWidth(width);
        column.setImage(image);
        column.setText(name);
        column.setMoveable(true);
        viewerColumn.setLabelProvider((CellLabelProvider)new TreeColumnViewerLabelProvider((IBaseLabelProvider)new ItemLabelProvider()));
        return viewerColumn;
    }

    private void update(TreeSelection selection) {
        Button okButton = this.getButton(0);
        okButton.setEnabled(false);
        this.selectedItem = null;
        if (selection.size() != 1) {
            this.messageLabel.setText("");
            return;
        }
        Object element = selection.getFirstElement();
        if (element instanceof Folder) {
            this.messageLabel.setText("");
            return;
        }
        Item item = (Item)element;
        if (item == this.layer.getItem()) {
            this.messageLabel.setText(String.format("\u201c%s\u201d \u306f\u73fe\u5728\u306e\u30bd\u30fc\u30b9\u3067\u3059\u3002", item.getName()));
            return;
        }
        if (this.layer instanceof MediaItemLayer) {
            if (!(item instanceof MediaItem)) {
                this.messageLabel.setText("\u30bd\u30fc\u30b9\u3092\u7f6e\u304d\u63db\u3048\u3088\u3046\u3068\u3057\u3066\u3044\u308b\u30ec\u30a4\u30e4\u30fc\u306f\u3001\u3053\u306e\u7a2e\u985e\u306e\u30a2\u30a4\u30c6\u30e0\u3092\u30bd\u30fc\u30b9\u306b\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u305b\u3093\u3002");
                return;
            }
            if (item instanceof CompositionItem && ReplaceLayerItemOperation.checkCyclicComposition(this.composition, (CompositionItem)item)) {
                this.messageLabel.setText(String.format("\u30b3\u30f3\u30dd\u30b8\u30b7\u30e7\u30f3\u306e\u5faa\u74b0\u304c\u767a\u751f\u3059\u308b\u305f\u3081\u3001\u201c%s\u201d \u3092\u30bd\u30fc\u30b9\u306b\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002", item.getName()));
                return;
            }
            if (((MediaItem)item).getMediaInput() instanceof MediaInputPlaceholder) {
                this.messageLabel.setText(String.format("\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u3089\u306a\u3044\u305f\u3081\u3001\u201c%s\u201d \u3092\u30bd\u30fc\u30b9\u306b\u3059\u308b\u3053\u3068\u306f\u3067\u304d\u307e\u305b\u3093\u3002", item.getName()));
                return;
            }
        } else {
            return;
        }
        this.selectedItem = item;
        this.messageLabel.setText("");
        okButton.setEnabled(true);
    }

    public Item getSelectedItem() {
        return this.selectedItem;
    }
}

