/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.app.PropertyUtil;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.AnimatableValue;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Effect;
import ch.kuramo.javie.core.EffectableLayer;
import ch.kuramo.javie.core.Interpolation;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.Util;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ModifyKeyframeInterpolationOperation
extends ProjectOperation {
    private final String _compId;
    private final Object[][] _data;
    private final Interpolation _newInterpolation;

    public ModifyKeyframeInterpolationOperation(ProjectManager pm, LayerComposition comp, Object[][] data, Interpolation newInterpolation) {
        super(pm, "\u30ad\u30fc\u30d5\u30ec\u30fc\u30e0\u88dc\u9593\u6cd5\u306e\u5909\u66f4");
        pm.checkComposition((Composition)comp);
        this._compId = comp.getId();
        this._newInterpolation = newInterpolation;
        List list = Util.newList();
        Object[][] objectArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] o = objectArray[n2];
            Keyframe kf = (Keyframe)o[3];
            if (kf.interpolation != newInterpolation) {
                list.add(o);
            }
            ++n2;
        }
        this._data = (Object[][])list.toArray((T[])new Object[list.size()][]);
        this._noEffect = list.isEmpty();
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyInterpolation(false, project, pm);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyInterpolation(true, project, pm);
        return Status.OK_STATUS;
    }

    private void modifyInterpolation(boolean undo, Project project, ProjectManager pm) {
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        Object[][] data = new Object[this._data.length][];
        int i = 0;
        while (i < this._data.length) {
            AnimatableValue avalue;
            Layer layer = comp.getLayer((String)this._data[i][0]);
            Integer effectIndex = (Integer)this._data[i][1];
            String property = (String)this._data[i][2];
            Keyframe kf = (Keyframe)this._data[i][3];
            if (effectIndex == -1) {
                avalue = (AnimatableValue)PropertyUtil.getProperty(layer, property);
            } else {
                Effect effect = (Effect)((EffectableLayer)layer).getEffects().get(effectIndex);
                avalue = (AnimatableValue)PropertyUtil.getProperty(effect, property);
            }
            if (undo) {
                avalue.putKeyframe(kf);
            } else {
                avalue.putKeyframe(kf.time, kf.value, this._newInterpolation);
            }
            data[i] = new Object[]{layer, effectIndex, property, kf.time};
            ++i;
        }
        if (pm != null) {
            pm.fireKeyframesChange(comp, data);
        }
    }
}

