/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.project;

import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.project.ProjectOperation;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.MediaItemLayer;
import ch.kuramo.javie.core.Project;
import ch.kuramo.javie.core.Util;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ModifyLayerInPointOperation
extends ProjectOperation {
    private final String _compId;
    private volatile List<Entry> _entries = Util.newList();

    public ModifyLayerInPointOperation(ProjectManager projectManager, LayerComposition comp, Object[][] layersAndInPoints, Time deltaTime, String relation) {
        super(projectManager, "\u30a4\u30f3\u30dd\u30a4\u30f3\u30c8\u306e\u5909\u66f4", relation);
        this._noEffect = true;
        projectManager.checkComposition((Composition)comp);
        this._compId = comp.getId();
        Time frameDuration = comp.getFrameDuration();
        Object[][] objectArray = layersAndInPoints;
        int n = layersAndInPoints.length;
        int n2 = 0;
        while (n2 < n) {
            Time startTime;
            MediaInput input;
            Time outPoint;
            Object[] o = objectArray[n2];
            Layer layer = (Layer)o[0];
            Time newInPoint = deltaTime.add((Time)o[1]);
            if (!newInPoint.before(outPoint = layer.getOutPoint()) && !(newInPoint = Time.fromFrameNumber((long)outPoint.toFrameNumber(frameDuration), (Time)frameDuration)).before(outPoint)) {
                newInPoint = newInPoint.subtract(frameDuration);
            }
            if (layer instanceof MediaItemLayer && !LayerNature.isTimeRemapEnabled((Layer)layer) && (input = ((MediaItemLayer)layer).getMediaInput()) != null && input.getDuration() != null && newInPoint.before(startTime = layer.getStartTime())) {
                newInPoint = startTime;
            }
            Time oldInPoint = layer.getInPoint();
            this._entries.add(new Entry(layer.getId(), oldInPoint, newInPoint));
            if (!newInPoint.equals((Object)oldInPoint)) {
                this._noEffect = false;
            }
            ++n2;
        }
    }

    protected IStatus executeOrRedo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyInPoint(false, project, pm);
        return Status.OK_STATUS;
    }

    protected IStatus undo(IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) throws ExecutionException {
        this.modifyInPoint(true, project, pm);
        return Status.OK_STATUS;
    }

    private void modifyInPoint(boolean undo, Project project, ProjectManager pm) {
        List layers = null;
        if (pm != null) {
            layers = Util.newList();
        }
        LayerComposition comp = (LayerComposition)project.getComposition(this._compId);
        for (Entry e : this._entries) {
            Layer layer = comp.getLayer(e.layerId);
            layer.setInPoint(undo ? e.oldInPoint : e.newInPoint);
            if (pm == null) continue;
            layers.add(layer);
        }
        if (pm != null) {
            pm.fireLayerTimesChange(comp, layers);
        }
    }

    protected boolean merge(ProjectOperation operation, IProgressMonitor monitor, IAdaptable info, Project project, ProjectManager pm) {
        if (pm == null) {
            this.modifyInPoint(false, project, null);
            return true;
        }
        if (!(operation instanceof ModifyLayerInPointOperation)) {
            return false;
        }
        ModifyLayerInPointOperation newOp = (ModifyLayerInPointOperation)operation;
        if (!newOp._compId.equals(this._compId) || newOp._entries.size() != this._entries.size()) {
            return false;
        }
        List mergedEntries = Util.newList();
        boolean noEffect = true;
        int i = 0;
        int n = this._entries.size();
        while (i < n) {
            Entry oldEntry = this._entries.get(i);
            Entry newEntry = newOp._entries.get(i);
            if (!newEntry.layerId.equals(oldEntry.layerId)) {
                return false;
            }
            mergedEntries.add(new Entry(oldEntry.layerId, oldEntry.oldInPoint, newEntry.newInPoint));
            if (!newEntry.newInPoint.equals((Object)oldEntry.oldInPoint)) {
                noEffect = false;
            }
            ++i;
        }
        this._entries = mergedEntries;
        this.modifyInPoint(false, project, pm);
        this._noEffect = noEffect;
        return true;
    }

    private class Entry {
        final String layerId;
        final Time oldInPoint;
        final Time newInPoint;

        public Entry(String layerId, Time oldInPoint, Time newInPoint) {
            this.layerId = layerId;
            this.oldInPoint = oldInPoint;
            this.newInPoint = newInPoint;
        }
    }
}

