/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.views.ComboBoxViewerCellEditor;
import ch.kuramo.javie.app.views.layercomp.AnimatableStringElementDelegate;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.Util;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

class IntersectionGroupElementDelegate
extends AnimatableStringElementDelegate {
    private ComboBoxViewerCellEditor editor;

    IntersectionGroupElementDelegate(AnimatableValueElement element, String name, AnimatableString avalue) {
        super(element, name, avalue);
    }

    private String[] getIntersectionGroups() {
        LayerComposition comp = (LayerComposition)this.element.viewer.getData("LAYER_COMPOSITION");
        Set set = Util.newSet();
        for (Layer l : comp.getLayers()) {
            if (!(l instanceof MediaLayer) || !LayerNature.isVideoNature((Layer)l)) continue;
            AnimatableString group = ((MediaLayer)l).getIntersectionGroup();
            if (group.hasKeyframe()) {
                for (Keyframe kf : group.getKeyframeMap().values()) {
                    set.add((String)kf.value);
                }
                continue;
            }
            set.add((String)group.getStaticValue());
        }
        set.remove("");
        Object[] array = set.toArray(new String[set.size()]);
        Arrays.sort(array);
        return array;
    }

    public CellEditor getCellEditor(int columnIndex) {
        if (columnIndex == 1) {
            if (this.editor == null) {
                this.editor = new ComboBoxViewerCellEditor((Composite)this.element.viewer.getTree(), 2048);
                this.editor.setContenProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                this.editor.setLabelProvider((IBaseLabelProvider)new LabelProvider());
                ((Combo)this.editor.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        IntersectionGroupElementDelegate.this.setCellEditorValue(1, IntersectionGroupElementDelegate.this.editor.getValue());
                    }
                });
            }
            String[] groups = this.getIntersectionGroups();
            this.editor.setInput(groups);
            if (groups.length > 0) {
                this.editor.setActivationStyle(4);
            } else {
                this.editor.setActivationStyle(0);
            }
            return this.editor;
        }
        return super.getCellEditor(columnIndex);
    }
}

