/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.Dictionary;
import org.eclipse.equinox.internal.p2.director.Slicer;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.provisional.p2.query.IQueryable;

public class PermissiveSlicer
extends Slicer {
    private boolean includeOptionalDependencies;
    private boolean everythingGreedy;
    private boolean considerFilter;
    private boolean considerOnlyStrictDependency;
    private boolean evalFilterTo;
    private boolean onlyFilteredRequirements;

    public PermissiveSlicer(IQueryable input, Dictionary context, boolean includeOptionalDependencies, boolean everythingGreedy, boolean evalFilterTo, boolean considerOnlyStrictDependency, boolean onlyFilteredRequirements) {
        super(input, context, true);
        this.considerFilter = context != null && context.size() > 1;
        this.includeOptionalDependencies = includeOptionalDependencies;
        this.everythingGreedy = everythingGreedy;
        this.evalFilterTo = evalFilterTo;
        this.considerOnlyStrictDependency = considerOnlyStrictDependency;
        this.onlyFilteredRequirements = onlyFilteredRequirements;
    }

    protected boolean isApplicable(IInstallableUnit iu) {
        if (this.considerFilter) {
            return super.isApplicable(iu);
        }
        if (iu.getFilter() == null) {
            return true;
        }
        return this.evalFilterTo;
    }

    protected boolean isApplicable(IRequiredCapability req) {
        if (!this.includeOptionalDependencies && req.isOptional()) {
            return false;
        }
        if (this.considerOnlyStrictDependency && !req.getRange().getMinimum().equals((Object)req.getRange().getMaximum())) {
            return false;
        }
        if (this.considerFilter) {
            if (this.onlyFilteredRequirements && req.getFilter() == null) {
                return false;
            }
            return super.isApplicable(req);
        }
        if (req.getFilter() == null) {
            return !this.onlyFilteredRequirements;
        }
        return this.evalFilterTo;
    }

    protected boolean isGreedy(IRequiredCapability req) {
        if (this.everythingGreedy) {
            return true;
        }
        return super.isGreedy(req);
    }
}

