/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.sampled.AudioFormats;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.convert.TEncodingFormatConversionProvider;
import org.tritonus.share.sampled.convert.TSynchronousFilteredAudioInputStream;

public class UlawFormatConversionProvider
extends TEncodingFormatConversionProvider {
    private static final int ALL = -1;
    public static AudioFormat.Encoding ENC_PCM_SIGNED = new AudioFormat.Encoding("PCM_SIGNED");
    public static AudioFormat.Encoding ENC_PCM_UNSIGNED = new AudioFormat.Encoding("PCM_UNSIGNED");
    public static AudioFormat.Encoding ENC_ULAW = new AudioFormat.Encoding("ULAW");
    public static AudioFormat.Encoding ENC_ALAW = new AudioFormat.Encoding("ALAW");
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(ENC_PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(ENC_PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(ENC_PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(ENC_PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(ENC_PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(ENC_PCM_SIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(ENC_PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(ENC_PCM_UNSIGNED, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(ENC_PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, false), new AudioFormat(ENC_PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, false), new AudioFormat(ENC_PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, true), new AudioFormat(ENC_PCM_SIGNED, -1.0f, 16, -1, -1, -1.0f, true), new AudioFormat(ENC_ALAW, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(ENC_ALAW, -1.0f, 8, -1, -1, -1.0f, true), new AudioFormat(ENC_ULAW, -1.0f, 8, -1, -1, -1.0f, false), new AudioFormat(ENC_ULAW, -1.0f, 8, -1, -1, -1.0f, true)};
    private static final int UNSIGNED8 = 1;
    private static final int SIGNED8 = 2;
    private static final int BIG_ENDIAN16 = 3;
    private static final int LITTLE_ENDIAN16 = 4;
    private static final int ALAW = 5;

    public UlawFormatConversionProvider() {
        super(Arrays.asList(OUTPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS));
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        AudioFormat sourceFormat = sourceStream.getFormat();
        if (AudioFormats.matches((AudioFormat)sourceFormat, (AudioFormat)targetFormat)) {
            return sourceStream;
        }
        if (UlawFormatConversionProvider.doMatch((float)targetFormat.getFrameRate(), (float)sourceFormat.getFrameRate()) && UlawFormatConversionProvider.doMatch((int)targetFormat.getChannels(), (int)sourceFormat.getChannels())) {
            if (UlawFormatConversionProvider.doMatch((int)targetFormat.getSampleSizeInBits(), (int)8) && targetFormat.getEncoding().equals(ENC_ULAW)) {
                return new ToUlawStream(sourceStream);
            }
            if (UlawFormatConversionProvider.doMatch((int)sourceFormat.getSampleSizeInBits(), (int)8) && sourceFormat.getEncoding().equals(ENC_ULAW)) {
                return new FromUlawStream(sourceStream, targetFormat);
            }
        }
        throw new IllegalArgumentException("format conversion not supported");
    }

    private boolean isSupportedFormat(AudioFormat format) {
        return this.getConvertType(format) != 0;
    }

    private int getConvertType(AudioFormat af) {
        int result = 0;
        AudioFormat.Encoding encoding = af.getEncoding();
        boolean bigEndian = af.isBigEndian();
        int ssib = af.getSampleSizeInBits();
        if (encoding.equals(ENC_PCM_SIGNED)) {
            if (ssib == 16) {
                result = bigEndian ? 3 : 4;
            } else if (ssib == 8) {
                result = 2;
            }
        } else if (encoding.equals(ENC_PCM_UNSIGNED)) {
            if (ssib == 8) {
                result = 1;
            }
        } else if (encoding.equals(ENC_ALAW)) {
            result = 5;
        }
        return result;
    }

    class FromUlawStream
    extends TSynchronousFilteredAudioInputStream {
        private int convertType;

        public FromUlawStream(AudioInputStream sourceStream, AudioFormat targetFormat) {
            super(sourceStream, new AudioFormat(targetFormat.getEncoding(), sourceStream.getFormat().getSampleRate(), targetFormat.getSampleSizeInBits(), sourceStream.getFormat().getChannels(), targetFormat.getSampleSizeInBits() * sourceStream.getFormat().getChannels() / 8, sourceStream.getFormat().getFrameRate(), targetFormat.isBigEndian()));
            this.convertType = UlawFormatConversionProvider.this.getConvertType(this.getFormat());
            if (targetFormat.getSampleSizeInBits() == 8) {
                this.enableConvertInPlace();
            }
            if (this.convertType == 0) {
                throw new IllegalArgumentException("format conversion not supported");
            }
        }

        protected int convert(byte[] inBuffer, byte[] outBuffer, int outByteOffset, int inFrameCount) {
            int sampleCount = inFrameCount * this.getFormat().getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.ulaw2pcm8((byte[])inBuffer, (int)0, (byte[])outBuffer, (int)outByteOffset, (int)sampleCount, (boolean)false);
                    break;
                }
                case 2: {
                    TConversionTool.ulaw2pcm8((byte[])inBuffer, (int)0, (byte[])outBuffer, (int)outByteOffset, (int)sampleCount, (boolean)true);
                    break;
                }
                case 3: {
                    TConversionTool.ulaw2pcm16((byte[])inBuffer, (int)0, (byte[])outBuffer, (int)outByteOffset, (int)sampleCount, (boolean)true);
                    break;
                }
                case 4: {
                    TConversionTool.ulaw2pcm16((byte[])inBuffer, (int)0, (byte[])outBuffer, (int)outByteOffset, (int)sampleCount, (boolean)false);
                    break;
                }
                case 5: {
                    TConversionTool.ulaw2alaw((byte[])inBuffer, (int)0, (byte[])outBuffer, (int)outByteOffset, (int)sampleCount);
                }
            }
            return inFrameCount;
        }

        protected void convertInPlace(byte[] buffer, int byteOffset, int frameCount) {
            int sampleCount = frameCount * this.format.getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.ulaw2pcm8((byte[])buffer, (int)byteOffset, (int)sampleCount, (boolean)false);
                    break;
                }
                case 2: {
                    TConversionTool.ulaw2pcm8((byte[])buffer, (int)byteOffset, (int)sampleCount, (boolean)true);
                    break;
                }
                case 5: {
                    TConversionTool.ulaw2alaw((byte[])buffer, (int)byteOffset, (int)sampleCount);
                    break;
                }
                default: {
                    throw new RuntimeException("FromUlawStream: Call to convertInPlace, but it cannot convert in place.");
                }
            }
        }
    }

    class ToUlawStream
    extends TSynchronousFilteredAudioInputStream {
        private int convertType;

        public ToUlawStream(AudioInputStream sourceStream) {
            super(sourceStream, new AudioFormat(ENC_ULAW, sourceStream.getFormat().getSampleRate(), 8, sourceStream.getFormat().getChannels(), sourceStream.getFormat().getChannels(), sourceStream.getFormat().getFrameRate(), sourceStream.getFormat().isBigEndian()));
            this.convertType = UlawFormatConversionProvider.this.getConvertType(sourceStream.getFormat());
            if (sourceStream.getFormat().getSampleSizeInBits() == 8) {
                this.enableConvertInPlace();
            }
            if (this.convertType == 0) {
                throw new IllegalArgumentException("format conversion not supported");
            }
        }

        protected int convert(byte[] inBuffer, byte[] outBuffer, int outByteOffset, int inFrameCount) {
            int sampleCount = inFrameCount * this.getFormat().getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.pcm82ulaw((byte[])inBuffer, (int)0, (byte[])outBuffer, (int)outByteOffset, (int)sampleCount, (boolean)false);
                    break;
                }
                case 2: {
                    TConversionTool.pcm82ulaw((byte[])inBuffer, (int)0, (byte[])outBuffer, (int)outByteOffset, (int)sampleCount, (boolean)true);
                    break;
                }
                case 3: {
                    TConversionTool.pcm162ulaw((byte[])inBuffer, (int)0, (byte[])outBuffer, (int)outByteOffset, (int)sampleCount, (boolean)true);
                    break;
                }
                case 4: {
                    TConversionTool.pcm162ulaw((byte[])inBuffer, (int)0, (byte[])outBuffer, (int)outByteOffset, (int)sampleCount, (boolean)false);
                    break;
                }
                case 5: {
                    TConversionTool.alaw2ulaw((byte[])inBuffer, (int)0, (byte[])outBuffer, (int)outByteOffset, (int)sampleCount);
                }
            }
            return inFrameCount;
        }

        protected void convertInPlace(byte[] buffer, int byteOffset, int frameCount) {
            int sampleCount = frameCount * this.getFormat().getChannels();
            switch (this.convertType) {
                case 1: {
                    TConversionTool.pcm82ulaw((byte[])buffer, (int)byteOffset, (int)sampleCount, (boolean)false);
                    break;
                }
                case 2: {
                    TConversionTool.pcm82ulaw((byte[])buffer, (int)byteOffset, (int)sampleCount, (boolean)true);
                    break;
                }
                case 5: {
                    TConversionTool.alaw2ulaw((byte[])buffer, (int)byteOffset, (int)sampleCount);
                    break;
                }
                default: {
                    throw new RuntimeException("ToUlawStream: Call to convertInPlace, but it cannot convert in place.");
                }
            }
        }
    }
}

