/*
 * Copyright (c) 2009 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import java.util.List;

import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.LayerNature;
import ch.kuramo.javie.core.MediaLayer;
import ch.kuramo.javie.core.TransformableLayer;
import ch.kuramo.javie.core.Util;

public class TransformElement extends Element {

	private final List<LayerAnimatableValueElement> children = Util.newList();

	private boolean threeD;


	public TransformElement(LayerElement parent) {
		super(parent);
	}

	private TransformableLayer getLayer() {
		return ((TransformableLayer) ((LayerElement) parent).layer);
	}

	public String getColumnText(int columnIndex) {
		switch (columnIndex) {
			case LayerCompositionView.NAME_COL:
				return "トランスフォーム";

			default:
				return null;
		}
	}

	@Override
	public boolean hasChildren() {
		return true;
	}

	@Override
	public Element[] getChildren() {
		TransformableLayer layer = getLayer();
		boolean currentThreeD = LayerNature.isThreeD(layer);

		if (threeD == currentThreeD && children.size() > 0) {
			return children.toArray(new Element[children.size()]);
		}

		children.clear();
		threeD = currentThreeD;

		if (currentThreeD) {
			createChildElement("anchorPoint", "アンカーポイント");
			createChildElement("position", "位置");
			createScaleElement();
			createChildElement("orientation", "方向", "°");
			createChildElement("rotationX", "X 回転", "°");
			createChildElement("rotationY", "Y 回転", "°");
			createChildElement("rotationZ", "Z 回転", "°");

			if (layer instanceof MediaLayer) {
				createChildElement("depthBase", "深度基準点");
				createIntersectionGroupElement();
				createChildElement("opacity", "不透明度", "%");
			}
		} else {
			createTiny2DManipulatorElement("anchorPoint", "アンカーポイント");
			createTiny2DManipulatorElement("position", "位置");
			createScaleElement();
			createChildElement("rotationZ", "回転", "°");

			if (layer instanceof MediaLayer) {
				createChildElement("opacity", "不透明度", "%");
			}
		}

		return children.toArray(new Element[children.size()]);
	}

	private void createChildElement(String property, String name) {
		children.add(new LayerAnimatableValueElement(this, getLayer(), property, name, null));
	}

	private void createChildElement(String property, String name, String unit) {
		children.add(new LayerAnimatableValueElement(this, getLayer(), property, name, unit));
	}

	private void createTiny2DManipulatorElement(String property, String name) {
		children.add(new LayerTiny2DManipulatorElement(this, getLayer(), property, name));
	}

	private void createScaleElement() {
		children.add(new LayerScaleElement(this, getLayer()));
	}

	private void createIntersectionGroupElement() {
		children.add(new IntersectionGroupElement(this, getLayer()));
	}

}
