/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects;

import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import javax.media.opengl.GL2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Texture1D {
    private static final float[] FLOAT0000 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};

    public static int fromArray(IArray<float[]> array, IVideoEffectContext context) {
        return Texture1D.fromArray((float[])array.getArray(), 0, array.getLength(), 6406, 9729, 33071, context);
    }

    public static int fromArray(float[] array, IVideoEffectContext context) {
        return Texture1D.fromArray(array, 0, array.length, 6406, 9729, 33071, context);
    }

    public static int fromArray(IArray<float[]> array, int format, int filter, int wrapMode, IVideoEffectContext context) {
        return Texture1D.fromArray((float[])array.getArray(), 0, array.getLength(), format, filter, wrapMode, context);
    }

    public static int fromArray(float[] array, int offset, int length, int format, int filter, int wrapMode, IVideoEffectContext context) {
        int width;
        int internalFormat;
        switch (format) {
            case 6406: {
                switch (context.getColorMode()) {
                    case RGBA8: {
                        internalFormat = 32828;
                        break;
                    }
                    case RGBA16: {
                        internalFormat = 32830;
                        break;
                    }
                    case RGBA16_FLOAT: {
                        internalFormat = 34844;
                        break;
                    }
                    case RGBA32_FLOAT: {
                        internalFormat = 34838;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown ColorMode: " + context.getColorMode());
                    }
                }
                width = length;
                break;
            }
            case 6408: {
                switch (context.getColorMode()) {
                    case RGBA8: {
                        internalFormat = 32856;
                        break;
                    }
                    case RGBA16: {
                        internalFormat = 32859;
                        break;
                    }
                    case RGBA16_FLOAT: {
                        internalFormat = 34842;
                        break;
                    }
                    case RGBA32_FLOAT: {
                        internalFormat = 34836;
                        break;
                    }
                    default: {
                        throw new IllegalStateException("unknown ColorMode: " + context.getColorMode());
                    }
                }
                width = length / 4;
                if (width * 4 == length) break;
                throw new IllegalArgumentException("length must be multiple of 4");
            }
            default: {
                throw new IllegalArgumentException("format must be GL_FLOAT or GL_RGBA");
            }
        }
        GL2 gl = context.getGL().getGL2();
        int[] texture = new int[1];
        int[] current = new int[1];
        gl.glGetIntegerv(32872, current, 0);
        try {
            gl.glGenTextures(1, texture, 0);
            gl.glBindTexture(3552, texture[0]);
            gl.glTexParameteri(3552, 10241, filter);
            gl.glTexParameteri(3552, 10240, filter);
            gl.glTexParameteri(3552, 10242, wrapMode);
            gl.glTexParameteri(3552, 10243, 33071);
            if (wrapMode == 33069) {
                gl.glTexParameterfv(3552, 4100, FLOAT0000, 0);
            }
            gl.glTexImage1D(3552, 0, internalFormat, width, 0, format, 5126, (Buffer)FloatBuffer.wrap(array, offset, length));
            int result = texture[0];
            texture[0] = 0;
            int n = result;
            return n;
        }
        finally {
            gl.glBindTexture(3552, current[0]);
            if (texture[0] != 0) {
                gl.glDeleteTextures(1, texture, 0);
            }
        }
    }

    private Texture1D() {
    }
}

