/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.colorCorrection;

import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.BrightnessAndContrast", category="ch.kuramo.javie.api.effectCategory.colorCorrection")
public class BrightnessAndContrast {
    @ShaderSource
    public static final String[] BRIGHTNESS_AND_CONTRAST = new String[]{"uniform sampler2D texture;", "uniform float brightness;", "uniform float contrastSlope;", "", "void main(void)", "{", "\tvec4 color = texture2D(texture, gl_TexCoord[0].st);", "\tif (color.a != 0.0) {", "\t\tvec3 rgb = color.rgb/color.a;", "\t\trgb = (rgb+brightness-0.5)*contrastSlope+0.5;", "\t\tgl_FragColor = vec4(rgb*color.a, color.a);", "\t} else {", "\t\tgl_FragColor = vec4(0.0);", "\t}", "}"};
    @Property(min="-255", max="255")
    private IAnimatableDouble brightness;
    @Property(min="-100", max="100")
    private IAnimatableDouble contrast;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram program;

    @Inject
    public BrightnessAndContrast(IVideoEffectContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.program = shaders.getProgram(BrightnessAndContrast.class, "BRIGHTNESS_AND_CONTRAST");
    }

    public IVideoBuffer doVideoEffect() {
        IVideoBuffer input = this.context.doPreviousEffect();
        VideoBounds bounds = input.getBounds();
        if (bounds.isEmpty()) {
            return input;
        }
        double brightness = (Double)this.context.value((IAnimatableValue)this.brightness);
        double contrast = (Double)this.context.value((IAnimatableValue)this.contrast);
        if (brightness == 0.0 && contrast == 0.0) {
            return input;
        }
        contrast = Math.min(contrast, 99.9999999999);
        try {
            HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
            uniforms.add(new GLUniformData("texture", 0));
            uniforms.add(new GLUniformData("brightness", (float)(brightness / 255.0)));
            uniforms.add(new GLUniformData("contrastSlope", (float)(contrast >= 0.0 ? 100.0 / (100.0 - contrast) : (100.0 + contrast) / 100.0)));
            IVideoBuffer iVideoBuffer = this.support.useShaderProgram(this.program, uniforms, null, new IVideoBuffer[]{input});
            return iVideoBuffer;
        }
        finally {
            input.dispose();
        }
    }
}

