/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.generate;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.IAnimatableBoolean;
import ch.kuramo.javie.api.IAnimatableColor;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableInteger;
import ch.kuramo.javie.api.IAnimatableLayerReference;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.effects.generate.AudioDrawing;
import com.google.inject.Inject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Effect(id="ch.kuramo.javie.AudioWaveform", category="ch.kuramo.javie.api.effectCategory.generate")
public class AudioWaveform
extends AudioDrawing {
    @Property
    private IAnimatableLayerReference audioLayer;
    @Property
    private IAnimatableVec2d startPoint;
    @Property
    private IAnimatableVec2d endPoint;
    @Property(value="120", min="1", max="96000")
    private IAnimatableInteger displayedSamples;
    @Property(value="120", min="1")
    private IAnimatableDouble height;
    @Property(value="125", min="0", max="30000")
    private IAnimatableDouble audioDuration;
    @Property(value="0", min="-30000", max="30000")
    private IAnimatableDouble audioOffset;
    @Property(value="3", min="0", max="100")
    private IAnimatableDouble thickness;
    @Property(value="0,1,0")
    private IAnimatableColor color;
    @Property(value="MONO")
    private IAnimatableEnum<AudioDrawing.Channel> channel;
    @Property(value="LINES")
    private IAnimatableEnum<AudioDrawing.Style> style;
    @Property(value="true")
    private IAnimatableBoolean smoothing;
    @Property(value="100", min="0", max="100")
    private IAnimatableDouble opacity;
    @Property
    private IAnimatableEnum<BlendMode> blendMode;
    private final IArrayPools arrayPools;

    @Inject
    public AudioWaveform(IVideoEffectContext context, IVideoRenderSupport support, IBlendSupport blendSupport, IArrayPools arrayPools) {
        super(context, support, blendSupport);
        this.arrayPools = arrayPools;
    }

    public IVideoBuffer doVideoEffect() {
        AudioDrawing.DataProvider dp = new AudioDrawing.DataProvider(){
            private int displayedSamples;
            private IArray<float[]> samples;
            private float[] sampleArray;
            private int evenOdd;

            public void init() {
                this.displayedSamples = (Integer)AudioWaveform.this.context.value((IAnimatableValue)AudioWaveform.this.displayedSamples);
                this.samples = AudioWaveform.this.arrayPools.getFloatArray(this.displayedSamples * 2);
                this.sampleArray = (float[])this.samples.getArray();
                double duration = (Double)AudioWaveform.this.context.value((IAnimatableValue)AudioWaveform.this.audioDuration) / 1000.0;
                double offset = (Double)AudioWaveform.this.context.value((IAnimatableValue)AudioWaveform.this.audioOffset) / 1000.0;
                AudioMode audioMode = AudioWaveform.this.context.getAudioMode();
                int audioFrameCount = (int)(duration * (double)audioMode.sampleRate);
                double sampleInterval = (double)audioFrameCount / (double)this.displayedSamples;
                Time startOffset = new Time((long)((offset - duration / 2.0) * (double)audioMode.sampleRate), audioMode.sampleRate);
                Time startTime = startOffset.add(AudioWaveform.this.context.getTime());
                int startIndex = (int)Math.floor((double)startTime.timeValue / sampleInterval);
                startTime = new Time(Math.round((double)startIndex * sampleInterval), startTime.timeScale);
                AudioWaveform.this.context.setTime(startTime);
                AudioWaveform.this.context.setAudioFrameCount(audioFrameCount);
                IAudioBuffer audio = null;
                try {
                    audio = AudioWaveform.this.context.getLayerAudioChunk(AudioWaveform.this.audioLayer);
                    if (audio == null) {
                        this.samples.clear();
                    } else {
                        AudioDrawing.Channel ch = (AudioDrawing.Channel)((Object)AudioWaveform.this.context.value((IAnimatableValue)AudioWaveform.this.channel));
                        AudioWaveform.this.sample(audio, (IArray<float[]>)this.samples, ch);
                    }
                }
                finally {
                    if (audio != null) {
                        audio.dispose();
                    }
                }
                this.evenOdd = Math.abs(startIndex) % 2;
            }

            public void dispose() {
                if (this.samples != null) {
                    this.samples.release();
                    this.samples = null;
                }
            }

            public int getDataCount() {
                return this.displayedSamples;
            }

            public float getDataUpper(int index) {
                return this.sampleArray[index * 2];
            }

            public float getDataLower(int index) {
                return this.sampleArray[index * 2 + 1];
            }

            public float getData(int index) {
                return this.sampleArray[index * 2 + (this.evenOdd + index) % 2];
            }
        };
        return this.draw(dp, this.startPoint, this.endPoint, this.height, this.thickness, this.color, this.style, this.smoothing, this.blendMode, this.opacity);
    }

    private void sample(IAudioBuffer audio, IArray<float[]> samples, AudioDrawing.Channel channel) {
        Object audioData = audio.getData();
        int audioFrames = audio.getFrameCount();
        float[] sampleArray = (float[])samples.getArray();
        int numSamples = samples.getLength() / 2;
        switch (audio.getAudioMode().dataType) {
            case SHORT: {
                short[] audioArray = (short[])audioData;
                float left = channel == AudioDrawing.Channel.RIGHT ? 0.0f : 3.051851E-5f;
                float right = channel == AudioDrawing.Channel.LEFT ? 0.0f : 3.051851E-5f;
                int i = 0;
                while (i < numSamples) {
                    int p = i * 2;
                    int q = p + 1;
                    sampleArray[p] = Float.POSITIVE_INFINITY;
                    sampleArray[q] = Float.NEGATIVE_INFINITY;
                    int j = i * audioFrames / numSamples * 2;
                    int k = (i + 1) * audioFrames / numSamples * 2;
                    while (j < k) {
                        float sample = left * (float)audioArray[j] + right * (float)audioArray[j + 1];
                        sampleArray[p] = Math.min(sampleArray[p], sample);
                        sampleArray[q] = Math.max(sampleArray[q], sample);
                        j += 2;
                    }
                    ++i;
                }
                break;
            }
            case INT: {
                int[] audioArray = (int[])audioData;
                float left = channel == AudioDrawing.Channel.RIGHT ? 0.0f : 4.656613E-10f;
                float right = channel == AudioDrawing.Channel.LEFT ? 0.0f : 4.656613E-10f;
                int i = 0;
                while (i < numSamples) {
                    int p = i * 2;
                    int q = p + 1;
                    sampleArray[p] = Float.POSITIVE_INFINITY;
                    sampleArray[q] = Float.NEGATIVE_INFINITY;
                    int j = i * audioFrames / numSamples * 2;
                    int k = (i + 1) * audioFrames / numSamples * 2;
                    while (j < k) {
                        float sample = left * (float)audioArray[j] + right * (float)audioArray[j + 1];
                        sampleArray[p] = Math.min(sampleArray[p], sample);
                        sampleArray[q] = Math.max(sampleArray[q], sample);
                        j += 2;
                    }
                    ++i;
                }
                break;
            }
            case FLOAT: {
                float[] audioArray = (float[])audioData;
                float left = channel != AudioDrawing.Channel.RIGHT ? 1 : 0;
                float right = channel != AudioDrawing.Channel.LEFT ? 1 : 0;
                int i = 0;
                while (i < numSamples) {
                    int p = i * 2;
                    int q = p + 1;
                    sampleArray[p] = Float.POSITIVE_INFINITY;
                    sampleArray[q] = Float.NEGATIVE_INFINITY;
                    int j = i * audioFrames / numSamples * 2;
                    int k = (i + 1) * audioFrames / numSamples * 2;
                    while (j < k) {
                        float sample = left * audioArray[j] + right * audioArray[j + 1];
                        sampleArray[p] = Math.min(sampleArray[p], sample);
                        sampleArray[q] = Math.max(sampleArray[q], sample);
                        j += 2;
                    }
                    ++i;
                }
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported AudioMode.DataType: " + audio.getAudioMode().dataType);
            }
        }
    }
}

