/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.effects.transition;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.IAnimatableDouble;
import ch.kuramo.javie.api.IAnimatableEnum;
import ch.kuramo.javie.api.IAnimatableValue;
import ch.kuramo.javie.api.IAnimatableVec2d;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Vec2d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.annotations.Effect;
import ch.kuramo.javie.api.annotations.Property;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IBlendSupport;
import ch.kuramo.javie.api.services.IBlurSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoEffectContext;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import com.google.inject.Inject;
import java.nio.FloatBuffer;
import java.util.HashSet;
import javax.media.opengl.GLUniformData;

@Effect(id="ch.kuramo.javie.RadialWipe", category="ch.kuramo.javie.api.effectCategory.transition")
public class RadialWipe {
    @Property(min="0", max="100")
    private IAnimatableDouble transitionCompletion;
    @Property(value="0")
    private IAnimatableDouble startAngle;
    @Property
    private IAnimatableVec2d wipeCenter;
    @Property
    private IAnimatableEnum<TypeOfRadialWipe> typeOfWipe;
    @Property(min="0", max="500")
    private IAnimatableDouble feather;
    private final IVideoEffectContext context;
    private final IVideoRenderSupport support;
    private final IBlurSupport blurSupport;
    private final IBlendSupport blendSupport;
    private final IShaderProgram stencilProgram1;
    private final IShaderProgram stencilProgram2;
    @ShaderSource
    public static final String[] STENCIL_1 = new String[]{"uniform vec3 line1;", "uniform vec3 line2;", "uniform vec3 line3;", "", "void main(void)", "{", "\tvec3 pt = vec3(gl_FragCoord.xy, 1.0);", "\tif (dot(line3, pt) > 0.5) {", "\t\tgl_FragColor = vec4(1.0);", "\t} else {", "\t\tfloat d1 = clamp(dot(line1, pt) + 0.5, 0.0, 1.0);", "\t\tfloat d2 = clamp(dot(line2, pt) + 0.5, 0.0, 1.0);", "\t\tgl_FragColor = vec4(max(d1, d2));", "\t}", "}"};
    @ShaderSource
    public static final String[] STENCIL_2 = new String[]{"uniform vec3 line1;", "uniform vec3 line2;", "uniform vec3 line3;", "", "void main(void)", "{", "\tvec3 pt = vec3(gl_FragCoord.xy, 1.0);", "\tif (dot(line3, pt) < -0.5) {", "\t\tgl_FragColor = vec4(0.0);", "\t} else {", "\t\tfloat d1 = clamp(dot(line1, pt) + 0.5, 0.0, 1.0);", "\t\tfloat d2 = clamp(dot(line2, pt) + 0.5, 0.0, 1.0);", "\t\tgl_FragColor = vec4(min(d1, d2));", "\t}", "}"};

    @Inject
    public RadialWipe(IVideoEffectContext context, IVideoRenderSupport support, IBlurSupport blurSupport, IBlendSupport blendSupport, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.blurSupport = blurSupport;
        this.blendSupport = blendSupport;
        this.stencilProgram1 = shaders.getProgram(RadialWipe.class, "STENCIL_1");
        this.stencilProgram2 = shaders.getProgram(RadialWipe.class, "STENCIL_2");
    }

    public IVideoBuffer doVideoEffect() {
        double completion = (Double)this.context.value((IAnimatableValue)this.transitionCompletion) / 100.0;
        if (completion == 1.0) {
            IVideoBuffer buffer = this.context.createVideoBuffer(this.context.getPreviousBounds());
            buffer.clear();
            return buffer;
        }
        IVideoBuffer inputBuffer = this.context.doPreviousEffect();
        if (completion == 0.0) {
            return inputBuffer;
        }
        VideoBounds inputBounds = inputBuffer.getBounds();
        if (inputBounds.isEmpty()) {
            return inputBuffer;
        }
        double startAngle = (Double)this.context.value((IAnimatableValue)this.startAngle);
        Vec2d wipeCenter = (Vec2d)this.context.value((IAnimatableValue)this.wipeCenter);
        TypeOfRadialWipe typeOfWipe = (TypeOfRadialWipe)((Object)this.context.value(this.typeOfWipe));
        double feather = (Double)this.context.value((IAnimatableValue)this.feather);
        Resolution resolution = this.context.getVideoResolution();
        wipeCenter = resolution.scale(wipeCenter);
        feather = resolution.scale(feather);
        switch (typeOfWipe) {
            case COUNTERCLOCKWISE: {
                startAngle -= 360.0 * completion;
                break;
            }
            case BOTH: {
                startAngle -= 180.0 * completion;
            }
        }
        startAngle %= 360.0;
        if (startAngle < 0.0) {
            startAngle += 360.0;
        }
        double endAngle = startAngle + 360.0 * completion;
        IVideoBuffer stencilBuffer = null;
        try {
            stencilBuffer = this.createStencilBuffer(inputBounds, wipeCenter, feather, startAngle, endAngle);
            IVideoBuffer iVideoBuffer = this.blendSupport.blend(stencilBuffer, inputBuffer, null, BlendMode.STENCIL_ALPHA, 1.0);
            return iVideoBuffer;
        }
        finally {
            if (stencilBuffer != null) {
                stencilBuffer.dispose();
            }
            if (inputBuffer != null) {
                inputBuffer.dispose();
            }
        }
    }

    private IVideoBuffer createStencilBuffer(VideoBounds inputBounds, Vec2d wipeCenter, double feather, double startAngle, double endAngle) {
        int stencilExpand = (int)Math.ceil(feather);
        VideoBounds stencilBounds = new VideoBounds(inputBounds.x - (double)stencilExpand, inputBounds.y - (double)stencilExpand, inputBounds.width + stencilExpand * 2, inputBounds.height + stencilExpand * 2);
        wipeCenter = new Vec2d(wipeCenter.x - stencilBounds.x, wipeCenter.y - stencilBounds.y);
        double angleDiff = endAngle - startAngle;
        double halflineAngle = (startAngle + angleDiff * 0.5 + 90.0) % 360.0;
        double a1 = startAngle > 90.0 && startAngle <= 270.0 ? 1 : -1;
        double a2 = (endAngle %= 360.0) > 90.0 && endAngle <= 270.0 ? -1 : 1;
        double a3 = halflineAngle > 90.0 && halflineAngle <= 270.0 ? -1 : 1;
        double t1 = Math.tan(Math.toRadians(startAngle));
        double t2 = Math.tan(Math.toRadians(endAngle));
        double t3 = Math.tan(Math.toRadians(halflineAngle));
        a1 /= Math.sqrt(a1 * a1 * (1.0 + t1 * t1));
        a2 /= Math.sqrt(a2 * a2 * (1.0 + t2 * t2));
        a3 /= Math.sqrt(a3 * a3 * (1.0 + t3 * t3));
        float[] line1 = new float[]{(float)a1, (float)(a1 * t1), (float)(a1 * (-wipeCenter.x - wipeCenter.y * t1))};
        float[] line2 = new float[]{(float)a2, (float)(a2 * t2), (float)(a2 * (-wipeCenter.x - wipeCenter.y * t2))};
        float[] line3 = new float[]{(float)a3, (float)(a3 * t3), (float)(a3 * (-wipeCenter.x - wipeCenter.y * t3))};
        HashSet<GLUniformData> uniforms = new HashSet<GLUniformData>();
        uniforms.add(new GLUniformData("line1", 3, FloatBuffer.wrap(line1)));
        uniforms.add(new GLUniformData("line2", 3, FloatBuffer.wrap(line2)));
        uniforms.add(new GLUniformData("line3", 3, FloatBuffer.wrap(line3)));
        IVideoBuffer buffer = this.context.createVideoBuffer(stencilBounds);
        try {
            IShaderProgram program = angleDiff <= 180.0 ? this.stencilProgram1 : this.stencilProgram2;
            this.support.useShaderProgram(program, uniforms, buffer, new IVideoBuffer[0]);
            if (feather == 0.0) {
                IVideoBuffer result = buffer;
                buffer = null;
                IVideoBuffer iVideoBuffer = result;
                return iVideoBuffer;
            }
            IVideoBuffer iVideoBuffer = this.blurSupport.gaussianBlur(buffer, feather, IBlurSupport.BlurDimensions.BOTH, true, true);
            return iVideoBuffer;
        }
        finally {
            if (buffer != null) {
                buffer.dispose();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TypeOfRadialWipe {
        CLOCKWISE,
        COUNTERCLOCKWISE,
        BOTH;

    }
}

