/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Resolution;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.AbstractAnimatableEnum;
import ch.kuramo.javie.core.AnimatableColor;
import ch.kuramo.javie.core.AnimatableDouble;
import ch.kuramo.javie.core.AnimatableInteger;
import ch.kuramo.javie.core.AnimatableString;
import ch.kuramo.javie.core.CoreContext;
import ch.kuramo.javie.core.ExpressionScope;
import ch.kuramo.javie.core.Keyframe;
import ch.kuramo.javie.core.MediaInput;
import ch.kuramo.javie.core.TextLayer;
import ch.kuramo.javie.core.VectorMediaInput;
import ch.kuramo.javie.core.annotations.ProjectElement;
import ch.kuramo.javie.core.internal.AbstractMediaLayer;
import ch.kuramo.javie.core.services.Font;
import ch.kuramo.javie.core.services.FontList;
import ch.kuramo.javie.core.services.FontManager;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import ftgl.FTGL;
import ftgl.FTGLfont;
import java.util.Collection;
import java.util.regex.Pattern;
import net.arnx.jsonic.JSONHint;

@ProjectElement(value="textLayer")
public class TextLayerImpl
extends AbstractMediaLayer
implements TextLayer {
    private final TextInput _input = new TextInput();
    private boolean _videoEnabled = true;
    private boolean _ctcr;
    private AnimatableString _sourceText = new AnimatableString("\u30c6\u30ad\u30b9\u30c8");
    private AnimatableString _font = new AnimatableString("");
    private AnimatableInteger _fontSize = new AnimatableInteger((Integer)36, 1, Integer.MAX_VALUE);
    private AnimatableColor _fillColor = new AnimatableColor(Color.WHITE);
    private AnimatableHorizontalAlignment _horizontalAlignment = new AnimatableHorizontalAlignment(TextLayer.HorizontalAlignment.LEFT);
    private AnimatableDouble _leading = new AnimatableDouble(-1.0);
    @Inject
    private RenderContext _context;
    @Inject
    private IVideoRenderSupport _support;
    @Inject
    private VideoRenderSupport _oldSupport;
    @Inject
    private FontList _fontList;
    @Inject
    private FontManager _fontManager;
    private static final Pattern LF = Pattern.compile("\n");

    public boolean isVideoEnabled() {
        return this._videoEnabled;
    }

    public void setVideoEnabled(boolean enabled) {
        this._videoEnabled = enabled;
    }

    @JSONHint(ignore=true)
    public boolean isAudioEnabled() {
        return false;
    }

    @JSONHint(ignore=true)
    public void setAudioEnabled(boolean enabled) {
        throw new UnsupportedOperationException();
    }

    @JSONHint(ignore=true)
    public MediaInput getMediaInput() {
        return this._input;
    }

    public boolean isCTCR() {
        return this._ctcr;
    }

    public void setCTCR(boolean ctcr) {
        this._ctcr = ctcr;
    }

    public AnimatableString getSourceText() {
        return this._sourceText;
    }

    public void setSourceText(AnimatableString sourceText) {
        sourceText.copyConfigurationFrom(this._sourceText);
        this._sourceText = sourceText;
    }

    public AnimatableString getFont() {
        return this._font;
    }

    public void setFont(AnimatableString font) {
        font.copyConfigurationFrom(this._font);
        this._font = font;
    }

    public AnimatableInteger getFontSize() {
        return this._fontSize;
    }

    public void setFontSize(AnimatableInteger fontSize) {
        fontSize.copyConfigurationFrom(this._fontSize);
        this._fontSize = fontSize;
    }

    public AnimatableColor getFillColor() {
        return this._fillColor;
    }

    public void setFillColor(AnimatableColor fillColor) {
        fillColor.copyConfigurationFrom(this._fillColor);
        this._fillColor = fillColor;
    }

    public AnimatableHorizontalAlignment getHorizontalAlignment() {
        return this._horizontalAlignment;
    }

    public void setHorizontalAlignment(AnimatableHorizontalAlignment horizontalAlignment) {
        horizontalAlignment.copyConfigurationFrom(this._horizontalAlignment);
        this._horizontalAlignment = horizontalAlignment;
    }

    public AnimatableDouble getLeading() {
        return this._leading;
    }

    public void setLeading(AnimatableDouble leading) {
        leading.copyConfigurationFrom(this._leading);
        this._leading = leading;
    }

    public void prepareExpression(ExpressionScope scope) {
        super.prepareExpression(scope);
        scope.assignTo(this._sourceText);
        scope.assignTo(this._font);
        scope.assignTo(this._fontSize);
        scope.assignTo(this._fillColor);
        scope.assignTo(this._horizontalAlignment);
        scope.assignTo(this._leading);
    }

    public Object createExpressionElement(CoreContext context) {
        return new TextLayerExpressionElement(context);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AnimatableHorizontalAlignment
    extends AbstractAnimatableEnum<TextLayer.HorizontalAlignment> {
        public AnimatableHorizontalAlignment(TextLayer.HorizontalAlignment staticValue, Collection<Keyframe<TextLayer.HorizontalAlignment>> keyframes, String expression) {
            super(TextLayer.HorizontalAlignment.class, staticValue, keyframes, expression);
        }

        public AnimatableHorizontalAlignment(TextLayer.HorizontalAlignment staticValue) {
            super(TextLayer.HorizontalAlignment.class, staticValue);
        }
    }

    private class TextInput
    implements VectorMediaInput {
        private TextInput() {
        }

        public boolean isVideoAvailable() {
            return true;
        }

        public boolean isAudioAvailable() {
            return false;
        }

        public Time getDuration() {
            return null;
        }

        public Time getVideoFrameDuration() {
            return null;
        }

        public VideoBounds getVideoFrameBounds() {
            if (!TextLayerImpl.this._context.isActive()) {
                return null;
            }
            if (!TextLayerImpl.this._ctcr) {
                return this.getBounds(false);
            }
            switch (TextLayerImpl.this.getCastsShadows()) {
                case OFF: {
                    return this.getBounds(true);
                }
                case ONLY: {
                    return this.getBounds(false);
                }
            }
            VideoBounds b1 = this.getBounds(true);
            VideoBounds b2 = this.getBounds(false);
            double left = Math.min(b1.x, b2.x);
            double top = Math.min(b1.y, b2.y);
            double right = Math.max(b1.x + (double)b1.width, b2.x + (double)b2.width);
            double bottom = Math.max(b1.y + (double)b1.height, b2.y + (double)b2.height);
            return new VideoBounds(left, top, (int)Math.ceil(right - left), (int)Math.ceil(bottom - top));
        }

        private VideoBounds getBounds(boolean polygonFont) {
            int width;
            double x;
            String sourceText = (String)TextLayerImpl.this._sourceText.value(TextLayerImpl.this._context);
            String psName = (String)TextLayerImpl.this._font.value(TextLayerImpl.this._context);
            int fontSize = (Integer)TextLayerImpl.this._fontSize.value(TextLayerImpl.this._context);
            FTGLfont font = this.getFont(psName, fontSize, polygonFont);
            if (sourceText.length() == 0 || font == null) {
                return new VideoBounds(0, 0);
            }
            TextLayer.HorizontalAlignment halign = (TextLayer.HorizontalAlignment)((Object)TextLayerImpl.this._horizontalAlignment.value(TextLayerImpl.this._context));
            double leading = (Double)TextLayerImpl.this._leading.value(TextLayerImpl.this._context);
            if (leading < 0.0) {
                leading = (double)fontSize * 1.2;
            }
            double upper = 0.0;
            double lower = Double.MAX_VALUE;
            double advanced = 0.0;
            String[] texts = LF.split(sourceText);
            float[] box = new float[6];
            int i = 0;
            while (i < texts.length) {
                FTGL.ftglGetFontBBox((FTGLfont)font, (String)texts[i], (int)-1, (float[])box);
                upper = Math.max(upper, (double)box[4]);
                lower = Math.min(lower, (double)box[1]);
                advanced = Math.max(advanced, (double)FTGL.ftglGetFontAdvance((FTGLfont)font, (String)texts[i]));
                ++i;
            }
            upper = Math.ceil(upper) + 1.0;
            lower = Math.floor(lower) - 1.0;
            switch (halign) {
                default: {
                    x = 0.0;
                    width = (int)Math.ceil(advanced);
                    break;
                }
                case CENTER: {
                    x = -Math.ceil(advanced / 2.0);
                    width = (int)(-x) * 2;
                    break;
                }
                case RIGHT: {
                    x = -Math.ceil(advanced);
                    width = (int)(-x) + 1;
                }
            }
            return new VideoBounds(x, -upper, width, (int)(upper + Math.ceil(leading * (double)(texts.length - 1)) - lower));
        }

        public IVideoBuffer getVideoFrame(Time mediaTime) {
            Resolution resolution = TextLayerImpl.this._context.getVideoResolution();
            VideoBounds bounds = resolution.scale(this.getVideoFrameBounds());
            IVideoBuffer vb = TextLayerImpl.this._support.createVideoBuffer(bounds);
            vb.clear();
            String psName = (String)TextLayerImpl.this._font.value(TextLayerImpl.this._context);
            int fontSize = (Integer)TextLayerImpl.this._fontSize.value(TextLayerImpl.this._context);
            FTGLfont font = this.getFont(psName, fontSize, false);
            if (font != null) {
                String sourceText = (String)TextLayerImpl.this._sourceText.value(TextLayerImpl.this._context);
                Color fillColor = (Color)TextLayerImpl.this._fillColor.value(TextLayerImpl.this._context);
                TextLayer.HorizontalAlignment halign = (TextLayer.HorizontalAlignment)((Object)TextLayerImpl.this._horizontalAlignment.value(TextLayerImpl.this._context));
                double leading = (Double)TextLayerImpl.this._leading.value(TextLayerImpl.this._context);
                String[] texts = LF.split(sourceText);
                if (leading < 0.0) {
                    leading = (double)fontSize * 1.2;
                }
                leading = resolution.scale(leading);
                double[][] offsets = this.calcTextOffsets(font, texts, halign, leading, resolution);
                TextLayerImpl.this._oldSupport.renderText(font, fillColor, texts, offsets, vb);
            }
            return vb;
        }

        public void rasterize(IVideoBuffer resultBuffer, double[] mvMatrix, double[] prjMatrix, Time mediaTime) {
            int fontSize;
            Resolution resolution = TextLayerImpl.this._context.getVideoResolution();
            String psName = (String)TextLayerImpl.this._font.value(TextLayerImpl.this._context);
            FTGLfont font = this.getFont(psName, fontSize = ((Integer)TextLayerImpl.this._fontSize.value(TextLayerImpl.this._context)).intValue(), true);
            if (font != null) {
                String sourceText = (String)TextLayerImpl.this._sourceText.value(TextLayerImpl.this._context);
                Color fillColor = (Color)TextLayerImpl.this._fillColor.value(TextLayerImpl.this._context);
                TextLayer.HorizontalAlignment halign = (TextLayer.HorizontalAlignment)((Object)TextLayerImpl.this._horizontalAlignment.value(TextLayerImpl.this._context));
                double leading = (Double)TextLayerImpl.this._leading.value(TextLayerImpl.this._context);
                String[] texts = LF.split(sourceText);
                if (leading < 0.0) {
                    leading = (double)fontSize * 1.2;
                }
                leading = resolution.scale(leading);
                double[][] offsets = this.calcTextOffsets(font, texts, halign, leading, resolution);
                TextLayerImpl.this._oldSupport.renderText(font, fillColor, texts, offsets, resultBuffer, mvMatrix, prjMatrix);
            }
        }

        private FTGLfont getFont(String psName, int fontSize, boolean polygonFont) {
            Font font = TextLayerImpl.this._fontList.get(psName);
            if (font == null && (font = TextLayerImpl.this._fontList.defaultFont()) == null) {
                return null;
            }
            String fontPath = font.fontFile.getAbsolutePath();
            int faceIndex = font.faceIndex;
            if (polygonFont) {
                return TextLayerImpl.this._fontManager.getPolygonFont(fontPath, faceIndex, fontSize);
            }
            return TextLayerImpl.this._fontManager.getBufferFont(fontPath, faceIndex, fontSize);
        }

        private double[][] calcTextOffsets(FTGLfont font, String[] texts, TextLayer.HorizontalAlignment halign, double leading, Resolution resolution) {
            double[][] offsets = new double[texts.length][2];
            switch (halign) {
                default: {
                    int i = 0;
                    while (i < texts.length) {
                        offsets[i] = new double[]{0.0, leading * (double)i};
                        ++i;
                    }
                    break;
                }
                case CENTER: {
                    int i = 0;
                    while (i < texts.length) {
                        double advance = resolution.scale((double)FTGL.ftglGetFontAdvance((FTGLfont)font, (String)texts[i]));
                        offsets[i] = new double[]{-advance / 2.0, leading * (double)i};
                        ++i;
                    }
                    break;
                }
                case RIGHT: {
                    int i = 0;
                    while (i < texts.length) {
                        double advance = resolution.scale((double)FTGL.ftglGetFontAdvance((FTGLfont)font, (String)texts[i]));
                        offsets[i] = new double[]{-advance, leading * (double)i};
                        ++i;
                    }
                    break block0;
                }
            }
            return offsets;
        }

        public IAudioBuffer getAudioChunk(Time mediaTime) {
            throw new UnsupportedOperationException("audio is not available");
        }
    }

    public class TextLayerExpressionElement
    extends AbstractMediaLayer.MediaLayerExpressionElement {
        public TextLayerExpressionElement(CoreContext context) {
            super(context);
        }

        public Object getSourceText() {
            return this.elem(TextLayerImpl.this._sourceText);
        }

        public Object getFont() {
            return this.elem(TextLayerImpl.this._font);
        }

        public Object getFontSize() {
            return this.elem(TextLayerImpl.this._fontSize);
        }

        public Object getFillColor() {
            return this.elem(TextLayerImpl.this._fillColor);
        }

        public Object getHorizontalAlignment() {
            return this.elem(TextLayerImpl.this._horizontalAlignment);
        }

        public Object getLeading() {
            return this.elem(TextLayerImpl.this._leading);
        }
    }
}

