/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.services.GLGlobal;
import ch.kuramo.javie.core.services.RenderContext;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoBufferImpl
implements IVideoBuffer {
    private static final Logger logger = LoggerFactory.getLogger(VideoBufferImpl.class);
    private final ColorMode colorMode;
    private final VideoBounds bounds;
    private int texture;
    private IArray<?> array;
    private final RenderContext context;
    private final IVideoRenderSupport support;
    private final IArrayPools arrayPools;
    private final GLGlobal glGlobal;
    private static final float[] FLOAT0000 = new float[]{0.0f, 0.0f, 0.0f, 0.0f};

    public VideoBufferImpl(ColorMode colorMode, VideoBounds bounds, RenderContext context, IVideoRenderSupport support, IArrayPools arrayPools, GLGlobal glGlobal) {
        this.colorMode = colorMode;
        this.bounds = bounds;
        this.context = context;
        this.support = support;
        this.arrayPools = arrayPools;
        this.glGlobal = glGlobal;
    }

    protected void finalize() throws Throwable {
        if (this.texture != 0 || this.array != null) {
            logger.warn("finalizing a VideoBufferImpl object, but the object is not disposed.");
            if (this.array != null) {
                this.array.release();
                this.array = null;
            }
        }
        super.finalize();
    }

    public void dispose() {
        if (this.texture != 0) {
            this.deleteTexture(this.texture);
            this.texture = 0;
        }
        if (this.array != null) {
            this.array.release();
            this.array = null;
        }
    }

    public boolean isTexture() {
        return this.texture != 0;
    }

    public boolean isArray() {
        return this.array != null;
    }

    public int getTexture() {
        if (this.texture == 0) {
            this.texture = this.createTexture(this.colorMode, this.bounds.width, this.bounds.height);
            if (this.array != null) {
                this.copyArrayToTexture(this.array.getArray(), this.texture, this.colorMode, this.bounds.width, this.bounds.height);
                this.array.release();
                this.array = null;
            }
        } else if (this.array != null) {
            throw new IllegalStateException("both texture and array exist.");
        }
        return this.texture;
    }

    public Object getArray() {
        if (this.array == null) {
            this.array = this.createArray(this.colorMode, this.bounds.width, this.bounds.height);
            if (this.texture != 0) {
                this.copyTextureToArray(this.texture, this.array.getArray(), this.colorMode, this.bounds.width, this.bounds.height);
                this.deleteTexture(this.texture);
                this.texture = 0;
            }
        } else if (this.texture != 0) {
            throw new IllegalStateException("both texture and array exist.");
        }
        return this.array.getArray();
    }

    public ColorMode getColorMode() {
        return this.colorMode;
    }

    public VideoBounds getBounds() {
        return this.bounds;
    }

    public IVideoBuffer.TextureFilter getTextureFilter() {
        int texture = this.getTexture();
        GL2 gl = this.context.getGL().getGL2();
        int[] params = new int[2];
        int[] current = new int[1];
        gl.glGetIntegerv(32873, current, 0);
        try {
            gl.glBindTexture(3553, texture);
            gl.glGetTexParameteriv(3553, 10241, params, 0);
            gl.glGetTexParameteriv(3553, 10240, params, 1);
        }
        finally {
            gl.glBindTexture(3553, current[0]);
        }
        switch (params[0]) {
            case 9728: {
                if (params[1] != 9728) {
                    throw new IllegalStateException();
                }
                return IVideoBuffer.TextureFilter.NEAREST;
            }
            case 9729: {
                if (params[1] != 9729) {
                    throw new IllegalStateException();
                }
                return IVideoBuffer.TextureFilter.LINEAR;
            }
            case 9987: {
                if (params[1] != 9729) {
                    throw new IllegalStateException();
                }
                return IVideoBuffer.TextureFilter.MIPMAP;
            }
        }
        throw new IllegalStateException("unsupported filter: " + params[0]);
    }

    public void setTextureFilter(IVideoBuffer.TextureFilter filter) {
        int texture = this.getTexture();
        GL2 gl = this.context.getGL().getGL2();
        int[] current = new int[1];
        gl.glGetIntegerv(32873, current, 0);
        try {
            gl.glBindTexture(3553, texture);
            switch (filter) {
                case NEAREST: {
                    gl.glTexParameteri(3553, 10241, 9728);
                    gl.glTexParameteri(3553, 10240, 9728);
                    break;
                }
                case LINEAR: {
                    gl.glTexParameteri(3553, 10241, 9729);
                    gl.glTexParameteri(3553, 10240, 9729);
                    break;
                }
                case MIPMAP: {
                    gl.glTexParameteri(3553, 10240, 9729);
                    int[] min = new int[1];
                    gl.glGetTexParameteriv(3553, 10241, min, 0);
                    if (min[0] != 9987) {
                        gl.glTexParameteri(3553, 10241, 9987);
                        gl.glTexParameterf(3553, 34046, 16.0f);
                        gl.glGenerateMipmap(3553);
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("unsupported filter: " + filter.name());
                }
            }
        }
        finally {
            gl.glBindTexture(3553, current[0]);
        }
    }

    public IVideoBuffer.TextureWrapMode getTextureWrapMode() {
        int texture = this.getTexture();
        GL2 gl = this.context.getGL().getGL2();
        int[] params = new int[2];
        int[] current = new int[1];
        gl.glGetIntegerv(32873, current, 0);
        try {
            gl.glBindTexture(3553, texture);
            gl.glGetTexParameteriv(3553, 10242, params, 0);
            gl.glGetTexParameteriv(3553, 10243, params, 1);
        }
        finally {
            gl.glBindTexture(3553, current[0]);
        }
        if (params[0] != params[1]) {
            throw new IllegalStateException("wrap mode of GL_TEXTURE_WRAP_S and GL_TEXTURE_WRAP_T differ");
        }
        switch (params[0]) {
            case 33069: {
                return IVideoBuffer.TextureWrapMode.CLAMP_TO_BORDER;
            }
            case 33071: {
                return IVideoBuffer.TextureWrapMode.CLAMP_TO_EDGE;
            }
            case 10497: {
                return IVideoBuffer.TextureWrapMode.REPEAT;
            }
        }
        throw new IllegalStateException("unsupported wrap mode: " + params[0]);
    }

    public void setTextureWrapMode(IVideoBuffer.TextureWrapMode wrapMode) {
        int param;
        switch (wrapMode) {
            case CLAMP_TO_BORDER: {
                param = 33069;
                break;
            }
            case CLAMP_TO_EDGE: {
                param = 33071;
                break;
            }
            case REPEAT: {
                param = 10497;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported wrap mode: " + wrapMode.name());
            }
        }
        int texture = this.getTexture();
        GL2 gl = this.context.getGL().getGL2();
        int[] current = new int[1];
        gl.glGetIntegerv(32873, current, 0);
        try {
            gl.glBindTexture(3553, texture);
            gl.glTexParameteri(3553, 10242, param);
            gl.glTexParameteri(3553, 10243, param);
        }
        finally {
            gl.glBindTexture(3553, current[0]);
        }
    }

    public void clear() {
        this.clear(Color.COLORLESS_TRANSPARENT);
    }

    public void clear(Color color) {
        if (this.array != null) {
            this.clearArray(this.array, color);
        } else {
            this.clearTexture(color);
        }
    }

    public void copyToTexture(Object srcArray, ColorMode srcColorMode) {
        if (this.array != null) {
            this.array.release();
            this.array = null;
        }
        this.copyArrayToTexture(srcArray, this.getTexture(), srcColorMode, this.bounds.width, this.bounds.height);
    }

    private int createTexture(ColorMode colorMode, int width, int height) {
        GL2 gl = this.context.getGL().getGL2();
        int[] texture = new int[1];
        int[] current = new int[1];
        gl.glGetIntegerv(32873, current, 0);
        try {
            gl.glGenTextures(1, texture, 0);
            gl.glBindTexture(3553, texture[0]);
            gl.glTexParameteri(3553, 10241, 9728);
            gl.glTexParameteri(3553, 10240, 9728);
            gl.glTexParameteri(3553, 10242, 33069);
            gl.glTexParameteri(3553, 10243, 33069);
            gl.glTexParameterfv(3553, 4100, FLOAT0000, 0);
            gl.glTexImage2D(3553, 0, colorMode.glInternalFormat, Math.max(1, width), Math.max(1, height), 0, 32993, colorMode.glDataType, null);
            int result = texture[0];
            texture[0] = 0;
            int n = result;
            return n;
        }
        finally {
            gl.glBindTexture(3553, current[0]);
            if (texture[0] != 0) {
                gl.glDeleteTextures(1, texture, 0);
            }
        }
    }

    private void deleteTexture(int texture) {
        GL2 gl = this.context.getGL().getGL2();
        gl.glDeleteTextures(1, new int[]{texture}, 0);
    }

    private IArray<?> createArray(ColorMode colorMode, int width, int height) {
        int arraySize = width * height * 4;
        switch (colorMode) {
            case RGBA8: {
                return this.arrayPools.getByteArray(arraySize);
            }
            case RGBA16: {
                return this.arrayPools.getShortArray(arraySize);
            }
            case RGBA16_FLOAT: 
            case RGBA32_FLOAT: {
                return this.arrayPools.getFloatArray(arraySize);
            }
        }
        throw new UnsupportedOperationException("ColorMode: " + colorMode.name());
    }

    private void copyArrayToTexture(Object srcArray, int dstTexture, ColorMode srcColorMode, int width, int height) {
        ReentrantLock lock = this.glGlobal.getGlobalLock();
        lock.lock();
        try {
            GL2 gl = this.context.getGL().getGL2();
            int[] pbo = new int[1];
            int[] current = new int[2];
            gl.glGetIntegerv(35055, current, 0);
            gl.glGetIntegerv(32873, current, 1);
            try {
                gl.glGenBuffers(1, pbo, 0);
                gl.glBindBuffer(35052, pbo[0]);
                gl.glBindTexture(3553, dstTexture);
                int imageBytes = width * height * srcColorMode.javaPixelBytes;
                gl.glBufferData(35052, imageBytes, this.toNioBuffer(srcArray), 35040);
                gl.glTexSubImage2D(3553, 0, 0, 0, width, height, 32993, srcColorMode.glDataType, 0L);
            }
            finally {
                gl.glBindTexture(3553, current[1]);
                gl.glBindBuffer(35052, current[0]);
                if (pbo[0] != 0) {
                    gl.glDeleteBuffers(1, pbo, 0);
                }
            }
        }
        finally {
            lock.unlock();
        }
    }

    private Buffer toNioBuffer(Object array) {
        if (array instanceof byte[]) {
            return ByteBuffer.wrap((byte[])array);
        }
        if (array instanceof short[]) {
            return ShortBuffer.wrap((short[])array);
        }
        if (array instanceof float[]) {
            return FloatBuffer.wrap((float[])array);
        }
        throw new IllegalArgumentException("not array or unsupported array type: " + array.getClass().getName());
    }

    private void copyTextureToArray(int srcTexture, Object dstArray, ColorMode srcColorMode, int width, int height) {
        ReentrantLock lock = this.glGlobal.getGlobalLock();
        lock.lock();
        try {
            GL2 gl = this.context.getGL().getGL2();
            int[] fb = new int[1];
            gl.glGetFramebufferAttachmentParameteriv(36160, 36064, 36049, fb, 0);
            if (fb[0] != 0) {
                throw new IllegalStateException("framebuffer is in use");
            }
            int[] pbo = new int[1];
            int[] current = new int[2];
            gl.glGetIntegerv(35053, current, 0);
            gl.glGetIntegerv(3074, current, 1);
            try {
                gl.glGenBuffers(1, pbo, 0);
                gl.glBindBuffer(35051, pbo[0]);
                int imageBytes = width * height * srcColorMode.javaPixelBytes;
                gl.glBufferData(35051, imageBytes, null, 35041);
                gl.glFramebufferTexture2D(36160, 36064, 3553, srcTexture, 0);
                gl.glReadBuffer(36064);
                gl.glReadPixels(0, 0, width, height, 32993, srcColorMode.glDataType, 0L);
                ByteBuffer mappedPBO = gl.glMapBuffer(35051, 35000);
                this.copyPBOToArray(mappedPBO, dstArray);
                gl.glUnmapBuffer(35051);
            }
            finally {
                gl.glReadBuffer(current[1]);
                gl.glBindBuffer(35051, current[0]);
                if (pbo[0] != 0) {
                    gl.glDeleteBuffers(1, pbo, 0);
                }
                gl.glFramebufferTexture2D(36160, 36064, 3553, 0, 0);
            }
        }
        finally {
            lock.unlock();
        }
    }

    private void copyPBOToArray(ByteBuffer mappedPBO, Object array) {
        if (array instanceof byte[]) {
            mappedPBO.get((byte[])array, 0, mappedPBO.capacity());
        } else if (array instanceof short[]) {
            mappedPBO.asShortBuffer().get((short[])array, 0, mappedPBO.capacity() / 2);
        } else if (array instanceof float[]) {
            mappedPBO.asFloatBuffer().get((float[])array, 0, mappedPBO.capacity() / 4);
        } else {
            throw new IllegalArgumentException("not array or unsupported array type: " + array.getClass().getName());
        }
    }

    private void clearTexture(Color color) {
        final float a = (float)color.a;
        final float r = (float)color.r * a;
        final float g = (float)color.g * a;
        final float b = (float)color.b * a;
        Runnable operation = new Runnable(){

            public void run() {
                GL2 gl = VideoBufferImpl.this.context.getGL().getGL2();
                gl.glClearColor(r, g, b, a);
                gl.glClear(16384);
            }
        };
        int pushAttribs = 16384;
        this.support.useFramebuffer(operation, pushAttribs, (IVideoBuffer)this, new IVideoBuffer[0]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void clearArray(IArray<?> array, Color color) {
        Object a = array.getArray();
        int len = array.getLength();
        if (color.r != 0.0 || color.g != 0.0 || color.b != 0.0 || color.a != 0.0) throw new UnsupportedOperationException("not implemented");
        if (a instanceof byte[]) {
            Arrays.fill((byte[])a, 0, len, (byte)0);
            return;
        } else if (a instanceof short[]) {
            Arrays.fill((short[])a, 0, len, (short)0);
            return;
        } else {
            if (!(a instanceof float[])) throw new IllegalArgumentException("unsupported array type: " + array.getClass().getName());
            Arrays.fill((float[])a, 0, len, 0.0f);
        }
    }
}

