/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IShaderProgram;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.annotations.ShaderSource;
import ch.kuramo.javie.api.services.IAlphaChannelSupport;
import ch.kuramo.javie.api.services.IShaderRegistry;
import ch.kuramo.javie.api.services.IVideoRenderSupport;
import ch.kuramo.javie.core.Util;
import ch.kuramo.javie.core.services.RenderContext;
import com.google.inject.Inject;
import java.util.Set;
import javax.media.opengl.GL2;
import javax.media.opengl.GLUniformData;

public class AlphaChannelSupportImpl
implements IAlphaChannelSupport {
    private final RenderContext context;
    private final IVideoRenderSupport support;
    private final IShaderProgram unmultiplyProgram;
    @ShaderSource
    public static final String[] UNMULTIPLY = new String[]{"uniform sampler2D texture;", "", "void main(void)", "{", "\tvec4 color = texture2D(texture, gl_TexCoord[0].st);", "\tgl_FragColor = (color.a == 0.0) ? vec4(0.0) : vec4(color.rgb/color.a, color.a);", "}"};

    @Inject
    public AlphaChannelSupportImpl(RenderContext context, IVideoRenderSupport support, IShaderRegistry shaders) {
        this.context = context;
        this.support = support;
        this.unmultiplyProgram = shaders.getProgram(AlphaChannelSupportImpl.class, "UNMULTIPLY");
    }

    public IVideoBuffer unmultiply(IVideoBuffer buffer) {
        Set<GLUniformData> uniforms = Util.newSet();
        uniforms.add(new GLUniformData("texture", 0));
        return this.support.useShaderProgram(this.unmultiplyProgram, uniforms, null, new IVideoBuffer[]{buffer});
    }

    private void blend(final IVideoBuffer buffer, final Color color, final int equation, final int srcRGBFactor, final int dstRGBFactor, final int srcAlphaFactor, final int dstAlphaFactor) {
        Runnable operation = new Runnable(){

            public void run() {
                GL2 gl = AlphaChannelSupportImpl.this.context.getGL().getGL2();
                gl.glColor4f((float)color.r, (float)color.g, (float)color.b, (float)color.a);
                gl.glEnable(3042);
                gl.glBlendEquation(equation);
                gl.glBlendFuncSeparate(srcRGBFactor, dstRGBFactor, srcAlphaFactor, dstAlphaFactor);
                AlphaChannelSupportImpl.this.support.ortho2D(buffer);
                AlphaChannelSupportImpl.this.support.quad2D(buffer, new IVideoBuffer[0]);
            }
        };
        int pushAttribs = 24577;
        this.support.useFramebuffer(operation, pushAttribs, buffer, new IVideoBuffer[0]);
    }

    public void premultiply(IVideoBuffer buffer) {
        this.blend(buffer, Color.WHITE, 32774, 0, 772, 0, 1);
    }

    public void discardAlpha(IVideoBuffer buffer) {
        this.blend(buffer, Color.WHITE, 32774, 0, 1, 1, 0);
    }

    public void alphaToGrayscale(IVideoBuffer buffer, Color color) {
        this.blend(buffer, color, 32774, 772, 0, 1, 0);
    }

    public void addColorMatte(IVideoBuffer buffer, Color color) {
        this.blend(buffer, color, 32774, 773, 1, 0, 1);
    }

    public void removeColorMatte(IVideoBuffer buffer, Color color) {
        this.blend(buffer, color, 32779, 773, 1, 0, 1);
    }
}

