/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.internal.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;
import com.google.inject.Inject;
import ftgl.FTGL;
import ftgl.FTGLfont;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoRenderSupportImplOld
implements VideoRenderSupport {
    @Inject
    private RenderContext _context;
    @Inject
    private IAntiAliasSupport _aaSupport;

    @Override
    public void fillRectCR(IVideoBuffer resultBuffer, final double[] mvMatrix, final double[] prjMatrix, final Size2i size, final Color color) {
        final int resultTexture = resultBuffer.getTexture();
        final VideoBounds resultBounds = resultBuffer.getBounds();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                final GL2 gl = VideoRenderSupportImplOld.this._context.getGL().getGL2();
                gl.glViewport(0, 0, resultBounds.width, resultBounds.height);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(prjMatrix, 0);
                gl.glMatrixMode(5888);
                gl.glLoadMatrixd(mvMatrix, 0);
                gl.glFramebufferTexture2D(36160, 36064, 3553, resultTexture, 0);
                gl.glDrawBuffer(36064);
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                float a = (float)color.a;
                float r = (float)color.r * a;
                float g = (float)color.g * a;
                float b = (float)color.b * a;
                gl.glColor4f(r, g, b, a);
                VideoRenderSupportImplOld.this._aaSupport.antiAlias(resultBounds.width, resultBounds.height, new Runnable(){

                    public void run() {
                        gl.glBegin(7);
                        gl.glVertex2i(0, 0);
                        gl.glVertex2i(size.width, 0);
                        gl.glVertex2i(size.width, size.height);
                        gl.glVertex2i(0, size.height);
                        gl.glEnd();
                    }
                });
                gl.glColor4fv(savedColor, 0);
                gl.glFramebufferTexture2D(36160, 36064, 3553, 0, 0);
                return null;
            }
        });
    }

    private void ortho2D(GL2 gl, GLU glu, int width, int height) {
        gl.glViewport(0, 0, width, height);
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        glu.gluOrtho2D(0.0f, (float)width, 0.0f, (float)height);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
    }

    private <T> T pushMatrixAndExecute(WrappedOperation<T> operation) {
        return operation.execute();
    }

    @Override
    public void multModelViewMatrix(Vec3d anchorPoint, Vec3d scale, Vec3d rotate, Vec3d orientation, Vec3d interest, Vec3d position) {
        GL2 gl = this._context.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glTranslatef((float)position.x, (float)position.y, (float)position.z);
        if (interest != null) {
            double dx = interest.x - position.x;
            double dy = interest.y - position.y;
            double dz = interest.z - position.z;
            gl.glRotatef((float)Math.toDegrees(Math.atan2(dx, dz)), 0.0f, 1.0f, 0.0f);
            gl.glRotatef((float)Math.toDegrees(-Math.atan2(dy, Math.sqrt(dx * dx + dz * dz))), 1.0f, 0.0f, 0.0f);
        }
        gl.glRotatef((float)orientation.x, 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)orientation.y, 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)orientation.z, 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)rotate.x, 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)rotate.y, 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)rotate.z, 0.0f, 0.0f, 1.0f);
        gl.glScalef((float)(scale.x / 100.0), (float)(scale.y / 100.0), (float)(scale.z / 100.0));
        gl.glTranslatef((float)(-anchorPoint.x), (float)(-anchorPoint.y), (float)(-anchorPoint.z));
    }

    @Override
    public void multModelViewMatrixInverse(Vec3d anchorPoint, Vec3d scale, Vec3d rotate, Vec3d orientation, Vec3d interest, Vec3d position) {
        GL2 gl = this._context.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glTranslatef((float)anchorPoint.x, (float)anchorPoint.y, (float)anchorPoint.z);
        gl.glScalef((float)(100.0 / scale.x), (float)(100.0 / scale.y), (float)(100.0 / scale.z));
        gl.glRotatef((float)(-rotate.z), 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)(-rotate.y), 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)(-rotate.x), 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)(-orientation.z), 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)(-orientation.y), 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)(-orientation.x), 1.0f, 0.0f, 0.0f);
        if (interest != null) {
            double dx = interest.x - position.x;
            double dy = interest.y - position.y;
            double dz = interest.z - position.z;
            gl.glRotatef((float)Math.toDegrees(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz))), 1.0f, 0.0f, 0.0f);
            gl.glRotatef((float)Math.toDegrees(-Math.atan2(dx, dz)), 0.0f, 1.0f, 0.0f);
        }
        gl.glTranslatef((float)(-position.x), (float)(-position.y), (float)(-position.z));
    }

    @Override
    public void multCameraMatrix(Vec3d rotate, Vec3d orientation, Vec3d interest, Vec3d position, boolean flipZ) {
        double dx = interest.x - position.x;
        double dy = interest.y - position.y;
        double dz = interest.z - position.z;
        float _1 = flipZ ? -1 : 1;
        GL2 gl = this._context.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glRotatef((float)(-rotate.z), 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)(-rotate.y), 0.0f, _1, 0.0f);
        gl.glRotatef((float)(-rotate.x), _1, 0.0f, 0.0f);
        gl.glRotatef((float)(-orientation.z), 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)(-orientation.y), 0.0f, _1, 0.0f);
        gl.glRotatef((float)(-orientation.x), _1, 0.0f, 0.0f);
        gl.glRotatef((float)Math.toDegrees(Math.atan2(dy, Math.sqrt(dx * dx + dz * dz))), _1, 0.0f, 0.0f);
        gl.glRotatef((float)Math.toDegrees(-Math.atan2(dx, dz)), 0.0f, _1, 0.0f);
        gl.glTranslatef((float)(-position.x), (float)(-position.y), (float)(-position.z) * _1);
        if (flipZ) {
            gl.glScalef(1.0f, 1.0f, -1.0f);
        }
    }

    @Override
    public void multCameraMatrixInverse(Vec3d rotate, Vec3d orientation, Vec3d interest, Vec3d position) {
        double dx = interest.x - position.x;
        double dy = interest.y - position.y;
        double dz = interest.z - position.z;
        GL2 gl = this._context.getGL().getGL2();
        gl.glMatrixMode(5888);
        gl.glTranslatef((float)position.x, (float)position.y, (float)position.z);
        gl.glRotatef((float)Math.toDegrees(Math.atan2(dx, dz)), 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)Math.toDegrees(-Math.atan2(dy, Math.sqrt(dx * dx + dz * dz))), 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)orientation.x, 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)orientation.y, 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)orientation.z, 0.0f, 0.0f, 1.0f);
        gl.glRotatef((float)rotate.x, 1.0f, 0.0f, 0.0f);
        gl.glRotatef((float)rotate.y, 0.0f, 1.0f, 0.0f);
        gl.glRotatef((float)rotate.z, 0.0f, 0.0f, 1.0f);
    }

    @Override
    public void getMatrix(double[] mvMatrix, double[] prjMatrix) {
        GL2 gl = this._context.getGL().getGL2();
        if (mvMatrix != null) {
            gl.glGetDoublev(2982, mvMatrix, 0);
        }
        if (prjMatrix != null) {
            gl.glGetDoublev(2983, prjMatrix, 0);
        }
    }

    @Override
    public void setMatrix(double[] mvMatrix, double[] prjMatrix) {
        GL2 gl = this._context.getGL().getGL2();
        if (prjMatrix != null) {
            gl.glMatrixMode(5889);
            gl.glLoadMatrixd(prjMatrix, 0);
        }
        if (mvMatrix != null) {
            gl.glMatrixMode(5888);
            gl.glLoadMatrixd(mvMatrix, 0);
        }
    }

    @Override
    public void renderText(final FTGLfont font, final Color fillColor, final String[] texts, final double[][] offsets, IVideoBuffer resultBuffer) {
        final VideoBounds resultBounds = resultBuffer.getBounds();
        if (resultBounds.isEmpty()) {
            return;
        }
        final int resultTexture = resultBuffer.getTexture();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                GL2 gl = VideoRenderSupportImplOld.this._context.getGL().getGL2();
                GLU glu = VideoRenderSupportImplOld.this._context.getGLU();
                float scale = (float)((VideoRenderSupportImplOld)VideoRenderSupportImplOld.this)._context.getVideoResolution().scale;
                VideoRenderSupportImplOld.this.ortho2D(gl, glu, resultBounds.width, resultBounds.height);
                gl.glTranslatef((float)(-resultBounds.x), (float)(-resultBounds.y), 0.0f);
                double[] mvMatrix = new double[16];
                VideoRenderSupportImplOld.this.getMatrix(mvMatrix, null);
                gl.glFramebufferTexture2D(36160, 36064, 3553, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                gl.glColor4f((float)fillColor.r, (float)fillColor.g, (float)fillColor.b, (float)fillColor.a);
                gl.glEnable(3042);
                gl.glBlendFuncSeparate(770, 771, 1, 771);
                int i = 0;
                while (i < texts.length) {
                    VideoRenderSupportImplOld.this.setMatrix(mvMatrix, null);
                    gl.glTranslatef((float)offsets[i][0], (float)offsets[i][1], 0.0f);
                    gl.glScalef(scale, -scale, scale);
                    FTGL.ftglRenderFont((FTGLfont)font, (String)texts[i], (int)65535);
                    ++i;
                }
                gl.glDisable(3042);
                gl.glColor4fv(savedColor, 0);
                gl.glFramebufferTexture2D(36160, 36064, 3553, 0, 0);
                return null;
            }
        });
    }

    @Override
    public void renderText(final FTGLfont font, final Color fillColor, final String[] texts, final double[][] offsets, IVideoBuffer resultBuffer, final double[] mvMatrix, final double[] prjMatrix) {
        final int resultTexture = resultBuffer.getTexture();
        final VideoBounds resultBounds = resultBuffer.getBounds();
        this.pushMatrixAndExecute(new WrappedOperation<Object>(){

            @Override
            public Object execute() {
                final GL2 gl = VideoRenderSupportImplOld.this._context.getGL().getGL2();
                final float scale = (float)((VideoRenderSupportImplOld)VideoRenderSupportImplOld.this)._context.getVideoResolution().scale;
                gl.glViewport(0, 0, resultBounds.width, resultBounds.height);
                gl.glMatrixMode(5889);
                gl.glLoadMatrixd(prjMatrix, 0);
                gl.glMatrixMode(5888);
                gl.glLoadMatrixd(mvMatrix, 0);
                final double[] mvMatrix2 = new double[16];
                VideoRenderSupportImplOld.this.getMatrix(mvMatrix2, null);
                gl.glFramebufferTexture2D(36160, 36064, 3553, resultTexture, 0);
                gl.glDrawBuffer(36064);
                gl.glActiveTexture(33984);
                float[] savedColor = new float[4];
                gl.glGetFloatv(2816, savedColor, 0);
                float a = (float)fillColor.a;
                float r = (float)fillColor.r * a;
                float g = (float)fillColor.g * a;
                float b = (float)fillColor.b * a;
                gl.glColor4f(r, g, b, a);
                VideoRenderSupportImplOld.this._aaSupport.antiAlias(resultBounds.width, resultBounds.height, new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < texts.length) {
                            VideoRenderSupportImplOld.this.setMatrix(mvMatrix2, null);
                            gl.glTranslatef((float)offsets[i][0], (float)offsets[i][1], 0.0f);
                            gl.glScalef(scale, -scale, scale);
                            FTGL.ftglRenderFont((FTGLfont)font, (String)texts[i], (int)65535);
                            ++i;
                        }
                    }
                });
                gl.glColor4fv(savedColor, 0);
                gl.glFramebufferTexture2D(36160, 36064, 3553, 0, 0);
                return null;
            }
        });
    }
}

