/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.core.output;

import ch.kuramo.javie.api.ColorMode;
import ch.kuramo.javie.api.IArray;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Time;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IArrayPools;
import ch.kuramo.javie.core.Composition;
import ch.kuramo.javie.core.JavieRuntimeException;
import ch.kuramo.javie.core.output.PushSourceOutput;
import com.google.inject.Inject;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;

public class JavaImageSequenceOutput
extends PushSourceOutput {
    private File parentFile;
    private boolean png;
    private String filenameFormat;
    @Inject
    private IArrayPools _arrayPools;

    protected void initialize() {
        Composition comp = this.getComposition();
        File file = this.getFile();
        this.parentFile = file.getParentFile();
        this.png = comp.getColorMode() == ColorMode.RGBA16 || file.getName().toLowerCase().endsWith(".png");
        Time frameDuration = comp.getFrameDuration();
        long numFrames = comp.getDuration().toFrameNumber(frameDuration);
        this.filenameFormat = this.createFilenameFormat(file.getName(), numFrames);
    }

    private String createFilenameFormat(String baseFilename, long numFrames) {
        int lastDot = baseFilename.lastIndexOf(46);
        if (lastDot != -1) {
            baseFilename = baseFilename.substring(0, lastDot);
        }
        return String.valueOf(baseFilename.replaceAll("%", "%%")) + " %0" + String.valueOf(numFrames - 1L).length() + "d." + (this.png ? "png" : "bmp");
    }

    protected void finish() {
    }

    public boolean isVideoEnabled() {
        return true;
    }

    public void setVideoEnabled(boolean videoEnabled) {
        throw new UnsupportedOperationException("can't change videoEnabled");
    }

    public boolean isAudioEnabled() {
        return false;
    }

    public void setAudioEnabled(boolean audioEnabled) {
        throw new UnsupportedOperationException("can't change audioEnabled");
    }

    protected void writeVideo(long frameNumber, Time time, IVideoBuffer vb) {
        try {
            this.writeToFile(vb, String.format(this.filenameFormat, frameNumber));
        }
        catch (IOException e) {
            throw new JavieRuntimeException(e);
        }
    }

    protected void writeAudio(long frameNumber, Time time, IAudioBuffer ab) {
        throw new UnsupportedOperationException();
    }

    private void writeToFile(IVideoBuffer vb, String filename) throws IOException {
        File file = new File(this.parentFile, filename);
        VideoBounds bounds = vb.getBounds();
        int width = bounds.width;
        int height = bounds.height;
        switch (vb.getColorMode()) {
            case RGBA8: {
                byte[] array = (byte[])vb.getArray();
                if (this.png) {
                    int[] nArray = new int[4];
                    nArray[0] = 2;
                    nArray[1] = 1;
                    nArray[3] = 3;
                    WritableRaster wr = Raster.createInterleavedRaster(new DataBufferByte(array, width * height * 4), width, height, width * 4, 4, nArray, null);
                    ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 0);
                    BufferedImage image = new BufferedImage(cm, wr, false, null);
                    ImageIO.write((RenderedImage)image, "png", file);
                    break;
                }
                IArray pa = this._arrayPools.getByteArray(width * height * 3);
                byte[] array2 = (byte[])pa.getArray();
                try {
                    int i = 0;
                    int n = width * height;
                    while (i < n) {
                        array2[i * 3] = array[i * 4];
                        array2[i * 3 + 1] = array[i * 4 + 1];
                        array2[i * 3 + 2] = array[i * 4 + 2];
                        ++i;
                    }
                    int[] nArray = new int[3];
                    nArray[0] = 2;
                    nArray[1] = 1;
                    WritableRaster wr = Raster.createInterleavedRaster(new DataBufferByte(array2, width * height * 3), width, height, width * 3, 3, nArray, null);
                    ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 0);
                    BufferedImage image = new BufferedImage(cm, wr, false, null);
                    ImageIO.write((RenderedImage)image, "bmp", file);
                    break;
                }
                finally {
                    pa.release();
                }
            }
            case RGBA16: {
                short[] array = (short[])vb.getArray();
                int[] nArray = new int[4];
                nArray[0] = 2;
                nArray[1] = 1;
                nArray[3] = 3;
                WritableRaster wr = Raster.createInterleavedRaster(new DataBufferUShort(array, width * height * 4), width, height, width * 4, 4, nArray, null);
                ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1000), true, false, 3, 1);
                BufferedImage image = new BufferedImage(cm, wr, false, null);
                ImageIO.write((RenderedImage)image, "png", file);
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported ColorMode: " + vb.getColorMode());
            }
        }
    }
}

