/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.mirror;

import org.eclipse.equinox.internal.p2.metadata.mirror.RangeQuery;
import org.eclipse.equinox.internal.p2.metadata.mirror.VersionRangedName;
import org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.internal.provisional.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.internal.provisional.p2.metadata.repository.IMetadataRepository;
import org.eclipse.equinox.internal.provisional.p2.query.Collector;
import org.eclipse.equinox.internal.provisional.p2.query.Query;

public class Mirroring {
    static /* synthetic */ Class class$0;

    public void validate(IMetadataRepository source, IMetadataRepository destination) {
        if (source == null) {
            throw new IllegalStateException("Source repository is null.");
        }
        if (destination == null) {
            throw new IllegalStateException("Destination repository is null.");
        }
        if (!destination.isModifiable()) {
            throw new IllegalStateException("Destination repository must be modifiable: " + destination.getLocation());
        }
    }

    public void mirror(IMetadataRepository source, IMetadataRepository destination, String[] rootSpecs, boolean transitive) {
        if (rootSpecs == null) {
            this.mirror(source, destination, (Query)InstallableUnitQuery.ANY, transitive);
        } else {
            VersionRangedName[] roots = new VersionRangedName[rootSpecs.length];
            int i = 0;
            while (i < rootSpecs.length) {
                roots[i] = VersionRangedName.parse(rootSpecs[i]);
                ++i;
            }
            this.mirror(source, destination, (Query)new RangeQuery(roots), transitive);
        }
    }

    public void mirror(IMetadataRepository source, IMetadataRepository destination, Query query, boolean transitive) {
        this.validate(source, destination);
        Collector result = source.query(query, new Collector(), null);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.internal.provisional.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.mirror(source, destination, (IInstallableUnit[])result.toArray((Class)clazz), transitive);
    }

    private void mirror(IMetadataRepository source, IMetadataRepository destination, IInstallableUnit[] roots, boolean transitive) {
        if (transitive) {
            roots = this.addTransitiveIUs(source, roots);
        }
        destination.addInstallableUnits(roots);
    }

    protected IInstallableUnit[] addTransitiveIUs(IMetadataRepository source, IInstallableUnit[] roots) {
        return roots;
    }
}

