/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views;

import ch.kuramo.javie.app.project.ProjectEvent;
import ch.kuramo.javie.app.project.ProjectListener;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.core.Folder;
import ch.kuramo.javie.core.Item;
import ch.kuramo.javie.core.Util;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ItemTreeContentProvider
implements ITreeContentProvider,
ProjectListener {
    private TreeViewer _viewer;
    private ProjectManager _projectManager;

    public void dispose() {
        this._viewer = null;
        this._projectManager = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (this._projectManager != null) {
            this._projectManager.removeProjectListener(this);
        }
        this._viewer = (TreeViewer)viewer;
        this._projectManager = (ProjectManager)newInput;
        if (this._projectManager != null) {
            this._projectManager.addProjectListener(this);
        }
    }

    public boolean hasChildren(Object element) {
        return element instanceof Folder ? this._projectManager.hasChildren((Folder)element) : false;
    }

    public Object[] getChildren(Object parentElement) {
        return parentElement instanceof Folder ? this._projectManager.listChildren((Folder)parentElement).toArray() : null;
    }

    public Object[] getElements(Object inputElement) {
        return this._projectManager.listChildren(null).toArray();
    }

    public Object getParent(Object element) {
        return ((Item)element).getParent();
    }

    @Override
    public void handleProjectEvent(ProjectEvent event) {
        if (event.getProjectManager() != this._projectManager) {
            return;
        }
        switch (event.type) {
            case ITEM_NAME_CHANGE: 
            case ITEM_UPDATE: {
                this.update(ProjectEvent.getItem(event));
                break;
            }
            case ITEMS_ADD: 
            case ITEMS_REPARENT: {
                this.refresh(ProjectEvent.getItems(event), ProjectEvent.getRelatedItems(event));
                break;
            }
            case ITEMS_REMOVE: {
                this.refresh(Collections.<Item>emptySet(), ProjectEvent.getRelatedItems(event));
            }
        }
    }

    private void update(Item item) {
        this._viewer.update((Object)item, null);
        this.select(Collections.singleton(item));
    }

    private void refresh(Set<Item> items, Set<Item> relatedItems) {
        if (relatedItems.isEmpty()) {
            this._viewer.refresh();
        } else {
            for (Item i : relatedItems) {
                this._viewer.refresh((Object)i);
            }
        }
        this.select(items);
    }

    private void select(Set<Item> items) {
        List list = Util.newList();
        for (Item i : items) {
            LinkedList<Item> segmentList = new LinkedList<Item>();
            do {
                segmentList.addFirst(i);
            } while ((i = i.getParent()) != null);
            list.add(new TreePath(segmentList.toArray()));
        }
        this._viewer.setSelection((ISelection)new TreeSelection(list.toArray(new TreePath[list.size()])), true);
    }
}

