/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.views.ComboBoxViewerCellEditor;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElement;
import ch.kuramo.javie.app.views.layercomp.AnimatableValueElementDelegate;
import ch.kuramo.javie.core.AnimatableLayerReference;
import ch.kuramo.javie.core.ItemLayer;
import ch.kuramo.javie.core.Layer;
import ch.kuramo.javie.core.LayerComposition;
import ch.kuramo.javie.core.Util;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnimatableLayerReferenceElementDelegate
extends AnimatableValueElementDelegate<String> {
    private ComboBoxViewerCellEditor editor;
    private static final Object NO_LAYER = new Object();

    public AnimatableLayerReferenceElementDelegate(AnimatableValueElement element, String name, AnimatableLayerReference avalue) {
        super(element, name, avalue);
    }

    @Override
    protected void drawValue(GC gc, int x, int y, int height, boolean focused) {
        Layer layer = this.getReferencedLayer();
        String value = layer == null ? "\u306a\u3057" : (!(layer instanceof ItemLayer) || this.isLayerNameMode() ? layer.getName() : ((ItemLayer)layer).getItem().getName());
        this.drawValue(gc, x, y, height, focused, value);
    }

    @Override
    protected boolean canDragGestureEdit() {
        return false;
    }

    @Override
    protected String dragGesture(double dx, double dy) {
        throw new UnsupportedOperationException("drag gesture edit is not supported");
    }

    @Override
    public boolean canEdit(int columnIndex) {
        if (columnIndex == 1) {
            return this.canInlineEdit;
        }
        return false;
    }

    @Override
    public CellEditor getCellEditor(int columnIndex) {
        if (columnIndex == 1) {
            if (this.editor == null) {
                this.editor = new ComboBoxViewerCellEditor((Composite)this.element.viewer.getTree(), 8);
                this.editor.setContenProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                this.editor.setLabelProvider((IBaseLabelProvider)new LayerLabelProvider());
                this.editor.setActivationStyle(4);
                ((Combo)this.editor.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        AnimatableLayerReferenceElementDelegate.this.setCellEditorValue(1, AnimatableLayerReferenceElementDelegate.this.editor.getValue());
                    }
                });
            }
            this.editor.setInput(this.getLayers());
            return this.editor;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue(int columnIndex) {
        if (columnIndex == 1) {
            Layer layer = this.getReferencedLayer();
            return layer != null ? layer : NO_LAYER;
        }
        return null;
    }

    @Override
    public void setCellEditorValue(int columnIndex, Object value) {
        if (columnIndex == 1) {
            this.modifyValue(value != NO_LAYER ? ((Layer)value).getId() : "");
        }
    }

    private LayerComposition getLayerComposition() {
        return (LayerComposition)this.element.viewer.getData("LAYER_COMPOSITION");
    }

    private Layer getReferencedLayer() {
        return this.getLayerComposition().getLayer((String)this.value);
    }

    private boolean isLayerNameMode() {
        return Boolean.TRUE.equals(this.element.viewer.getData("LAYER_NAME_MODE"));
    }

    private Object[] getLayers() {
        List layers = Util.newList();
        for (Layer l : this.getLayerComposition().getLayers()) {
            layers.add(l);
        }
        layers.add(NO_LAYER);
        Collections.reverse(layers);
        return layers.toArray();
    }

    private class LayerLabelProvider
    extends LabelProvider {
        private LayerLabelProvider() {
        }

        public String getText(Object element) {
            if (element == NO_LAYER) {
                return "\u306a\u3057";
            }
            if (!(element instanceof ItemLayer) || AnimatableLayerReferenceElementDelegate.this.isLayerNameMode()) {
                return ((Layer)element).getName();
            }
            return ((ItemLayer)element).getItem().getName();
        }
    }
}

