/*
 * Decompiled with CFR 0.152.
 */
package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.EnumLabels;
import ch.kuramo.javie.app.views.ComboBoxViewerCellEditor;
import ch.kuramo.javie.app.views.layercomp.Element;
import ch.kuramo.javie.app.views.layercomp.LayerPropertyElement;
import ch.kuramo.javie.core.Layer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerEnumPropertyElement<E extends Enum<E>>
extends LayerPropertyElement<E> {
    protected boolean canEdit;
    protected ComboBoxViewerCellEditor editor;

    public LayerEnumPropertyElement(Element parent, Layer layer, String property, String label) {
        super(parent, layer, property, label);
    }

    public LayerEnumPropertyElement(Element parent, Layer layer, String property, String label, String operationLabel) {
        super(parent, layer, property, label, operationLabel);
    }

    @Override
    protected String getValueString() {
        return EnumLabels.getLabel((Enum)this.getValue());
    }

    @Override
    protected void mouseDownOnValueArea() {
        this.canEdit = true;
        this.viewer.editElement((Object)this, 1);
        this.canEdit = false;
    }

    @Override
    public boolean canEdit(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return this.canEdit;
            }
        }
        return super.canEdit(columnIndex);
    }

    @Override
    public CellEditor getCellEditor(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                if (this.editor == null) {
                    this.editor = new ComboBoxViewerCellEditor((Composite)this.viewer.getTree(), 8);
                    this.editor.setContenProvider((IStructuredContentProvider)ArrayContentProvider.getInstance());
                    this.editor.setLabelProvider((IBaseLabelProvider)new EnumLabelProvider());
                    this.editor.setActivationStyle(4);
                    ((Combo)this.editor.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            LayerEnumPropertyElement.this.setCellEditorValue(1, LayerEnumPropertyElement.this.editor.getValue());
                        }
                    });
                }
                this.editor.setInput(((Enum)this.getValue()).getClass().getEnumConstants());
                return this.editor;
            }
        }
        return null;
    }

    @Override
    public Object getCellEditorValue(int columnIndex) {
        switch (columnIndex) {
            case 1: {
                return this.getValue();
            }
        }
        return null;
    }

    @Override
    public void setCellEditorValue(int columnIndex, Object value) {
        switch (columnIndex) {
            case 1: {
                Enum e = (Enum)value;
                this.setValue(e);
            }
        }
    }

    private class EnumLabelProvider
    extends LabelProvider {
        private EnumLabelProvider() {
        }

        public String getText(Object element) {
            Enum e = (Enum)element;
            return EnumLabels.getLabel(e);
        }
    }
}

