/*
 * Decompiled with CFR 0.152.
 */
package com.sun.opengl.impl.awt;

import com.sun.opengl.impl.GLWorkerThread;
import com.sun.opengl.impl.ThreadingImpl;
import com.sun.opengl.impl.ThreadingPlugin;
import com.sun.opengl.impl.awt.Java2D;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import javax.media.opengl.GLException;

public class AWTThreadingPlugin
implements ThreadingPlugin {
    public boolean isOpenGLThread() throws GLException {
        switch (ThreadingImpl.getMode()) {
            case 1: {
                if (Java2D.isOGLPipelineActive()) {
                    return Java2D.isQueueFlusherThread() || ThreadingImpl.isX11() && EventQueue.isDispatchThread();
                }
                return EventQueue.isDispatchThread();
            }
            case 2: {
                if (Java2D.isOGLPipelineActive()) {
                    return Java2D.isQueueFlusherThread() || ThreadingImpl.isX11() && GLWorkerThread.isWorkerThread();
                }
                return GLWorkerThread.isWorkerThread();
            }
        }
        throw new InternalError("Illegal single-threading mode " + ThreadingImpl.getMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeOnOpenGLThread(Runnable runnable) throws GLException {
        switch (ThreadingImpl.getMode()) {
            case 1: {
                if (Java2D.isOGLPipelineActive() && !ThreadingImpl.isX11()) {
                    Java2D.invokeWithOGLContextCurrent(null, runnable);
                    break;
                }
                try {
                    EventQueue.invokeAndWait(runnable);
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new GLException(invocationTargetException.getTargetException());
                }
                catch (InterruptedException interruptedException) {
                    throw new GLException(interruptedException);
                }
            }
            case 2: {
                if (!GLWorkerThread.isStarted()) {
                    Class clazz = GLWorkerThread.class;
                    synchronized (clazz) {
                        if (!GLWorkerThread.isStarted()) {
                            GLWorkerThread.start();
                        }
                    }
                }
                try {
                    GLWorkerThread.invokeAndWait(runnable);
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new GLException(invocationTargetException.getTargetException());
                }
                catch (InterruptedException interruptedException) {
                    throw new GLException(interruptedException);
                }
            }
            default: {
                throw new InternalError("Illegal single-threading mode " + ThreadingImpl.getMode());
            }
        }
    }
}

