/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.api;

/**
 * <code>IShaderProgram</code> はシェーダプログラムを使用するためのインターフェースです。
 * <code>IShaderProgram</code> オブジェクトは
 * {@link ch.kuramo.javie.api.services.IShaderRegistry} から取得することができます。
 */
public interface IShaderProgram {

	/**
	 * このシェーダプログラムの名前を取得します。
	 * 
	 * @return シェーダプログラムの名前
	 */
	String getName();

	/**
	 * このシェーダプログラムを使用します。このシェーダプログラムを使用して行う処理を、引数
	 * <code>r</code> の <code>run()</code> メソッドに記述します。
	 * 
	 * @param r シェーダプログラムを使用して行う処理
	 */
	void useProgram(Runnable r);

	/**
	 * プログラムオブジェクトの番号を取得します。
	 *  
	 * @return プログラムオブジェクトの番号
	 */
	int getProgram();

	/**
	 * このシェーダプログラムの Attribute 変数の位置を取得します。
	 * 位置を取得する Attribute 変数の名前を、引数 <code>attributeName</code> で指定します。
	 * 
	 * @param attributeName Attribute 変数の名前
	 * @return <code>attributeName</code> で指定した Attribute 変数の位置
	 */
	int getAttributeLocation(String attributeName);

	/**
	 * このシェーダプログラムの Uniform 変数の位置を取得します。
	 * 位置を取得する Uniform 変数の名前を、引数 <code>uniformName</code> で指定します。
	 * 
	 * @param uniformName Uniform 変数の名前
	 * @return <code>uniformName</code> で指定した Uniform 変数の位置
	 */
	int getUniformLocation(String uniformName);

}
