/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Combo;

import ch.kuramo.javie.app.EnumLabels;
import ch.kuramo.javie.app.views.ComboBoxViewerCellEditor;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.Layer;

public class LayerEnumPropertyElement<E extends Enum<E>> extends LayerPropertyElement<E> {

	protected boolean canEdit;
	
	protected ComboBoxViewerCellEditor editor;


	public LayerEnumPropertyElement(
			Element parent, Layer layer, String property, String label) {

		super(parent, layer, property, label);
	}

	public LayerEnumPropertyElement(
			Element parent, Layer layer, String property,
			String label, String operationLabel) {

		super(parent, layer, property, label, operationLabel);
	}

	@Override
	protected String getValueString() {
		return EnumLabels.getLabel(getValue());
	}

	@Override
	protected void mouseDownOnValueArea() {
		canEdit = true;
		viewer.editElement(this, LayerCompositionView.VALUE_COL);
		canEdit = false;
	}

	@Override
	public boolean canEdit(int columnIndex) {
		switch (columnIndex) {
			case LayerCompositionView.VALUE_COL:
				return canEdit;

			default:
				return super.canEdit(columnIndex);
		}
	}

	@Override
	public CellEditor getCellEditor(int columnIndex) {
		switch (columnIndex) {
			case LayerCompositionView.VALUE_COL:
				if (editor == null) {
					editor = new ComboBoxViewerCellEditor(viewer.getTree(), SWT.READ_ONLY);
					editor.setContenProvider(ArrayContentProvider.getInstance());
					editor.setLabelProvider(new EnumLabelProvider());
					editor.setActivationStyle(ComboBoxViewerCellEditor.DROP_DOWN_ON_PROGRAMMATIC_ACTIVATION);

					((Combo) editor.getControl()).addSelectionListener(new SelectionAdapter() {
						public void widgetSelected(SelectionEvent e) {
							setCellEditorValue(LayerCompositionView.VALUE_COL, editor.getValue());
						}
					});
				}
				editor.setInput(getValue().getClass().getEnumConstants());
				return editor;

			default:
				return null;
		}
	}

	@Override
	public Object getCellEditorValue(int columnIndex) {
		switch (columnIndex) {
			case LayerCompositionView.VALUE_COL:
				return getValue();

			default:
				return null;
		}
	}

	@Override
	public void setCellEditorValue(int columnIndex, Object value) {
		switch (columnIndex) {
			case LayerCompositionView.VALUE_COL:
				@SuppressWarnings("unchecked")
				E e = (E) value;
				setValue(e);
				break;
		}
	}

	private class EnumLabelProvider extends LabelProvider {
		public String getText(Object element) {
			@SuppressWarnings("unchecked")
			E e = (E) element;
			return EnumLabels.getLabel(e);
		}
	}

}
