/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import java.util.List;

import ch.kuramo.javie.core.LightType;
import ch.kuramo.javie.core.Util;

public class LightOptionsElement extends LayerEnumPropertyElement<LightType> {

	private LightType type;

	private final List<Element> children = Util.newList();


	public LightOptionsElement(LayerElement parent) {
		super(parent, parent.layer, "lightType", "ライトオプション", "ライトの種類を変更");
	}

	@Override
	public boolean hasChildren() {
		return true;
	}

	@Override
	public Element[] getChildren() {
		LightType currentType = getValue();

		if (currentType == type && children.size() > 0) {
			return children.toArray(new Element[children.size()]);
		}

		children.clear();
		type = currentType;

		switch (type) {
			case PARALLEL:
				createAnimatableValueElement("intensity", "強度", "%");
				createAnimatableValueElement("color", "カラー");
				createBooleanPropertyElement("castsShadows", "シャドウを落とす");
				createAnimatableValueElement("shadowDarkness", "シャドウの暗さ", "%");
				break;

			case SPOT:
				createAnimatableValueElement("intensity", "強度", "%");
				createAnimatableValueElement("attenuation", "減衰");
				createAnimatableValueElement("color", "カラー");
				createAnimatableValueElement("coneAngle", "円錐頂角", "°");
				createAnimatableValueElement("coneFeather", "円錐ぼかし", "%");
				createBooleanPropertyElement("castsShadows", "シャドウを落とす");
				createAnimatableValueElement("shadowDarkness", "シャドウの暗さ", "%");
				createAnimatableValueElement("shadowDiffusion", "シャドウの拡散");
				break;

			case POINT:
				createAnimatableValueElement("intensity", "強度", "%");
				createAnimatableValueElement("attenuation", "減衰");
				createAnimatableValueElement("color", "カラー");
				createBooleanPropertyElement("castsShadows", "シャドウを落とす");
				createAnimatableValueElement("shadowDarkness", "シャドウの暗さ", "%");
				createAnimatableValueElement("shadowDiffusion", "シャドウの拡散");
				break;

			case AMBIENT:
				createAnimatableValueElement("intensity", "強度", "%");
				createAnimatableValueElement("color", "カラー");
				break;
		}

		return children.toArray(new Element[children.size()]);
	}

	private void createAnimatableValueElement(String property, String name) {
		children.add(new LayerAnimatableValueElement(this, layer, property, name, null));
	}

	private void createAnimatableValueElement(String property, String name, String unit) {
		children.add(new LayerAnimatableValueElement(this, layer, property, name, unit));
	}

	private void createBooleanPropertyElement(String property, String name) {
		children.add(new LayerBooleanPropertyElement(this, layer, property, name));
	}

}
