/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.CastsShadows;
import ch.kuramo.javie.core.Layer;

public class MaterialOptionsElement extends Element {

	private Element[] children;


	public MaterialOptionsElement(LayerElement parent) {
		super(parent);
	}

	public String getColumnText(int columnIndex) {
		switch (columnIndex) {
			case LayerCompositionView.NAME_COL:
				return "マテリアルオプション";

			default:
				return null;
		}
	}

	@Override
	public boolean hasChildren() {
		return true;
	}

	@Override
	public Element[] getChildren() {
		if (children == null) {
			Layer layer = ((LayerElement) parent).layer;
			children = new Element[] {
					new LayerEnumPropertyElement<CastsShadows>(this, layer, "castsShadows", "シャドウを落とす"),
					new LayerAnimatableValueElement(this, layer, "lightTransmission", "ライト透過", "%"),
					new LayerBooleanPropertyElement(this, layer, "acceptsShadows", "シャドウを受ける"),
					new LayerBooleanPropertyElement(this, layer, "acceptsLights", "ライトを受ける"),
					new LayerAnimatableValueElement(this, layer, "ambient", "アンビエント", "%"),
					new LayerAnimatableValueElement(this, layer, "diffuse", "拡散", "%"),
					new LayerAnimatableValueElement(this, layer, "specular", "鏡面", "%"),
					new LayerAnimatableValueElement(this, layer, "shininess", "光沢", "%"),
					new LayerAnimatableValueElement(this, layer, "metal", "金属", "%")
			};
		}
		return children;
	}

}
