/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

public class LayerNature {

	public static boolean isVideoNature(Layer layer) {
		if (layer instanceof MediaLayer) {
			return ((MediaLayer) layer).isVideoNature();
		}

		if (layer instanceof NullLayer) {
			return true;
		}

		if (layer instanceof CameraLayer) {
			return true;
		}

		if (layer instanceof LightLayer) {
			return true;
		}

		return false;
	}

	public static boolean isVideoEnabled(Layer layer) {
		if (layer instanceof MediaLayer) {
			MediaLayer mediaLayer = (MediaLayer) layer;
			return mediaLayer.isVideoNature()
				&& mediaLayer.isVideoEnabled();
		}

		if (layer instanceof NullLayer) {
			return ((NullLayer) layer).isVideoEnabled();
		}

		if (layer instanceof CameraLayer) {
			return ((CameraLayer) layer).isVideoEnabled();
		}

		if (layer instanceof LightLayer) {
			return ((LightLayer) layer).isVideoEnabled();
		}

		return false;
	}

	public static void setVideoEnabled(Layer layer, boolean enabled) {
		if (layer instanceof MediaLayer) {
			MediaLayer mediaLayer = (MediaLayer) layer;
			if (mediaLayer.isVideoNature()) {
				mediaLayer.setVideoEnabled(enabled);
				return;
			} else {
				throw new UnsupportedOperationException();
			}
		}

		if (layer instanceof NullLayer) {
			((NullLayer) layer).setVideoEnabled(enabled);
			return;
		}

		if (layer instanceof CameraLayer) {
			((CameraLayer) layer).setVideoEnabled(enabled);
			return;
		}

		if (layer instanceof LightLayer) {
			((LightLayer) layer).setVideoEnabled(enabled);
			return;
		}

		throw new UnsupportedOperationException();
	}

	public static boolean isAudioNature(Layer layer) {
		if (layer instanceof MediaLayer) {
			return ((MediaLayer) layer).isAudioNature();
		}

		return false;
	}

	public static boolean isAudioEnabled(Layer layer) {
		if (layer instanceof MediaLayer) {
			MediaLayer mediaLayer = (MediaLayer) layer;
			return mediaLayer.isAudioNature()
				&& mediaLayer.isAudioEnabled();
		}

		return false;
	}

	public static void setAudioEnabled(Layer layer, boolean enabled) {
		if (layer instanceof MediaLayer) {
			MediaLayer mediaLayer = (MediaLayer) layer;
			if (mediaLayer.isAudioNature()) {
				mediaLayer.setAudioEnabled(enabled);
				return;
			} else {
				throw new UnsupportedOperationException();
			}
		}

		throw new UnsupportedOperationException();
	}

	public static boolean isCTCRNature(Layer layer) {
		if (layer instanceof TextLayer) {
			return true;
		}

		if (layer instanceof MediaItemLayer) {
			MediaItemLayer miLayer = (MediaItemLayer) layer;
			return (miLayer.isPrecompositionLayer() || miLayer.isVectorLayer());
		}

		if (layer instanceof MediaLayer) {
			return ((MediaLayer) layer).isVectorLayer();
		}

		return false;
	}

	public static boolean isCTCR(Layer layer) {
		if (layer instanceof TextLayer) {
			return ((TextLayer) layer).isCTCR();
		}

		if (layer instanceof MediaItemLayer) {
			MediaItemLayer miLayer = (MediaItemLayer) layer;
			return miLayer.isCTCR() && (miLayer.isPrecompositionLayer() || miLayer.isVectorLayer());
		}

		if (layer instanceof MediaLayer) {
			return ((MediaLayer) layer).isVectorLayer();
		}

		return false;
	}

	public static void setCTCR(Layer layer, boolean ctcr) {
		if (layer instanceof TextLayer) {
			((TextLayer) layer).setCTCR(ctcr);
			return;
		}

		if (layer instanceof MediaItemLayer) {
			MediaItemLayer miLayer = (MediaItemLayer) layer;
			if (miLayer.isPrecompositionLayer() || miLayer.isVectorLayer()) {
				miLayer.setCTCR(ctcr);
				return;
			}

			//throw new UnsupportedOperationException(); 
		}

		throw new UnsupportedOperationException(); 
	}

	public static boolean isQualityNature(Layer layer) {
		return (layer instanceof MediaLayer);
	}

	public static Quality getQuality(Layer layer) {
		if (layer instanceof MediaLayer) {
			return ((MediaLayer) layer).getQuality();
		}

		return Quality.NORMAL;
	}

	public static void setQuality(Layer layer, Quality quality) {
		if (layer instanceof MediaLayer) {
			((MediaLayer) layer).setQuality(quality);
			return;
		}

		throw new UnsupportedOperationException(); 
	}

	public static boolean isFrameBlendNature(Layer layer) {
		if (layer instanceof MediaItemLayer) {
			MediaItemLayer miLayer = (MediaItemLayer) layer;
			MediaInput input = miLayer.getMediaInput();
			return (!miLayer.isPrecompositionLayer()
					&& input.isVideoAvailable()
					&& input.getVideoFrameDuration() != null
					&& input.getVideoFrameDuration().timeValue > 0);
		}

		return false;
	}

	public static FrameBlend getFrameBlend(Layer layer) {
		if (isFrameBlendNature(layer)) {
			return ((MediaItemLayer) layer).getFrameBlend();
		}

		return FrameBlend.NONE;
	}

	public static void setFrameBlend(Layer layer, FrameBlend frameBlend) {
		if (isFrameBlendNature(layer)) {
			((MediaItemLayer) layer).setFrameBlend(frameBlend);
			return;
		}

		throw new UnsupportedOperationException(); 
	}

	public static boolean isMotionBlurNature(Layer layer) {
		return (layer instanceof MediaLayer);
	}

	public static MotionBlur getMotionBlur(Layer layer) {
		if (layer instanceof MediaLayer) {
			return ((MediaLayer) layer).getMotionBlur();
		}

		return MotionBlur.NONE;
	}

	public static void setMotionBlur(Layer layer, MotionBlur motionBlur) {
		if (layer instanceof MediaLayer) {
			((MediaLayer) layer).setMotionBlur(motionBlur);
			return;
		}

		throw new UnsupportedOperationException(); 
	}

	public static boolean isThreeDNature(Layer layer) {
		if (layer instanceof MediaLayer) {
			MediaLayer mediaLayer = (MediaLayer) layer;
			return mediaLayer.isVideoNature();
		}

		if (layer instanceof TransformableLayer) {
			return true;
		}

		if (layer instanceof CameraLayer) {
			return true;
		}

		if (layer instanceof LightLayer) {
			return true;
		}

		return false;
	}

	public static boolean isThreeD(Layer layer) {
		if (layer instanceof MediaLayer) {
			MediaLayer mediaLayer = (MediaLayer) layer;
			return mediaLayer.isVideoNature()
				&& mediaLayer.isThreeD();
		}

		if (layer instanceof TransformableLayer) {
			return ((TransformableLayer) layer).isThreeD();
		}

		if (layer instanceof CameraLayer) {
			return true;
		}

		if (layer instanceof LightLayer) {
			return true;
		}

		return false;
	}

	public static void setThreeD(Layer layer, boolean threeD) {
		if (layer instanceof MediaLayer) {
			MediaLayer mediaLayer = (MediaLayer) layer;
			if (mediaLayer.isVideoNature()) {
				mediaLayer.setThreeD(threeD);
				return;
			} else {
				throw new UnsupportedOperationException();
			}
		}

		if (layer instanceof TransformableLayer) {
			((TransformableLayer) layer).setThreeD(threeD);
			return;
		}

		throw new UnsupportedOperationException();
	}

	public static boolean isTimeRemapNature(Layer layer) {
		if (layer instanceof MediaLayer) {
			MediaLayer mediaLayer = (MediaLayer) layer;
			MediaInput input = mediaLayer.getMediaInput();
			return (input != null && input.getDuration() != null);
		}

		return false;
	}

	public static boolean isTimeRemapEnabled(Layer layer) {
		return isTimeRemapNature(layer)
			&& ((MediaLayer) layer).getTimeRemap().hasKeyframe();
	}


	private LayerNature() { }

}
