/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core;

import ch.kuramo.javie.api.BlendMode;
import ch.kuramo.javie.api.IAudioBuffer;
import ch.kuramo.javie.core.VideoLayerRenderer.GeneralLayerRenderer;

public interface MediaLayer extends TransformableLayer, EffectableLayer {

	boolean isVideoNature();

	boolean isAudioNature();


	boolean isVideoEnabled();

	void setVideoEnabled(boolean enabled);

	boolean isAudioEnabled();

	void setAudioEnabled(boolean enabled);


	Quality getQuality();

	void setQuality(Quality quality);

	MotionBlur getMotionBlur();

	void setMotionBlur(MotionBlur motionBlur);

	TrackMatte getTrackMatte();

	void setTrackMatte(TrackMatte trackMatte);


	AnimatableDouble getOpacity();

	BlendMode getBlendMode();

	void setBlendMode(BlendMode blendMode);

	AnimatableVec2d getAudioLevels();

	AnimatableDouble getTimeRemap();


	CastsShadows getCastsShadows();

	void setCastsShadows(CastsShadows castsShadows);

	AnimatableDouble getLightTransmission();

	boolean isAcceptsShadows();

	void setAcceptsShadows(boolean acceptsShadows);

	boolean isAcceptsLights();

	void setAcceptsLights(boolean acceptsLights);

	AnimatableDouble getAmbient();

	AnimatableDouble getDiffuse();

	AnimatableDouble getSpecular();

	AnimatableDouble getShininess();

	AnimatableDouble getMetal();


	MediaInput getMediaInput();

	boolean isVectorLayer();


	GeneralLayerRenderer createVideoRenderer();

	IAudioBuffer renderAudioChunk(boolean rawSource);

}
