/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.internal.services;

import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Vec3d;
import ch.kuramo.javie.api.VideoBounds;
import ch.kuramo.javie.api.services.IAntiAliasSupport;
import ch.kuramo.javie.core.WrappedOperation;
import ch.kuramo.javie.core.services.RenderContext;
import ch.kuramo.javie.core.services.VideoRenderSupport;

import com.google.inject.Inject;

import ftgl.FTGL;
import ftgl.FTGLfont;

public class VideoRenderSupportImplOld implements VideoRenderSupport {

	@Inject
	private RenderContext _context;

	@Inject
	private IAntiAliasSupport _aaSupport;


	public void fillRectCR(
			IVideoBuffer resultBuffer,
			final double[] mvMatrix, final double[] prjMatrix,
			final Size2i size, final Color color) {

		final int resultTexture = resultBuffer.getTexture();
		final VideoBounds resultBounds = resultBuffer.getBounds();


		pushMatrixAndExecute(new WrappedOperation<Object>() {
			public Object execute() {
				final GL2 gl = _context.getGL().getGL2();

				gl.glViewport(0, 0, resultBounds.width, resultBounds.height);
				gl.glMatrixMode(GL2.GL_PROJECTION);
				gl.glLoadMatrixd(prjMatrix, 0);
				gl.glMatrixMode(GL2.GL_MODELVIEW);
				gl.glLoadMatrixd(mvMatrix, 0);


				gl.glFramebufferTexture2D(GL2.GL_FRAMEBUFFER,
						GL2.GL_COLOR_ATTACHMENT0, GL2.GL_TEXTURE_2D, resultTexture, 0);
				gl.glDrawBuffer(GL2.GL_COLOR_ATTACHMENT0);

				float[] savedColor = new float[4];
				gl.glGetFloatv(GL2.GL_CURRENT_COLOR, savedColor, 0);

				float a = (float)color.a;
				float r = (float)color.r * a;
				float g = (float)color.g * a;
				float b = (float)color.b * a;
				gl.glColor4f(r, g, b, a);

				_aaSupport.antiAlias(resultBounds.width, resultBounds.height, new Runnable() {
					public void run() {
						gl.glBegin(GL2.GL_QUADS);
						gl.glVertex2i(0, 0);
						gl.glVertex2i(size.width, 0);
						gl.glVertex2i(size.width, size.height);
						gl.glVertex2i(0, size.height);
						gl.glEnd();
					}
				});

				gl.glColor4fv(savedColor, 0);

				gl.glFramebufferTexture2D(GL2.GL_FRAMEBUFFER,
						GL2.GL_COLOR_ATTACHMENT0, GL2.GL_TEXTURE_2D, 0, 0);

				return null;
			}
		});
	}

	private void ortho2D(GL2 gl, GLU glu, int width, int height) {
		gl.glViewport(0, 0, width, height);

		gl.glMatrixMode(GL2.GL_PROJECTION);
		gl.glLoadIdentity();
		glu.gluOrtho2D(0, width, 0, height);

		gl.glMatrixMode(GL2.GL_MODELVIEW);
		gl.glLoadIdentity();
	}

	private <T> T pushMatrixAndExecute(WrappedOperation<T> operation) {
// TODO このメソッドは現在では不要。

//		GL2 gl = _context.getGL().getGL2();
//
//		int[] viewport = new int[4];
//		gl.glGetIntegerv(GL2.GL_VIEWPORT, viewport, 0);
//
//		int[] matrixMode = new int[1];
//		gl.glGetIntegerv(GL2.GL_MATRIX_MODE, matrixMode, 0);
//
//		double[] mvMatrix = new double[16];
//		double[] prjMatrix = new double[16];
//		getMatrix(mvMatrix, prjMatrix);
//
//		try {

			return operation.execute();

//		} finally {
//			setMatrix(mvMatrix, prjMatrix);
//			gl.glMatrixMode(matrixMode[0]);
//			gl.glViewport(viewport[0], viewport[1], viewport[2], viewport[3]);
//		}
	}

	public void multModelViewMatrix(
			Vec3d anchorPoint, Vec3d scale, Vec3d rotate, Vec3d orientation, Vec3d interest, Vec3d position) {

		GL2 gl = _context.getGL().getGL2();
		gl.glMatrixMode(GL2.GL_MODELVIEW);

		// 位置
		gl.glTranslatef((float) position.x, (float) position.y, (float) position.z);

		if (interest != null) {
			// 目標点
			double dx = interest.x - position.x;
			double dy = interest.y - position.y;
			double dz = interest.z - position.z;
			gl.glRotatef((float) Math.toDegrees(Math.atan2(dx, dz)), 0, 1, 0);
			gl.glRotatef((float) Math.toDegrees(-Math.atan2(dy, Math.sqrt(dx*dx+dz*dz))), 1, 0, 0);
		}

		// 方向
		gl.glRotatef((float) orientation.x, 1, 0, 0);
		gl.glRotatef((float) orientation.y, 0, 1, 0);
		gl.glRotatef((float) orientation.z, 0, 0, 1);

		// 回転
		gl.glRotatef((float) rotate.x, 1, 0, 0);
		gl.glRotatef((float) rotate.y, 0, 1, 0);
		gl.glRotatef((float) rotate.z, 0, 0, 1);

		// 拡大縮小
		gl.glScalef((float) (scale.x/100.0), (float) (scale.y/100.0), (float) (scale.z/100.0));

		// アンカーポイント
		gl.glTranslatef((float) -anchorPoint.x, (float) -anchorPoint.y, (float) -anchorPoint.z);
	}

	public void multModelViewMatrixInverse(
			Vec3d anchorPoint, Vec3d scale, Vec3d rotate, Vec3d orientation, Vec3d interest, Vec3d position) {

		GL2 gl = _context.getGL().getGL2();
		gl.glMatrixMode(GL2.GL_MODELVIEW);

		// アンカーポイント
		gl.glTranslatef((float) anchorPoint.x, (float) anchorPoint.y, (float) anchorPoint.z);

		// 拡大縮小
		gl.glScalef((float) (100.0/scale.x), (float) (100.0/scale.y), (float) (100.0/scale.z));

		// 回転
		gl.glRotatef((float) -rotate.z, 0, 0, 1);
		gl.glRotatef((float) -rotate.y, 0, 1, 0);
		gl.glRotatef((float) -rotate.x, 1, 0, 0);

		// 方向
		gl.glRotatef((float) -orientation.z, 0, 0, 1);
		gl.glRotatef((float) -orientation.y, 0, 1, 0);
		gl.glRotatef((float) -orientation.x, 1, 0, 0);

		// 目標点
		if (interest != null) {
			double dx = interest.x - position.x;
			double dy = interest.y - position.y;
			double dz = interest.z - position.z;
			gl.glRotatef((float) Math.toDegrees(Math.atan2(dy, Math.sqrt(dx*dx+dz*dz))), 1, 0, 0);
			gl.glRotatef((float) Math.toDegrees(-Math.atan2(dx, dz)), 0, 1, 0);
		}

		// 位置
		gl.glTranslatef((float) -position.x, (float) -position.y, (float) -position.z);
	}

	public void multCameraMatrix(
			Vec3d rotate, Vec3d orientation, Vec3d interest, Vec3d position, boolean flipZ) {

		double dx = interest.x - position.x;
		double dy = interest.y - position.y;
		double dz = interest.z - position.z;

		float _1 = flipZ ? -1 : 1;

		GL2 gl = _context.getGL().getGL2();
		gl.glMatrixMode(GL2.GL_MODELVIEW);

		// 回転
		gl.glRotatef((float) -rotate.z,  0,  0,  1);
		gl.glRotatef((float) -rotate.y,  0, _1,  0);
		gl.glRotatef((float) -rotate.x, _1,  0,  0);

		// 方向
		gl.glRotatef((float) -orientation.z,  0,  0,  1);
		gl.glRotatef((float) -orientation.y,  0, _1,  0);
		gl.glRotatef((float) -orientation.x, _1,  0,  0);

		// 目標点
		gl.glRotatef((float) Math.toDegrees(Math.atan2(dy, Math.sqrt(dx*dx+dz*dz))), _1, 0, 0);
		gl.glRotatef((float) Math.toDegrees(-Math.atan2(dx, dz)), 0, _1, 0);

		// 位置
		gl.glTranslatef((float) -position.x, (float) -position.y, (float) -position.z * _1);

		if (flipZ) {
			gl.glScalef(1, 1, -1);
		}
	}

	public void multCameraMatrixInverse(
			Vec3d rotate, Vec3d orientation, Vec3d interest, Vec3d position) {

		double dx = interest.x - position.x;
		double dy = interest.y - position.y;
		double dz = interest.z - position.z;

		GL2 gl = _context.getGL().getGL2();
		gl.glMatrixMode(GL2.GL_MODELVIEW);

		// 位置
		gl.glTranslatef((float) position.x, (float) position.y, (float) position.z);

		// 目標点
		gl.glRotatef((float) Math.toDegrees(Math.atan2(dx, dz)), 0, 1, 0);
		gl.glRotatef((float) Math.toDegrees(-Math.atan2(dy, Math.sqrt(dx*dx+dz*dz))), 1, 0, 0);

		// 方向
		gl.glRotatef((float) orientation.x, 1, 0, 0);
		gl.glRotatef((float) orientation.y, 0, 1, 0);
		gl.glRotatef((float) orientation.z, 0, 0, 1);

		// 回転
		gl.glRotatef((float) rotate.x, 1, 0, 0);
		gl.glRotatef((float) rotate.y, 0, 1, 0);
		gl.glRotatef((float) rotate.z, 0, 0, 1);
	}

	public void getMatrix(double[] mvMatrix, double[] prjMatrix) {
		GL2 gl = _context.getGL().getGL2();
		if (mvMatrix != null) {
			gl.glGetDoublev(GL2.GL_MODELVIEW_MATRIX, mvMatrix, 0);
		}
		if (prjMatrix != null) {
			gl.glGetDoublev(GL2.GL_PROJECTION_MATRIX, prjMatrix, 0);
		}
	}

	public void setMatrix(double[] mvMatrix, double[] prjMatrix) {
		GL2 gl = _context.getGL().getGL2();
		if (prjMatrix != null) {
			gl.glMatrixMode(GL2.GL_PROJECTION);
			gl.glLoadMatrixd(prjMatrix, 0);
		}
		if (mvMatrix != null) {
			gl.glMatrixMode(GL2.GL_MODELVIEW);
			gl.glLoadMatrixd(mvMatrix, 0);
		}
	}

	public void renderText(
			final FTGLfont font, final Color fillColor,
			final String[] texts, final double[][] offsets,
			IVideoBuffer resultBuffer) {

		final VideoBounds resultBounds = resultBuffer.getBounds();
		if (resultBounds.isEmpty()) {
			return;
		}

		final int resultTexture = resultBuffer.getTexture();

		pushMatrixAndExecute(new WrappedOperation<Object>() {
			public Object execute() {
				GL2 gl = _context.getGL().getGL2();
				GLU glu = _context.getGLU();

				float scale = (float) _context.getVideoResolution().scale;

				ortho2D(gl, glu, resultBounds.width, resultBounds.height);
				gl.glTranslatef((float) -resultBounds.x, (float) -resultBounds.y, 0);

				double[] mvMatrix = new double[16];
				getMatrix(mvMatrix, null);

				gl.glFramebufferTexture2D(GL2.GL_FRAMEBUFFER,
						GL2.GL_COLOR_ATTACHMENT0, GL2.GL_TEXTURE_2D, resultTexture, 0);
				gl.glDrawBuffer(GL2.GL_COLOR_ATTACHMENT0);

				// これをしておかないと ftglRenderFont 内の glEnable(GL_TEXTURE_2D) でエラー1282になる。
				gl.glActiveTexture(GL2.GL_TEXTURE0);

				float[] savedColor = new float[4];
				gl.glGetFloatv(GL2.GL_CURRENT_COLOR, savedColor, 0);

				gl.glColor4f((float)fillColor.r, (float)fillColor.g, (float)fillColor.b, (float)fillColor.a);

				// オリジナルのFTGLは内部でアルファブレンドの設定を行っているが、Javieはそれを無効にした修正版FTGLを使用している。
				// Javieには次のアルファブレンドが必要なため。
				gl.glEnable(GL2.GL_BLEND);
				gl.glBlendFuncSeparate(GL2.GL_SRC_ALPHA, GL2.GL_ONE_MINUS_SRC_ALPHA, GL2.GL_ONE, GL2.GL_ONE_MINUS_SRC_ALPHA);

				for (int i = 0; i < texts.length; ++i) {
					setMatrix(mvMatrix, null);
					gl.glTranslatef((float)offsets[i][0], (float)offsets[i][1], 0);
					gl.glScalef(scale, -scale, scale);
					FTGL.ftglRenderFont(font, texts[i], FTGL.FTGL_RENDER_ALL);
				}

				gl.glDisable(GL2.GL_BLEND);

				gl.glColor4fv(savedColor, 0);

				gl.glFramebufferTexture2D(GL2.GL_FRAMEBUFFER,
						GL2.GL_COLOR_ATTACHMENT0, GL2.GL_TEXTURE_2D, 0, 0);

				return null;
			}
		});
	}

	public void renderText(
			final FTGLfont font, final Color fillColor, final String[] texts, final double[][] offsets,
			IVideoBuffer resultBuffer, final double[] mvMatrix, final double[] prjMatrix) {

		final int resultTexture = resultBuffer.getTexture();
		final VideoBounds resultBounds = resultBuffer.getBounds();

		pushMatrixAndExecute(new WrappedOperation<Object>() {
			public Object execute() {
				final GL2 gl = _context.getGL().getGL2();

				final float scale = (float) _context.getVideoResolution().scale;

				gl.glViewport(0, 0, resultBounds.width, resultBounds.height);
				gl.glMatrixMode(GL2.GL_PROJECTION);
				gl.glLoadMatrixd(prjMatrix, 0);
				gl.glMatrixMode(GL2.GL_MODELVIEW);
				gl.glLoadMatrixd(mvMatrix, 0);

				final double[] mvMatrix = new double[16];
				getMatrix(mvMatrix, null);


				gl.glFramebufferTexture2D(GL2.GL_FRAMEBUFFER,
						GL2.GL_COLOR_ATTACHMENT0, GL2.GL_TEXTURE_2D, resultTexture, 0);
				gl.glDrawBuffer(GL2.GL_COLOR_ATTACHMENT0);

				// これをしておかないと ftglRenderFont 内の glEnable(GL_TEXTURE_2D) でエラー1282になる。
				gl.glActiveTexture(GL2.GL_TEXTURE0);

				float[] savedColor = new float[4];
				gl.glGetFloatv(GL2.GL_CURRENT_COLOR, savedColor, 0);

				float a = (float)fillColor.a;
				float r = (float)fillColor.r * a;
				float g = (float)fillColor.g * a;
				float b = (float)fillColor.b * a;
				gl.glColor4f(r, g, b, a);

				_aaSupport.antiAlias(resultBounds.width, resultBounds.height, new Runnable() {
					public void run() {
						for (int i = 0; i < texts.length; ++i) {
							setMatrix(mvMatrix, null);
							gl.glTranslatef((float)offsets[i][0], (float)offsets[i][1], 0);
							gl.glScalef(scale, -scale, scale);
							FTGL.ftglRenderFont(font, texts[i], FTGL.FTGL_RENDER_ALL);
						}
					}
				});

				gl.glColor4fv(savedColor, 0);

				gl.glFramebufferTexture2D(GL2.GL_FRAMEBUFFER,
						GL2.GL_COLOR_ATTACHMENT0, GL2.GL_TEXTURE_2D, 0, 0);

				return null;
			}
		});
	}

}
