/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.output;

import java.io.File;

import ch.kuramo.javie.api.AudioMode;
import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.core.Composition;

public abstract class Output {

	public enum VideoChannels { RGB, ALPHA, RGBA_STRAIGHT, RGBA_PREMULTIPLIED }


	private Composition composition;

	private boolean videoEnabled = true;

	private boolean audioEnabled = true;

	private VideoChannels videoChannels = VideoChannels.RGB;

	private Color colorMatte = Color.BLACK;

	private AudioMode audioMode = AudioMode.STEREO_48KHZ_INT16;

	private File file;


	public Composition getComposition() {
		return composition;
	}

	public void setComposition(Composition composition) {
		this.composition = composition;
	}

	public boolean isVideoEnabled() {
		return videoEnabled;
	}

	public void setVideoEnabled(boolean videoEnabled) {
		this.videoEnabled = videoEnabled;
	}

	public boolean isAudioEnabled() {
		return audioEnabled;
	}

	public void setAudioEnabled(boolean audioEnabled) {
		this.audioEnabled = audioEnabled;
	}

	public VideoChannels getVideoChannels() {
		return videoChannels;
	}

	public void setVideoChannels(VideoChannels videoChannels) {
		this.videoChannels = videoChannels;
	}

	public Color getColorMatte() {
		return colorMatte;
	}

	public void setColorMatte(Color colorMatte) {
		this.colorMatte = colorMatte;
	}

	public AudioMode getAudioMode() {
		return audioMode;
	}

	public void setAudioMode(AudioMode audioMode) {
		this.audioMode = audioMode;
	}

	public File getFile() {
		return file;
	}

	public void setFile(File file) {
		this.file = file;
	}


	public abstract void doOutput(ProgressMonitor progMon);

}
