/*
 * Copyright (c) 2009,2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.core.services;

import ch.kuramo.javie.api.Color;
import ch.kuramo.javie.api.IVideoBuffer;
import ch.kuramo.javie.api.Size2i;
import ch.kuramo.javie.api.Vec3d;
import ftgl.FTGLfont;

public interface VideoRenderSupport {

	void fillRectCR(IVideoBuffer resultBuffer, double[] mvMatrix, double[] prjMatrix, Size2i size, Color color);


	void multModelViewMatrix(
			Vec3d anchorPoint, Vec3d scale, Vec3d rotate, Vec3d orientation, Vec3d interest, Vec3d position);

	void multModelViewMatrixInverse(
			Vec3d anchorPoint, Vec3d scale, Vec3d rotate, Vec3d orientation, Vec3d interest, Vec3d position);

	void multCameraMatrix(
			Vec3d rotate, Vec3d orientation, Vec3d interest, Vec3d position, boolean flipZ);

	void multCameraMatrixInverse(
			Vec3d rotate, Vec3d orientation, Vec3d interest, Vec3d position);

	void getMatrix(double[] mvMatrix, double[] prjMatrix);

	void setMatrix(double[] mvMatrix, double[] prjMatrix);


	void renderText(FTGLfont font, Color fillColor, String[] texts, double[][] offsets, IVideoBuffer resultBuffer);

	void renderText(
			FTGLfont font, Color fillColor, String[] texts, double[][] offsets,
			IVideoBuffer resultBuffer, double[] mvMatrix, double[] prjMatrix);

}
