/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

#pragma once

class ForcibleARGB32 : public CTransInPlaceFilter
{
public:
	ForcibleARGB32(LPUNKNOWN unk, HRESULT* hr);
	virtual ~ForcibleARGB32();

	CBasePin* GetPin(int n);
	HRESULT CheckInputType(const CMediaType* mtIn);
	HRESULT CheckTransform(const CMediaType* mtIn, const CMediaType* mtOut);
	HRESULT GetMediaType(int position, CMediaType* mediaType);
	HRESULT CompleteConnect(PIN_DIRECTION dir, IPin* receivePin);
	HRESULT Transform(IMediaSample* sample);
};

class ForcibleARGB32InputPin : public CTransInPlaceInputPin
{
public:
	ForcibleARGB32InputPin(LPCTSTR objectName, ForcibleARGB32* filter, HRESULT* hr, LPCWSTR pinName);
	virtual ~ForcibleARGB32InputPin();

    STDMETHODIMP EnumMediaTypes(IEnumMediaTypes** enumMediaTypes);
    HRESULT CheckMediaType(const CMediaType* mediaType);
};

class ForcibleARGB32OutputPin : public CTransInPlaceOutputPin
{
public:
	ForcibleARGB32OutputPin(LPCTSTR objectName, ForcibleARGB32* filter, HRESULT* hr, LPCWSTR pinName);
	virtual ~ForcibleARGB32OutputPin();

    STDMETHODIMP EnumMediaTypes(IEnumMediaTypes** enumMediaTypes);
    HRESULT CheckMediaType(const CMediaType* mediaType);
};
