/*
 * Copyright (c) 2010 Yoshikazu Kuramochi
 * All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package ch.kuramo.javie.app.views.layercomp;

import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

import ch.kuramo.javie.app.ImageUtil;
import ch.kuramo.javie.app.project.LayerCompMotionBlurOperation;
import ch.kuramo.javie.app.project.ProjectManager;
import ch.kuramo.javie.app.views.LayerCompositionView;
import ch.kuramo.javie.core.LayerComposition;

public class LayerCompMotionBlurAction extends Action {

	private final ProjectManager pm;

	private final LayerComposition comp;


	public LayerCompMotionBlurAction(final LayerCompositionView view) {
		super("モーションブラー", IAction.AS_CHECK_BOX);
		pm = ProjectManager.forWorkbenchWindow(view.getSite().getWorkbenchWindow());
		comp = view.getLayerComposition();

		setImageDescriptor(ImageUtil.getCompositionMotionBlurIcon());
		setChecked(comp.isMotionBlurEnabled());


		final IOperationHistoryListener historyListener = new IOperationHistoryListener() {
			public void historyNotification(OperationHistoryEvent event) {
				switch (event.getEventType()) {
					case OperationHistoryEvent.REDONE:
					case OperationHistoryEvent.UNDONE:
						IUndoableOperation op = event.getOperation();
						if (op instanceof LayerCompMotionBlurOperation && op.hasContext(pm.getUndoContext())) {
							setChecked(comp.isMotionBlurEnabled());
						}
						break;
				}
			}
		};

		view.getSite().getPage().addPartListener(new IPartListener() {
			public void partActivated(IWorkbenchPart part) { }
			public void partBroughtToTop(IWorkbenchPart part) { }
			public void partDeactivated(IWorkbenchPart part) { }
			public void partOpened(IWorkbenchPart part) { }

			public void partClosed(IWorkbenchPart part) {
				if (part == view) {
					PlatformUI.getWorkbench().getOperationSupport()
							.getOperationHistory().removeOperationHistoryListener(historyListener);
				}
			}
		});

		PlatformUI.getWorkbench().getOperationSupport()
				.getOperationHistory().addOperationHistoryListener(historyListener);
	}

	@Override
	public void run() {
		pm.postOperation(new LayerCompMotionBlurOperation(pm, comp, isChecked()));
	}

}
